/**
 *
 * @file     types.h
 * @author   Aleix Conchillo Flaque <aleix@member.fsf.org>
 * @date     Wed Jul 30, 2003 00:51
 * @brief
 *
 * $Id$
 *
 * @if copyright
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * @endif
 */


#ifndef TYPES_H_ALEIX0307300051
#define TYPES_H_ALEIX0307300051

#include <glib.h>
#include <gtk/gtk.h>
#include <panel-applet.h>

typedef struct
{
    GtkWidget *image;         /* button image */
    GtkWidget *button;        /* image container */
    const gchar* stock_id;    /* theme image stock identifier */
} XMMSButton;

typedef struct
{
    GtkWidget *applet;
    GtkWidget *frame;
    GtkWidget *main_box;
    GtkTooltips *tooltips;
    GtkIconSize icon_size;
    gint size;                /* applet size */
    PanelAppletOrient orient; /* applet orientation */
    gint timeout_hnd;         /* timeout handler identifier */
    gulong cfg_hnd;           /* configure_event handler identifier */
    gulong exp_hnd;           /* expose_event handler identifier */
    gint session;             /* XMMS session */
    struct
    {
        GtkWidget *progress;  /* progress bar */
        GtkWidget *box;       /* all widgets go inside this one */
    } track_control;
    struct
    {
        XMMSButton prev;
        XMMSButton play_pause;
        XMMSButton stop;
        XMMSButton next;
        XMMSButton eject;
        GtkWidget *box;       /* all widgets go inside this one */
    } play_control;
} XMMSData;

#endif /* TYPES_H_ALEIX0307300051 */
