/**
 *
 * @file     playerctrl.h
 * @author   Aleix Conchillo Flaque <aleix@member.fsf.org>
 * @date     Thu Aug 07, 2003 21:20
 * @brief    Player control functions
 *
 * $Id: playerctrl.h,v 1.3 2004/12/30 00:24:11 aleix Exp $
 *
 * @if copyright
 *
 * Copyright (C) 2003, 2004 Aleix Conchillo Flaque
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * @endif
 */


#ifndef PLAYERCTRL_H_ALEIX0308072120
#define PLAYERCTRL_H_ALEIX0308072120

#include "types.h"


void player_start(XMMSData *xmms);

gboolean player_is_running(XMMSData *xmms);

gboolean player_is_playing(XMMSData *xmms);

gboolean player_is_repeat(XMMSData *xmms);

gboolean player_is_shuffle(XMMSData *xmms);

gboolean player_is_main_win(XMMSData *xmms);

gboolean player_is_pl_win(XMMSData *xmms);

gboolean player_is_eq_win(XMMSData *xmms);

gint player_get_output_time(XMMSData *xmms);

gint player_get_playlist_pos(XMMSData *xmms);

gchar* player_get_playlist_title(XMMSData *xmms, gint pos);

gint player_get_playlist_time(XMMSData *xmms, gint pos);

void player_quit(XMMSData *xmms);

void player_prev(XMMSData *xmms);

void player_play_pause(XMMSData *xmms);

void player_stop(XMMSData *xmms);

void player_next(XMMSData *xmms);

void player_eject(XMMSData *xmms);

void player_seek(XMMSData *xmms, gdouble t);

void player_repeat(XMMSData *xmms, gboolean active);

void player_shuffle(XMMSData *xmms, gboolean active);

void player_main_win(XMMSData *xmms, gboolean toggle);

void player_pl_win(XMMSData *xmms, gboolean toggle);

void player_eq_win(XMMSData *xmms, gboolean toggle);

void player_show_hide(XMMSData *xmms);

void player_preferences(XMMSData *xmms);

void player_lower_volume(XMMSData *xmms);

void player_raise_volume(XMMSData *xmms);

#endif /* PLAYERCTRL_H_ALEIX0308072120 */
