/*
  gyrus-preferences.c - Preferences for the GNOME Cyrus Administrator.

  GYRUS -- GNOME Cyrus Administrator.

  Copyright (C) 2004 Claudio Saavedra V.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
  
*/

#include <config.h>

#include <glade/glade.h>

#include "glib/gi18n.h"
#include "gyrus-preferences.h"

void
gyrus_preferences_show_dialog (void)
{
	GladeXML *xml;
       	gchar *file_glade;
	GtkWidget *window_preferences;

	file_glade = g_strdup_printf ("%s%c%s", GYRUS_GLADE_DIR,
				      G_DIR_SEPARATOR, "preferences.glade");
	xml = glade_xml_new (file_glade, NULL, NULL);

	window_preferences = glade_xml_get_widget (xml, "preferences");
	g_free (file_glade);
	
	gtk_widget_show_all (window_preferences);
	g_object_unref (xml);
	
}
