Summary: Haddock documentation tool for annotated Haskell source code
Name: haddock
Version: 0.7
Release: 1
License: BSD-like
Group: Development/Tools
Source: http://www.haskell.org/haddock/haddock-%{version}-src.tar.gz
URL: http://www.haskell.org/haddock/
BuildRoot: %{_tmppath}/%{name}-%{version}-root
BuildRequires: ghc alex libxslt docbook-style-xsl

%description
Haddock is a tool for automatically generating documentation from
annotated Haskell source code. It is primary intended for documenting
libraries, but it should be useful for any kind of Haskell code.

Haddock lets you write documentation annotations next to the
definitions of functions and types in the source code, in a syntax
that is easy on the eye when writing the source code (no heavyweight
mark-up). The documentation generated by Haddock is fully hyperlinked
-- click on a type name in a type signature to go straight to the
definition, and documentation, for that type.

Haddock can generate documentation in multiple formats; currently HTML
is implemented, and there is partial support for generating DocBook.
The generated HTML uses stylesheets, so you need a fairly up-to-date
browser to view it properly (Mozilla, Konqueror, Opera, and IE 6
should all be ok).

%prep
%setup -q

%build
./configure --prefix=%{_prefix} --libdir=%{_libdir}
make
(cd haddock/doc ; make html )

%install
rm -rf ${RPM_BUILD_ROOT}
%makeinstall

mkdir ${RPM_BUILD_ROOT}%{_datadir}/%{name}-%{version}
find ${RPM_BUILD_ROOT}%{_datadir} -type f | xargs mv --target-directory=${RPM_BUILD_ROOT}%{_datadir}/%{name}-%{version}

sed -i -e "s!%{_libdir}/%{name}-%{version}!%{_libexecdir}!" ${RPM_BUILD_ROOT}%{_bindir}/%{name}-%{version}

%clean
rm -rf ${RPM_BUILD_ROOT}

%files
%defattr(-,root,root)
%doc haddock/README
%doc haddock/doc/haddock
%{_bindir}/haddock
%{_bindir}/haddock-%{version}
%{_libexecdir}/haddock.bin
%{_datadir}/haddock-%{version}

%changelog
* Tue Jul  5 2005 Jens Petersen <petersen@haskell.org>
- update filelist
- install data files in a subdir

* Wed Dec 15 2004 Jens Petersen <petersen@haskell.org>
- spec file cleanup
- only generate docs in html

* Sat Oct 11 2003 Sven Panne <sven_panne@yahoo.com>
- Include architecture-independent files in file list

* Tue Aug 26 2003 Sven Panne <sven_panne@yahoo.com>
- Use autoreconf instead of autoconf

* Mon Jul 28 2003 Sven Panne <sven_panne@yahoo.com>
- Updated to version 0.5
- Automagically generate configure if it is not there

* Tue Jul 23 2002 Simon Marlow <simonmar@microsoft.com>
- Updated to version 0.4

* Sun Jun 23 2002 Sven Panne <sven_panne@yahoo.com>
- Cleaned up build root handling and added more docs

* Wed May 01 2002 Tom Moertel <tom-rpms@moertel.com>
- Created spec file
