//
// $Id: if.cc,v 1.1.1.1 2000/11/29 13:20:38 dredd Exp $
//
// $Source: /cvsroot/hammerhead/hammerhead/src/if.cc,v $
// $Revision: 1.1.1.1 $
// $Date: 2000/11/29 13:20:38 $
// $State: Exp $
//
// Author: Geoff Wong / Mick Dwyer
// Note: Code used (modified) from "Advanced Unix Programming" by Stevens.
//

#include "if.h"


If::If()
{
    altif = NULL;
}

If::If(long ai)
{
    altif = NULL;
    Ifget(ai);
}

If::~If()
{
    delete [] (char *) altif;
}

char * If::Ifconf(int sockfd, int *len)
{
	char *buf;
	int bufLen;
	int nbuf;
	struct ifconf ifc;

	*len = 0;
	nbuf=MIN_IFS;

	while (nbuf < MAX_IFS)
	{
		bufLen=nbuf*sizeof(struct ifreq);

		buf=new char[bufLen];

        if (buf == NULL) exit(2);

		ifc.ifc_len=bufLen;
		ifc.ifc_buf=buf;

		if(ioctl(sockfd,SIOCGIFCONF,&ifc) < 0) 
		{
			if(errno != EINVAL || *len != 0)
				fprintf(stderr, "ifget: ioctl error\n");
		} 
		else 
		{
			if(ifc.ifc_len == *len)
			{
				*len = ifc.ifc_len;
				break;
			}
			*len=ifc.ifc_len;
		}

		delete [] buf;
		buf = NULL;
		nbuf = nbuf * 2;
	}
	return(buf);
}

struct ifreq * If::Ifreq()
{
    return altif;
}

void If::Ifget(long ipaddr)
{
	char *buf,*ptr;
	int len;
	int l;
    int sockfd;
	struct ifreq *ifr;
	struct sockaddr_in *sa_in;

    _ipaddr = ipaddr;

     if((sockfd=socket(AF_INET,SOCK_DGRAM,0)) == -1)
               fprintf(stderr,"If::Ifget: Bad socket\n");

	buf = Ifconf(sockfd, &len);

	for(ptr=buf;ptr < buf+len;) 
	{
		ifr=(struct ifreq *)ptr;

#ifdef SA_LEN_IN_SOCKADDR
		l = ifr->ifr_addr.sa_len + sizeof(ifr->ifr_name);
                if (l < (signed)sizeof(*ifr))
                        l = sizeof(*ifr);
#else
		l = sizeof(ifr->ifr_name)+sizeof(struct sockaddr);
#endif

		sa_in=(struct sockaddr_in *)&ifr->ifr_addr;
#if 0
        fprintf(stderr, "If::Ifget (after conf=%d, sa_in=%d)\n", ipaddr, sa_in->sin_addr.s_addr); 
#endif
        if (ipaddr == (signed)sa_in->sin_addr.s_addr)
        {
                /* A match! */
                fprintf(stderr, "If::Ifget (matched (%s) - creating altif)\n",
                        inet_ntoa(sa_in->sin_addr)); 
                if (altif != NULL) delete [] (char *) altif;
                altif = (struct ifreq *) new char[l];
                memcpy(altif, ifr, l);
        }
#ifdef DEBUG
		fprintf(stderr, "%s %s %s\n", name, inet_ntoa(sa_in->sin_addr), ifr->ifr_name);
#endif

		ptr+=l;
	}
	delete [] buf;
}


long If::Ipaddr()
{
    return _ipaddr;
}
