
//
// $Id: scenario.h,v 1.7 2003/03/03 23:18:48 dredd Exp $
//
// $Source: /cvsroot/hammerhead/hammerhead/src/scenario.h,v $
// $Revision: 1.7 $
// $Date: 2003/03/03 23:18:48 $
// $State: Exp $
//
// Author: Geoff Wong, 1996-2001.
//
// Scenario Class - handle test scenarios
// 20010710 Robert Nielson - POST verbose and better cookie handling
//

#ifndef _SCENARIO_H
#define _SCENARIO_H

#include <stdio.h>
#include <list>

#include "result.h"
#include "session.h"
#include "dictionary.h"
#include "String.h"
#include "connection.h"
#include "hrtime.h"

class Scenario
{

    list<Scenario *>::iterator nposition;

public:
    static Dictionary<Scenario *> SCN;
    // Map of all scenarios

    static Dictionary<Scenario *> SEQ;
    // Map of all scenarios which area at the head of a sequence.

    static Dictionary<String *> allRequests;
    static Dictionary<list<String> *> allExpected;
    static FILE *logStream;
    static FILE *reportStream;

    static int lineNum;

    String name;
    // scenario's have names (= to file name?)!

    list<String> dependency;
    // scenerios that have been executed prior to this
    // being executed

    String * request;
    // request name
    // why is this a pointer?

    String request_base;
    // for relative requests made from within this page

    String header;
    // header lines (zero or more)

    String body;
    // body lines (zero or more)

    list<String> *expected;
    // lines that are expected
    // only need to be the start of the expected return string
    // may be regular expressions

    String log_expected;
    // expected log line
    // may be a regular expression
        
    list<String *> next;
    // "recommend" next scenarios
    // so we get "common" sequences
    // temporary var

    list<Scenario *> nextscenario;
    // "recommend" next scenarios
    // so we get "common" sequences

    int xrefsAllowed;
    // number of times to allow this scenario to be referenced in a sequence

    bool terminate;
    // this is a terminator scenario (thread will end after running this)

    int think;
    // number of microseconds to "think" (wait) for after request
    // note: the globally configured sleep time is added to this

    hrtime_t wait_until;
    // if this is set then we sleep until this time before continuing.

    int use_ssl;
    // should we do this through an SSL layer?

    int port;
    // use this port in the request.

    int head;
    // is this scenario at the head of a sequence (not referenced by any 
    // other scenario.)

    bool Restore(const char * name, FILE * fp);
    // PURPOSE: restore a scenario from named file

    bool Verify(Session * sess, Result * r);
    // PURPOSE: verify a result for correctness

    Result * Request(Session * sess);
    // PURPOSE: make the request
    // RETURN:  the resultant text from the request

    Connection *ConnectionFactory(Session *sess);
    // PURPOSE: make a connect to a server

    Scenario * SelectNext();
    // PURPOSE: select one of the random "next" elements

    void Log(String);
    // PURPOSE: write a string to the lgo

    void Resolve();
    // PURPOSE: convert scenario strings to iterators for fast lookup

    Scenario();
    // PURPOSE: constructor.
    
    ~Scenario();
    // PURPOSE: destructor.
};

#ifndef TRUE
#define TRUE 1
#define FALSE 0
#endif

#endif
