module UDPserver where

import HAppS hiding (noState,Request)
import qualified Network.Socket as N
import HAppS.Protocols.UDP


{--
The MACID monad presumes state.  So if you have no state then you can use the noState
handler to use () as your State type.
--}
noState :: Monad m => ServerPart (Ev () req) req  m res
noState = Handle $ return . Left

main :: IO ()
main = stdMain (udpServer impl :*: End)
    where impl = [ debugFilter
                 , Handle $ \(Request bs addr)-> return $ Right $ do putStrLn ("We're in the IO monad!")
                                                                     simpleSendUDP addr 9001 "Yo!\n"
                                                                     return ()
                 , noState
                 ]

simpleSendUDP (N.SockAddrInet _ ip) port msg =
    do fd <- N.socket N.AF_INET N.Datagram 0
--       a <- N.inet_addr addr
       let target = (N.SockAddrInet (fromIntegral port) ip)
       N.connect fd target
       ret <- N.send fd msg
       N.sClose fd
       putStrLn $ "I just sent "++show msg++" to "++show target++" and it returned: "++show ret