module HAppS.Protocols.HTTP.ServerPart where

-- import Control.Monad
import Control.Monad.Identity
import Data.List(isPrefixOf)
import qualified Data.ByteString.Char8 as P
import qualified Data.Map as Map

import qualified HAppS.Protocols.Base64 as Base64(decode)
import HAppS.Protocols.HTTP.Types
import HAppS.Protocols.SURI(path)

-- | HTTP server part. Maybe handles a request.
data ServerPart m req result 
    = MaybeHandle (req -> m (Maybe result))
    | MaybeHandles [req -> m (Maybe result)]
    | Handle (req -> m result)
    | Modify (req -> m req)
    | When (req -> m Bool) [ServerPart m req result]
    | Post (req -> result -> m result) -- ^ This will be run in reverse!
    | CondPost (req -> m Bool) (result -> (req -> m result)) -- ^ This will be run in reverse!

-- | Server parts to a simple handler.
compileServerParts :: Monad m => m resp -> [ServerPart m req resp] -> req ->
                      m resp
compileServerParts defResult = compile 
    where 
    compile (MaybeHandle  h : hs) req = maybe (compile hs req) return =<< h req
                                  --maybe (compile hs req) id =<< h req
    compile (MaybeHandles hs : hss) req = maybe (compile hss req) return =<< maybes req hs
    compile (Handle h       : _)  req = h req
    --compile (Handle h       : _)  req = h req >>= return . Just
    compile (Modify fun     : hs) req = compile hs =<< fun req
    compile (When fun ps    : hs) req = fun req >>= \b -> compile (if b then ps else hs) req
    compile (Post h         : hs) req = h req =<< compile hs req
    compile (CondPost fun h : hs) req = fun req >>= \b -> 
                                        (do res <- compile hs req 
                                            if b then h res req else return res
                                        )
    compile []                   _   = defResult --sresult 404 []

maybes _ [] = return Nothing
maybes req (h:hs) = h req >>= maybe (maybes req hs) (return . Just)



{--
[When (matchPref "/a") [fileServe "a"]
,When (matchPref "/b") [fileServe "b"]
]
[MaybeHandle (mbFileServe "/a" "a")
,MaybeHandle (mbFileServe "/b" "b")]
--}


-- | Basic authentication.
basicAuth :: Monad m => String -> Map.Map String String -> ServerPart m Request Result
basicAuth name amap = MaybeHandle $ \req -> do
    let err = return $ liftM (addHeader "WWW-Authenticate" ("Basic realm=\""++name++"\"")) $ sresult 401 []
    case getHeader "Authorization" req of
      Nothing -> err
      Just x  -> case break (':'==) $ Base64.decode $ P.unpack $ P.drop 6 x of
                   (name, ':':pass) | Map.lookup name amap == Just pass -> return Nothing
                   _                                                    -> err

-- | Fork part of requests to a sidetree.
--handleWith :: Monad m => String -> [ServerPart m request result] -> ServerPart m request result

{--
ext :: Ev st Request res -> ServerPart (EvPar res st)
ext x = Handle $ \req -> do f <- ask
                            liftIO $ f x req
--}

handleWith pref hs = When (return . w) hs
    where w req = pref `isPrefixOf` path (rqURI req)



--mbOp::(Monad m) => Request -> m (Maybe result) -> (Request->(Maybe result)) -> m (Maybe result)
--mbOp req mbRes h = mbRes >>= maybe (h req) return 
--maybes::(Monad m)=>Request -> [Request -> m (Maybe result)] -> m (Maybe result)

--hs = foldl (>>=) (return Nothing) (map (\h->maybe (h req) return) hs)
--foldl (mbOp req) Nothing hs

