#ifndef __DETAILS_H__
#define __DETAILS_H__

#include <gtk/gtk.h>
#include "config.h"

typedef struct _DetailWindow	DetailWindow;

struct _DetailWindow {
	GtkWidget *window;
	GtkWidget *vbox;
	GtkWidget *notebook;
	GtkWidget *icon;
	GtkWidget *name_label;

	gchar *device_name;
	gchar *device_type;
	gchar *manufacturer;
	
	GtkWidget *info_table;
	gint   last_info;
};

gboolean      detail_window_close(GtkWidget *widget, gpointer data);
DetailWindow *detail_window_new(void);
void	      detail_window_set_icon(DetailWindow *dw, const gchar *path);
void          detail_window_show(GtkWidget *widget, gpointer data);

void          detail_window_set_dev_name(DetailWindow *dw, const gchar *name);
void          detail_window_set_dev_type(DetailWindow *dw, const gchar *type);
void          detail_window_update_names(DetailWindow *dw);

void          detail_window_append_info(DetailWindow *dw, const gchar *name,
					gchar *val);
void          detail_window_append_info_int(DetailWindow *dw, const gchar *name,
					    gint val, gboolean hex);
void          detail_window_append_separator(DetailWindow *dw);
                              

#endif
