
/*
 * Hardware Information, version 0.3
 * Copyright (C) 2003 Leandro Pereira <leandro@linuxmag.com.br>
 *
 * May be modified and/or distributed under the terms of GNU GPL version 2.
 *
 */

#include "hardinfo.h"
#include "ide.h"

#include <stdlib.h>

IDEDevice *hi_scan_ide(void)
{
	FILE *proc_ide;
	gchar *device, iface;
	gint n = 0, i = 0;
	struct stat st;
	IDEDevice *ide_dev, *ide;
	
	ide = NULL;	
	
	for (i=0; i<=16; i++) {
		iface='a'+i;
		device = g_strdup_printf("/proc/ide/hd%c/model", iface);
		if (!stat(device, &st)) { 
			gchar buf[64];
			
			ide_dev = g_new0(IDEDevice, 1);
			ide_dev->next = ide;
			ide = ide_dev;
			
			proc_ide = fopen(device, "r");
			fgets(buf, 64, proc_ide);
			fclose(proc_ide);
			
			buf[strlen(buf)-1]=0;
			
			ide_dev->model = g_strdup(buf);
			
			g_free(device);
			
			device = g_strdup_printf("/proc/ide/hd%c/media", iface);
			proc_ide = fopen(device, "r");
			fgets(buf, 64, proc_ide);
			fclose(proc_ide);
			buf[strlen(buf)-1]=0;
			
			ide_dev->media = g_strdup(buf);
						
			g_free(device);
			
			device = g_strdup_printf("/proc/ide/hd%c/cache", iface);
			if (!stat(device, &st)) {
				proc_ide = fopen(device, "r");
				fgets(buf, 64, proc_ide);
				fclose(proc_ide);
			
				ide_dev->cache = atoi(buf);
			}					
			g_free(device);
			
			device = g_strdup_printf("/proc/ide/hd%c/geometry", iface);
			if (!stat(device, &st)) {
				gchar *tmp;
				
				proc_ide = fopen(device, "r");
		
				fgets(buf, 64, proc_ide);		
				for (tmp = buf; *tmp; tmp++) {
					if (*tmp >= '0' && *tmp <= '9') break;
				}
				
				ide_dev->phy_geometry = g_strdup(g_strstrip(tmp));
				
				fgets(buf, 64, proc_ide);
				for (tmp = buf; *tmp; tmp++) {
					if (*tmp >= '0' && *tmp <= '9') break;
				}
				ide_dev->log_geometry = g_strdup(g_strstrip(tmp));

				fclose(proc_ide);
			}					
			g_free(device);

			n++;
		} else 
			g_free(device);
	}
	
	return ide;
}

void hi_show_ide_info(MainWindow *mainwindow, IDEDevice *device)
{
        static struct {
                char *type;
                char *label;
                char *icon; 
        } type2icon[] = {   
                {"cdrom",       "CD-ROM",         "cd.png"},
                {"disk",	"Hard Disk",	  "hdd.png"}
        };
        int i;
	gchar *buf;

	if(!device) return;
	
	for (i = 0; type2icon[i].type != NULL; ++i) {
		if (!strcmp(device->media, type2icon[i].type)) break;
	}
	
	buf = g_strdup_printf("%s%s", IMG_PREFIX, type2icon[i].icon);
	detail_window_set_icon(mainwindow->det_window, buf);
	g_free(buf);	

	buf = g_strdup_printf(_("ATA/IDE %s Device"), type2icon[i].label);
	gtk_window_set_title(GTK_WINDOW(mainwindow->det_window->window), buf);
	detail_window_set_dev_type(mainwindow->det_window, buf);
	g_free(buf);

	detail_window_set_dev_name(mainwindow->det_window, device->model);
	
	if (device->cache) {
		detail_window_append_info_int(mainwindow->det_window, _("Cache (kb)"),
					      device->cache, FALSE);
	}	
	
	if (device->phy_geometry) {
		detail_window_append_info(mainwindow->det_window, _("Physical geometry"),
					      device->phy_geometry);
	}	
	if (device->log_geometry) {
		detail_window_append_info(mainwindow->det_window, _("Logical geometry"),
					      device->log_geometry);
	}	

}
