/*
 * Hardware Information, version 0.3
 * Copyright (C) 2003 Leandro Pereira <leandro@linuxmag.com.br>
 *
 * May be modified and/or distributed under the terms of GNU GPL version 2.
 *
 */

#include <gtk/gtk.h>

#include "hardinfo.h"
#include "modules.h"

void hi_show_module_info(MainWindow *mainwindow, ModInfo *device)
{
	if(!device) return;

	gtk_window_set_title(GTK_WINDOW(mainwindow->det_window->window), device->description);
	detail_window_set_icon(mainwindow->det_window, IMG_PREFIX "module.png");
 	detail_window_set_dev_name(mainwindow->det_window, device->name);
 	detail_window_set_dev_type(mainwindow->det_window, device->description);
 	
	if (device->author && strlen(device->author)) {
	 	detail_window_append_info(mainwindow->det_window, _("Author"),
 					  device->author);
		detail_window_append_separator(mainwindow->det_window);
	}

	if (device->license && strlen(device->license))
		detail_window_append_info(mainwindow->det_window, _("License"),
					  device->license);
					  
	if (device->depends &&strlen(device->depends))
		detail_window_append_info(mainwindow->det_window, _("Depends on"),
					  device->depends);					 
 				  
}

GtkWidget *module_get_widget(void)
{
#if 0
	GtkWidget *vbox, *hbbox, *scroll, *clist, *btn;

        vbox = gtk_vbox_new(FALSE, 5);
        gtk_container_set_border_width(GTK_CONTAINER(vbox), 4);
        gtk_widget_show(vbox);

        hbbox = gtk_hbutton_box_new();
        gtk_container_set_border_width(GTK_CONTAINER(hbbox), 4);
        gtk_widget_show(hbbox);
        gtk_box_pack_end(GTK_BOX(vbox), hbbox, FALSE, FALSE, 0);
        gtk_button_box_set_spacing(GTK_BUTTON_BOX(hbbox), 6);
        gtk_button_box_set_layout(GTK_BUTTON_BOX(hbbox), GTK_BUTTONBOX_END);

        btn = gtk_button_new_from_stock(HI_DETAILS);
        g_signal_connect(G_OBJECT(btn), "clicked",  
                         (GCallback) detail_window_show, mainwindow);
        gtk_widget_show(btn);
        gtk_box_pack_end(GTK_BOX(hbbox), btn, FALSE, FALSE, 0);
        mainwindow->details_button = btn;

        scroll = gtk_scrolled_window_new(NULL, NULL);
        gtk_box_pack_start(GTK_BOX(vbox), scroll, TRUE, TRUE, 0);
        gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scroll),
                                       GTK_POLICY_AUTOMATIC,
                                       GTK_POLICY_AUTOMATIC);

        ctree = gtk_ctree_new(2, 0);
        gtk_container_add(GTK_CONTAINER(scroll), ctree);
        gtk_widget_set_usize(GTK_WIDGET(ctree), 400, 300);
        gtk_ctree_set_expander_style(GTK_CTREE(ctree),
                                     GTK_CTREE_EXPANDER_TRIANGLE);
        gtk_ctree_set_line_style(GTK_CTREE(ctree), GTK_CTREE_LINES_NONE);
        gtk_clist_set_column_width(GTK_CLIST(ctree), 0, 32);
        gtk_clist_set_column_width(GTK_CLIST(ctree), 1, 32);
        gtk_clist_set_row_height(GTK_CLIST(ctree), 18);
        g_signal_connect(G_OBJECT(ctree), "tree-select-row",
                         (GCallback) hi_enable_details_button, mainwindow);
        g_signal_connect(G_OBJECT(ctree), "tree-unselect-row",
                         (GCallback) hi_disable_details_button, mainwindow);


	return vbox;
#endif

	return NULL;
}

#define SET_VAR(vname,var) \
	if (!strncmp(buffer, vname, strlen(vname))) { \
		gchar *_b = buffer; \
		while (*_b && *_b != ':') _b++; _b++; \
		while (*_b && (*_b == ' ' || *_b == '\t')) _b++; \
		modinfo->var = g_strdup(g_strstrip(_b)); \
	}

ModInfo *hi_scan_modules(void)
{
	FILE *lsmod;
	gchar buffer[256];
	ModInfo *modinfo = NULL, *mod = NULL;
	
	lsmod = popen("/sbin/lsmod", "r");
	if(!lsmod) return NULL;
	
	fgets(buffer, 256, lsmod);	/* Discards the first line */
	
	while(fgets(buffer, 256, lsmod)){
		gchar *start, *buf;
		FILE *modi;
		
		start = buf = buffer;
		
		walk_until_inclusive(' ');
		*buf = 0;				
		
		modinfo = g_new0(ModInfo, 1);
		
		modinfo->name = g_strdup(start);
		
		buf = g_strdup_printf("/sbin/modinfo %s", start);
		modi = popen(buf, "r");
		while (fgets(buffer, 256, modi)) {
			SET_VAR("author", author);
			SET_VAR("description", description);
			SET_VAR("license", license);
			SET_VAR("depends", depends);
		}
		pclose(modi);
		
		modinfo->next = mod;
		mod = modinfo;
	}
	pclose(lsmod);
	
	return mod;
}
