/*
 * Hardware Information, version 0.3
 * Copyright (C) 2003 Leandro Pereira <leandro@linuxmag.com.br>
 *
 * May be modified and/or distributed under the terms of GNU GPL version 2.
 */

#include <stdio.h>
#include "config.h"
#include "hardinfo.h"
#include "net.h"

gboolean net_update(gpointer data);

GtkWidget *net_get_widget(MainWindow * mainwindow)
{
    return gtk_label_new("Not implemented yet.");
}

gboolean net_update(gpointer data)
{
    MainWindow *mainwindow = (MainWindow *) data;
    NetDevice *net;
    static NetDevice *netold = NULL;
    
    if (!mainwindow)
	return FALSE;

    net = hi_scan_net();
    
    if (!net)
    	return FALSE;
    
    if (!netold) {
    	netold = net;
    } else {
	NetDevice *nd1, *nd2;
	
	for (nd1 = netold, nd2 = net; nd1 && nd2;
	     nd1 = nd1->next, nd2 = nd2->next) {
	     
	  	   g_print ("iface %s: %ld bytes/s up, %ld bytes/s down\n",
	  	   	   nd1->iface,
	  	   	   nd2->trans_bytes - nd1->trans_bytes,
	  	   	   nd2->recv_bytes - nd1->recv_bytes);
	} 		    	
	
	netold = net;
    }

    g_print("\n\n");
 
    return TRUE;
}

NetDevice *hi_scan_net(void)
{
    FILE *proc_net;
    gchar buffer[256];
    NetDevice *net_dev, *net;
    struct stat st;

    net = NULL;

    if (stat("/proc/net/dev", &st))
	return NULL;

    proc_net = fopen("/proc/net/dev", "r");
    while (fgets(buffer, 256, proc_net)) {
	if (strchr(buffer, ':')) {
	    gint trash;
	    gchar ifacename[16];
	    gchar *buf = buffer;
	    gint i;

	    net_dev = g_new0(NetDevice, 1);
	    net_dev->next = net;
	    net = net_dev;

	    buf = g_strstrip(buf);

	    memset(ifacename, 0, 16);

	    for (i = 0; buffer[i] != ':' && i < 16; i++) {
		ifacename[i] = buffer[i];
	    }

	    walk_until_inclusive(':');

	    /* iface: bytes packets errs drop fifo frame compressed multicast */
	    sscanf(buf, "%ld %ld %ld %d %d %d %d %d %ld %ld %ld",
		   &net_dev->recv_bytes, &net_dev->recv_packets,
		   &net_dev->recv_errors, &trash, &trash, &trash, &trash,
		   &trash, &net_dev->trans_bytes, &net_dev->trans_packets,
		   &net_dev->trans_errors);

	    g_print("%ld\n", net_dev->recv_bytes);

	    net_dev->iface = g_strdup(ifacename);
	}
    }
    fclose(proc_net);

    return net;
}
