--------------------------------------------------------------------------------
-- |
-- Module      :  Graphics.GL.ATI
-- Copyright   :  (c) Sven Panne 2016
-- License     :  BSD3
--
-- Maintainer  :  Sven Panne <svenpanne@gmail.com>
-- Stability   :  stable
-- Portability :  portable
--
-- A convenience module, combining all raw modules containing ATI extensions.
--
--------------------------------------------------------------------------------

module Graphics.GL.ATI (
  module Graphics.GL.ATI.DrawBuffers,
  module Graphics.GL.ATI.ElementArray,
  module Graphics.GL.ATI.EnvmapBumpmap,
  module Graphics.GL.ATI.FragmentShader,
  module Graphics.GL.ATI.MapObjectBuffer,
  module Graphics.GL.ATI.Meminfo,
  module Graphics.GL.ATI.PNTriangles,
  module Graphics.GL.ATI.PixelFormatFloat,
  module Graphics.GL.ATI.SeparateStencil,
  module Graphics.GL.ATI.TextFragmentShader,
  module Graphics.GL.ATI.TextureEnvCombine3,
  module Graphics.GL.ATI.TextureFloat,
  module Graphics.GL.ATI.TextureMirrorOnce,
  module Graphics.GL.ATI.VertexArrayObject,
  module Graphics.GL.ATI.VertexAttribArrayObject,
  module Graphics.GL.ATI.VertexStreams
) where

import Graphics.GL.ATI.DrawBuffers
import Graphics.GL.ATI.ElementArray
import Graphics.GL.ATI.EnvmapBumpmap
import Graphics.GL.ATI.FragmentShader
import Graphics.GL.ATI.MapObjectBuffer
import Graphics.GL.ATI.Meminfo
import Graphics.GL.ATI.PNTriangles
import Graphics.GL.ATI.PixelFormatFloat
import Graphics.GL.ATI.SeparateStencil
import Graphics.GL.ATI.TextFragmentShader
import Graphics.GL.ATI.TextureEnvCombine3
import Graphics.GL.ATI.TextureFloat
import Graphics.GL.ATI.TextureMirrorOnce
import Graphics.GL.ATI.VertexArrayObject
import Graphics.GL.ATI.VertexAttribArrayObject
import Graphics.GL.ATI.VertexStreams
