module Foreign.ForeignPtr
  ( ForeignPtr             -- abstract, instance of: Eq
  , newForeignPtr          -- :: Ptr a -> IO () -> IO (ForeignPtr a)
  , addForeignPtrFinalizer -- :: ForeignPtr a -> IO () -> IO ()
  , withForeignPtr         -- :: ForeignPtr a -> (Ptr a -> IO b) -> IO b
  , foreignPtrToPtr        -- :: ForeignPtr a -> Ptr a
  , touchForeignPtr        -- :: ForeignPtr a -> IO ()
  , castForeignPtr         -- :: ForeignPtr a -> ForeignPtr b
  ) where

import PreludeBuiltinTypes
import Foreign.BuiltinTypes
import qualified TraceOrigForeign.ForeignPtr

foreign import haskell "Foreign.ForeignPtr.newForeignPtr"
  newForeignPtr :: Ptr a -> IO () -> IO (ForeignPtr a)
foreign import haskell "Foreign.ForeignPtr.addForeignPtrFinalizer"
  addForeignPtrFinalizer :: ForeignPtr a -> IO () -> IO ()
foreign import haskell "Foreign.ForeignPtr.withForeignPtr"
  withForeignPtr :: ForeignPtr a -> (Ptr a -> IO b) -> IO b
foreign import haskell "Foreign.ForeignPtr.foreignPtrToPtr"
  foreignPtrToPtr :: ForeignPtr a -> Ptr a
foreign import haskell "Foreign.ForeignPtr.touchForeignPtr"
  touchForeignPtr :: ForeignPtr a -> IO ()
foreign import haskell "Foreign.ForeignPtr.castForeignPtr"
  castForeignPtr :: ForeignPtr a -> ForeignPtr b

--
foreign import haskell "Prelude.=="
  eqForeignPtr :: ForeignPtr a -> ForeignPtr a -> Bool
--foreign import haskell "Prelude.<="
--  leqForeignPtr :: ForeignPtr a -> ForeignPtr a -> Bool
foreign import haskell "Prelude.showsPrec"
  showsPrecForeignPtr :: Int -> ForeignPtr a -> String -> String

instance Eq (ForeignPtr a) where
  (==) = eqForeignPtr
--instance Ord (ForeignPtr a) where
--  (<=) = leqForeignPtr
instance Show (ForeignPtr a) where
  showsPrec = showsPrecForeignPtr
