module Hat.Data.PackedString
  (PackedString(),gpackString,apackString,hpackString,gunpackPS,aunpackPS
    ,hunpackPS,gnilPS,gconsPS,aconsPS,hconsPS,gheadPS,aheadPS,hheadPS,gtailPS
    ,atailPS,htailPS,gnullPS,anullPS,hnullPS,gappendPS,aappendPS,happendPS
    ,glengthPS,alengthPS,hlengthPS,gindexPS,aindexPS,hindexPS,gmapPS,amapPS
    ,hmapPS,gfilterPS,afilterPS,hfilterPS,greversePS,areversePS,hreversePS
    ,gconcatPS,aconcatPS,hconcatPS,gelemPS,aelemPS,helemPS,gsubstrPS,asubstrPS
    ,hsubstrPS,gtakePS,atakePS,htakePS,gdropPS,adropPS,hdropPS,gsplitAtPS
    ,asplitAtPS,hsplitAtPS,gfoldlPS,afoldlPS,hfoldlPS,gfoldrPS,afoldrPS,hfoldrPS
    ,gtakeWhilePS,atakeWhilePS,htakeWhilePS,gdropWhilePS,adropWhilePS
    ,hdropWhilePS,gspanPS,aspanPS,hspanPS,gbreakPS,abreakPS,hbreakPS,glinesPS
    ,alinesPS,hlinesPS,gwordsPS,awordsPS,hwordsPS,gsplitPS,asplitPS,hsplitPS
    ,gsplitWithPS,asplitWithPS,hsplitWithPS) where

import qualified Hat.PreludeBasic 
import qualified Prelude 
import Hat.Hack 
import qualified Hat.Hat as T 
import Hat.Hat  (WrapVal(wrapVal))
import Hat.Prelude 
import Hat.Data.PackedStringBuiltin 
import Hat.PreludeBuiltinTypes 
import qualified Data.PackedString 
import qualified Prelude 

gpackString :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun String PackedString)

gpackString ppackString p = T.ufun1 apackString ppackString p hpackString

hpackString z1packString kpackString =
  fromPackedString kpackString
    (Data.PackedString.packString (toString kpackString z1packString))

gunpackPS :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun PackedString String)

gunpackPS punpackPS p = T.ufun1 aunpackPS punpackPS p hunpackPS

hunpackPS z1unpackPS kunpackPS =
  fromString kunpackPS
    (Data.PackedString.unpackPS (toPackedString kunpackPS z1unpackPS))

gprimEqPackedString ::
  T.RefSrcPos -> T.RefExp -> T.R (T.Fun PackedString (T.Fun PackedString Bool))

gprimEqPackedString pprimEqPackedString p =
  T.ufun2 aprimEqPackedString pprimEqPackedString p hprimEqPackedString

hprimEqPackedString z1primEqPackedString z2primEqPackedString
  kprimEqPackedString =
  fromBool kprimEqPackedString
    ((toPackedString kprimEqPackedString z1primEqPackedString)
      Prelude.==
      (toPackedString kprimEqPackedString z2primEqPackedString))

gprimLePackedString ::
  T.RefSrcPos -> T.RefExp -> T.R (T.Fun PackedString (T.Fun PackedString Bool))

gprimLePackedString pprimLePackedString p =
  T.ufun2 aprimLePackedString pprimLePackedString p hprimLePackedString

hprimLePackedString z1primLePackedString z2primLePackedString
  kprimLePackedString =
  fromBool kprimLePackedString
    ((toPackedString kprimLePackedString z1primLePackedString)
      Prelude.<=
      (toPackedString kprimLePackedString z2primLePackedString))

gprimShowsPrecPackedString ::
  T.RefSrcPos ->
    T.RefExp -> T.R (T.Fun Int (T.Fun PackedString (T.Fun String String)))

gprimShowsPrecPackedString pprimShowsPrecPackedString p =
  T.ufun3 aprimShowsPrecPackedString pprimShowsPrecPackedString p
    hprimShowsPrecPackedString

hprimShowsPrecPackedString z1primShowsPrecPackedString
  z2primShowsPrecPackedString z3primShowsPrecPackedString
  kprimShowsPrecPackedString =
  fromString kprimShowsPrecPackedString
    (Prelude.showsPrec
      (T.toInt kprimShowsPrecPackedString z1primShowsPrecPackedString)
      (toPackedString kprimShowsPrecPackedString z2primShowsPrecPackedString)
      (toString kprimShowsPrecPackedString z3primShowsPrecPackedString))

instance Eq (PackedString)
  where
  
  (!==) (%==) p = T.uconstUse (%==) p (|==)
  
  (|==) =
    T.uconstDef T.mkRoot (+++=&=++=%$==)
      (\ p -> gprimEqPackedString T.mkNoSrcPos p)
  

instance Ord (PackedString)
  where
  
  (!<=) (%<=) p = T.uconstUse (%<=) p (|<=)
  
  (|<=) =
    T.uconstDef T.mkRoot (++@=&=+@=%$<=)
      (\ p -> gprimLePackedString T.mkNoSrcPos p)
  

instance Show (PackedString)
  where
  
  gshowsPrec pshowsPrec p = T.uconstUse pshowsPrec p sshowsPrec
  
  sshowsPrec =
    T.uconstDef T.mkRoot a70v3v70v39showsPrec
      (\ p -> gprimShowsPrecPackedString T.mkNoSrcPos p)
  

gnilPS :: T.RefSrcPos -> T.RefExp -> T.R PackedString

gnilPS pnilPS p = T.uconstUse pnilPS p snilPS

snilPS =
  T.uconstDef T.mkRoot anilPS
    (\ p -> fromPackedString p Data.PackedString.nilPS)

gconsPS ::
  T.RefSrcPos -> T.RefExp -> T.R (T.Fun Char (T.Fun PackedString PackedString))

gconsPS pconsPS p = T.ufun2 aconsPS pconsPS p hconsPS

hconsPS z1consPS z2consPS kconsPS =
  fromPackedString kconsPS
    (Data.PackedString.consPS (T.toChar kconsPS z1consPS)
      (toPackedString kconsPS z2consPS))

gheadPS :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun PackedString Char)

gheadPS pheadPS p = T.ufun1 aheadPS pheadPS p hheadPS

hheadPS z1headPS kheadPS =
  T.fromChar kheadPS
    (Data.PackedString.headPS (toPackedString kheadPS z1headPS))

gtailPS :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun PackedString PackedString)

gtailPS ptailPS p = T.ufun1 atailPS ptailPS p htailPS

htailPS z1tailPS ktailPS =
  fromPackedString ktailPS
    (Data.PackedString.tailPS (toPackedString ktailPS z1tailPS))

gnullPS :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun PackedString Bool)

gnullPS pnullPS p = T.ufun1 anullPS pnullPS p hnullPS

hnullPS z1nullPS knullPS =
  fromBool knullPS (Data.PackedString.nullPS (toPackedString knullPS z1nullPS))

gappendPS ::
  T.RefSrcPos ->
    T.RefExp -> T.R (T.Fun PackedString (T.Fun PackedString PackedString))

gappendPS pappendPS p = T.ufun2 aappendPS pappendPS p happendPS

happendPS z1appendPS z2appendPS kappendPS =
  fromPackedString kappendPS
    (Data.PackedString.appendPS (toPackedString kappendPS z1appendPS)
      (toPackedString kappendPS z2appendPS))

glengthPS :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun PackedString Int)

glengthPS plengthPS p = T.ufun1 alengthPS plengthPS p hlengthPS

hlengthPS z1lengthPS klengthPS =
  T.fromInt klengthPS
    (Data.PackedString.lengthPS (toPackedString klengthPS z1lengthPS))

gindexPS :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun PackedString (T.Fun Int Char))

gindexPS pindexPS p = T.ufun2 aindexPS pindexPS p hindexPS

hindexPS z1indexPS z2indexPS kindexPS =
  T.fromChar kindexPS
    (Data.PackedString.indexPS (toPackedString kindexPS z1indexPS)
      (T.toInt kindexPS z2indexPS))

gmapPS ::
  T.RefSrcPos ->
    T.RefExp -> T.R (T.Fun (T.Fun Char Char) (T.Fun PackedString PackedString))

gmapPS pmapPS p = T.ufun2 amapPS pmapPS p hmapPS

hmapPS z1mapPS z2mapPS kmapPS =
  fromPackedString kmapPS
    (Data.PackedString.mapPS ((toFun T.fromChar T.toChar) kmapPS z1mapPS)
      (toPackedString kmapPS z2mapPS))

gfilterPS ::
  T.RefSrcPos ->
    T.RefExp -> T.R (T.Fun (T.Fun Char Bool) (T.Fun PackedString PackedString))

gfilterPS pfilterPS p = T.ufun2 afilterPS pfilterPS p hfilterPS

hfilterPS z1filterPS z2filterPS kfilterPS =
  fromPackedString kfilterPS
    (Data.PackedString.filterPS ((toFun T.fromChar toBool) kfilterPS z1filterPS)
      (toPackedString kfilterPS z2filterPS))

greversePS :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun PackedString PackedString)

greversePS preversePS p = T.ufun1 areversePS preversePS p hreversePS

hreversePS z1reversePS kreversePS =
  fromPackedString kreversePS
    (Data.PackedString.reversePS (toPackedString kreversePS z1reversePS))

gconcatPS ::
  T.RefSrcPos -> T.RefExp -> T.R (T.Fun (T.List PackedString) PackedString)

gconcatPS pconcatPS p = T.ufun1 aconcatPS pconcatPS p hconcatPS

hconcatPS z1concatPS kconcatPS =
  fromPackedString kconcatPS
    (Data.PackedString.concatPS ((toList toPackedString) kconcatPS z1concatPS))

gelemPS :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun Char (T.Fun PackedString Bool))

gelemPS pelemPS p = T.ufun2 aelemPS pelemPS p helemPS

helemPS z1elemPS z2elemPS kelemPS =
  fromBool kelemPS
    (Data.PackedString.elemPS (T.toChar kelemPS z1elemPS)
      (toPackedString kelemPS z2elemPS))

gsubstrPS ::
  T.RefSrcPos ->
    T.RefExp -> T.R (T.Fun PackedString (T.Fun Int (T.Fun Int PackedString)))

gsubstrPS psubstrPS p = T.ufun3 asubstrPS psubstrPS p hsubstrPS

hsubstrPS z1substrPS z2substrPS z3substrPS ksubstrPS =
  fromPackedString ksubstrPS
    (Data.PackedString.substrPS (toPackedString ksubstrPS z1substrPS)
      (T.toInt ksubstrPS z2substrPS) (T.toInt ksubstrPS z3substrPS))

gtakePS ::
  T.RefSrcPos -> T.RefExp -> T.R (T.Fun Int (T.Fun PackedString PackedString))

gtakePS ptakePS p = T.ufun2 atakePS ptakePS p htakePS

htakePS z1takePS z2takePS ktakePS =
  fromPackedString ktakePS
    (Data.PackedString.takePS (T.toInt ktakePS z1takePS)
      (toPackedString ktakePS z2takePS))

gdropPS ::
  T.RefSrcPos -> T.RefExp -> T.R (T.Fun Int (T.Fun PackedString PackedString))

gdropPS pdropPS p = T.ufun2 adropPS pdropPS p hdropPS

hdropPS z1dropPS z2dropPS kdropPS =
  fromPackedString kdropPS
    (Data.PackedString.dropPS (T.toInt kdropPS z1dropPS)
      (toPackedString kdropPS z2dropPS))

gsplitAtPS ::
  T.RefSrcPos ->
    T.RefExp ->
      T.R (T.Fun Int (T.Fun PackedString (T.Tuple2 PackedString PackedString)))

gsplitAtPS psplitAtPS p = T.ufun2 asplitAtPS psplitAtPS p hsplitAtPS

hsplitAtPS z1splitAtPS z2splitAtPS ksplitAtPS =
  (T.fromTuple2 fromPackedString fromPackedString) ksplitAtPS
    (Data.PackedString.splitAtPS (T.toInt ksplitAtPS z1splitAtPS)
      (toPackedString ksplitAtPS z2splitAtPS))

gfoldlPS ::
  T.RefSrcPos ->
    T.RefExp ->
      T.R (T.Fun (T.Fun a (T.Fun Char a)) (T.Fun a (T.Fun PackedString a)))

gfoldlPS pfoldlPS p = T.ufun3 afoldlPS pfoldlPS p hfoldlPS

hfoldlPS z1foldlPS z2foldlPS z3foldlPS kfoldlPS =
  T.fromId kfoldlPS
    (Data.PackedString.foldlPS
      ((toFun T.fromId (toFun T.fromChar T.toId)) kfoldlPS z1foldlPS)
      (T.toId kfoldlPS z2foldlPS) (toPackedString kfoldlPS z3foldlPS))

gfoldrPS ::
  T.RefSrcPos ->
    T.RefExp ->
      T.R (T.Fun (T.Fun Char (T.Fun a a)) (T.Fun a (T.Fun PackedString a)))

gfoldrPS pfoldrPS p = T.ufun3 afoldrPS pfoldrPS p hfoldrPS

hfoldrPS z1foldrPS z2foldrPS z3foldrPS kfoldrPS =
  T.fromId kfoldrPS
    (Data.PackedString.foldrPS
      ((toFun T.fromChar (toFun T.fromId T.toId)) kfoldrPS z1foldrPS)
      (T.toId kfoldrPS z2foldrPS) (toPackedString kfoldrPS z3foldrPS))

gtakeWhilePS ::
  T.RefSrcPos ->
    T.RefExp -> T.R (T.Fun (T.Fun Char Bool) (T.Fun PackedString PackedString))

gtakeWhilePS ptakeWhilePS p = T.ufun2 atakeWhilePS ptakeWhilePS p htakeWhilePS

htakeWhilePS z1takeWhilePS z2takeWhilePS ktakeWhilePS =
  fromPackedString ktakeWhilePS
    (Data.PackedString.takeWhilePS
      ((toFun T.fromChar toBool) ktakeWhilePS z1takeWhilePS)
      (toPackedString ktakeWhilePS z2takeWhilePS))

gdropWhilePS ::
  T.RefSrcPos ->
    T.RefExp -> T.R (T.Fun (T.Fun Char Bool) (T.Fun PackedString PackedString))

gdropWhilePS pdropWhilePS p = T.ufun2 adropWhilePS pdropWhilePS p hdropWhilePS

hdropWhilePS z1dropWhilePS z2dropWhilePS kdropWhilePS =
  fromPackedString kdropWhilePS
    (Data.PackedString.dropWhilePS
      ((toFun T.fromChar toBool) kdropWhilePS z1dropWhilePS)
      (toPackedString kdropWhilePS z2dropWhilePS))

gspanPS ::
  T.RefSrcPos ->
    T.RefExp ->
      T.R
        (T.Fun (T.Fun Char Bool)
          (T.Fun PackedString (T.Tuple2 PackedString PackedString)))

gspanPS pspanPS p = T.ufun2 aspanPS pspanPS p hspanPS

hspanPS z1spanPS z2spanPS kspanPS =
  (T.fromTuple2 fromPackedString fromPackedString) kspanPS
    (Data.PackedString.spanPS ((toFun T.fromChar toBool) kspanPS z1spanPS)
      (toPackedString kspanPS z2spanPS))

gbreakPS ::
  T.RefSrcPos ->
    T.RefExp ->
      T.R
        (T.Fun (T.Fun Char Bool)
          (T.Fun PackedString (T.Tuple2 PackedString PackedString)))

gbreakPS pbreakPS p = T.ufun2 abreakPS pbreakPS p hbreakPS

hbreakPS z1breakPS z2breakPS kbreakPS =
  (T.fromTuple2 fromPackedString fromPackedString) kbreakPS
    (Data.PackedString.breakPS ((toFun T.fromChar toBool) kbreakPS z1breakPS)
      (toPackedString kbreakPS z2breakPS))

glinesPS ::
  T.RefSrcPos -> T.RefExp -> T.R (T.Fun PackedString (T.List PackedString))

glinesPS plinesPS p = T.ufun1 alinesPS plinesPS p hlinesPS

hlinesPS z1linesPS klinesPS =
  (fromList fromPackedString) klinesPS
    (Data.PackedString.linesPS (toPackedString klinesPS z1linesPS))

gwordsPS ::
  T.RefSrcPos -> T.RefExp -> T.R (T.Fun PackedString (T.List PackedString))

gwordsPS pwordsPS p = T.ufun1 awordsPS pwordsPS p hwordsPS

hwordsPS z1wordsPS kwordsPS =
  (fromList fromPackedString) kwordsPS
    (Data.PackedString.wordsPS (toPackedString kwordsPS z1wordsPS))

gsplitPS ::
  T.RefSrcPos ->
    T.RefExp -> T.R (T.Fun Char (T.Fun PackedString (T.List PackedString)))

gsplitPS psplitPS p = T.ufun2 asplitPS psplitPS p hsplitPS

hsplitPS z1splitPS z2splitPS ksplitPS =
  (fromList fromPackedString) ksplitPS
    (Data.PackedString.splitPS (T.toChar ksplitPS z1splitPS)
      (toPackedString ksplitPS z2splitPS))

gsplitWithPS ::
  T.RefSrcPos ->
    T.RefExp ->
      T.R (T.Fun (T.Fun Char Bool) (T.Fun PackedString (T.List PackedString)))

gsplitWithPS psplitWithPS p = T.ufun2 asplitWithPS psplitWithPS p hsplitWithPS

hsplitWithPS z1splitWithPS z2splitWithPS ksplitWithPS =
  (fromList fromPackedString) ksplitWithPS
    (Data.PackedString.splitWithPS
      ((toFun T.fromChar toBool) ksplitWithPS z1splitWithPS)
      (toPackedString ksplitWithPS z2splitWithPS))

tData_PackedString =
  T.mkModule "Data.PackedString" "Data/PackedString.hs" Prelude.False

apackString =
  T.mkVariable tData_PackedString 530001 540049 3 1 "packString" Prelude.False

aunpackPS =
  T.mkVariable tData_PackedString 550001 560049 3 1 "unpackPS" Prelude.False

aprimEqPackedString =
  T.mkVariable tData_PackedString 580001 590063 3 2 "primEqPackedString"
    Prelude.False

aprimLePackedString =
  T.mkVariable tData_PackedString 600001 610063 3 2 "primLePackedString"
    Prelude.False

aprimShowsPrecPackedString =
  T.mkVariable tData_PackedString 620001 630070 3 3 "primShowsPrecPackedString"
    Prelude.False

(+++=&=++=%$==) =
  T.mkVariable tData_PackedString 660004 660032 16 0 "==" Prelude.False

(++@=&=+@=%$<=) =
  T.mkVariable tData_PackedString 680004 680032 16 0 "<=" Prelude.False

a70v3v70v39showsPrec =
  T.mkVariable tData_PackedString 700003 700039 3 0 "showsPrec" Prelude.False

anilPS = T.mkVariable tData_PackedString 720001 730032 3 0 "nilPS" Prelude.False

aconsPS =
  T.mkVariable tData_PackedString 740001 750056 3 2 "consPS" Prelude.False

aheadPS =
  T.mkVariable tData_PackedString 760001 770040 3 1 "headPS" Prelude.False

atailPS =
  T.mkVariable tData_PackedString 780001 790048 3 1 "tailPS" Prelude.False

anullPS =
  T.mkVariable tData_PackedString 800001 810040 3 1 "nullPS" Prelude.False

aappendPS =
  T.mkVariable tData_PackedString 820001 830064 3 2 "appendPS" Prelude.False

alengthPS =
  T.mkVariable tData_PackedString 840001 850039 3 1 "lengthPS" Prelude.False

aindexPS =
  T.mkVariable tData_PackedString 860001 870047 3 2 "indexPS" Prelude.False

amapPS = T.mkVariable tData_PackedString 880001 890064 3 2 "mapPS" Prelude.False

afilterPS =
  T.mkVariable tData_PackedString 900001 910064 3 2 "filterPS" Prelude.False

areversePS =
  T.mkVariable tData_PackedString 920001 930048 3 1 "reversePS" Prelude.False

aconcatPS =
  T.mkVariable tData_PackedString 940001 950050 3 1 "concatPS" Prelude.False

aelemPS =
  T.mkVariable tData_PackedString 960001 970048 3 2 "elemPS" Prelude.False

asubstrPS =
  T.mkVariable tData_PackedString 980001 990062 3 3 "substrPS" Prelude.False

atakePS =
  T.mkVariable tData_PackedString 1000001 1010055 3 2 "takePS" Prelude.False

adropPS =
  T.mkVariable tData_PackedString 1020001 1030055 3 2 "dropPS" Prelude.False

asplitAtPS =
  T.mkVariable tData_PackedString 1040001 1050069 3 2 "splitAtPS" Prelude.False

afoldlPS =
  T.mkVariable tData_PackedString 1070001 1080058 3 3 "foldlPS" Prelude.False

afoldrPS =
  T.mkVariable tData_PackedString 1090001 1100058 3 3 "foldrPS" Prelude.False

atakeWhilePS =
  T.mkVariable tData_PackedString 1110001 1120064 3 2 "takeWhilePS"
    Prelude.False

adropWhilePS =
  T.mkVariable tData_PackedString 1130001 1140064 3 2 "dropWhilePS"
    Prelude.False

aspanPS =
  T.mkVariable tData_PackedString 1150001 1160078 3 2 "spanPS" Prelude.False

abreakPS =
  T.mkVariable tData_PackedString 1170001 1180078 3 2 "breakPS" Prelude.False

alinesPS =
  T.mkVariable tData_PackedString 1200001 1210037 3 1 "linesPS" Prelude.False

awordsPS =
  T.mkVariable tData_PackedString 1220001 1230037 3 1 "wordsPS" Prelude.False

asplitPS =
  T.mkVariable tData_PackedString 1240001 1250045 3 2 "splitPS" Prelude.False

asplitWithPS =
  T.mkVariable tData_PackedString 1260001 1270053 3 2 "splitWithPS"
    Prelude.False
