#include "memalloc.h"
#include <stdlib.h>
#include <stdio.h>

#undef DEBUG
#ifdef DEBUG
#define HIDE(x)	x
#else
#define HIDE(x)
#endif

/*
  A custom memory allocator, intended for rapid allocation of large
  quantities of a small amount of memory each, where no individual
  deallocation is required.  (Deallocation can only be invoked for
  all memory objects simultaneously.)

  We try to allocate small objects contiguously in a largish
  heap slot.  Ideally, the test for slot exhaustion is cheap, and
  allocation is a simple increment.  When the slot is exhausted,
  we just start a new slot which does not need to be contiguous with
  the previous one.

  The address of each slot is stored in the "bucket".  If the bucket
  overflows, we resize it.  Allocation for slots and bucket uses the
  standard C malloc() library, whereas all allocation interior to a
  slot is the (we hope) faster custom allocator.

 */

#define BUCKET_SIZE	(10)
static void** bucket;		/* an array holding memory slots */
static void** bucket_next;	/* pointer to next available slot */
static int    bucket_size=0;	/* total number of used+empty slots */
static int    bucket_slots=0;	/* number of slots remaining to be filled */

#define SLOT_SIZE	(10*1024)
static void* slot;		/* current allocation arena */
static int   slot_remaining=0;	/* number of remaining words in current slot */

void*
memalloc (int request)
{
  void* response;
  int   words_req = (request +(sizeof(void*)/2)) / sizeof(void*);
			/* ^ convert byte request to whole words */

    HIDE(fprintf(stderr,"\nmemalloc(%d) ",words_req);)
  if (!bucket_slots) {
      HIDE(fprintf(stderr,"\n\tresizing bucket");)
    bucket_slots = BUCKET_SIZE;
    bucket_size += BUCKET_SIZE;
    bucket       = (void**)realloc(bucket, bucket_size*sizeof(void*));
    bucket_next  = &bucket[bucket_size-bucket_slots];
      HIDE(fprintf(stderr,"\n\tbucket allocated ");)
  }
  slot_remaining -= words_req;
    HIDE(fprintf(stderr,"\n\tslot_remaining = %d",slot_remaining);)
  if (slot_remaining<0) {
      HIDE(fprintf(stderr,"\n\tallocating new slot");)
    slot           = (void*)malloc(SLOT_SIZE*sizeof(void*));
    slot_remaining = SLOT_SIZE - words_req;
    *bucket_next   = slot;
    bucket_next++;
    bucket_slots--;
      HIDE(fprintf(stderr,"\n\tslot allocated ");)
  }
  response = slot;
  slot    += words_req * sizeof(void*);
  HIDE(fprintf(stderr,"\n\treturning 0x%x, moving slot to 0x%x",response,slot);)
  return response;
}

int
memfree (void* ptr)
{
  return 0;	/* i.e. null implementation */
}
