/*
  Hatari - dlgRom.c

  This file is distributed under the GNU Public License, version 2 or at
  your option any later version. Read the file gpl.txt for details.
*/
const char DlgRom_rcsid[] = "Hatari $Id: dlgRom.c,v 1.6 2006/03/02 09:06:08 thothy Exp $";

#include "main.h"
#include "configuration.h"
#include "dialog.h"
#include "sdlgui.h"
#include "file.h"


#define DLGROM_TOSBROWSE  4
#define DLGROM_TOSNAME    5
#define DLGROM_CARTEJECT  9
#define DLGROM_CARTBROWSE 10
#define DLGROM_CARTNAME   11
#define DLGROM_EXIT       13


/* The ROM dialog: */
static SGOBJ romdlg[] =
{
	{ SGBOX, 0, 0, 0,0, 52,23, NULL },
	{ SGBOX, 0, 0, 1,1, 50,8, NULL },
	{ SGTEXT, 0, 0, 22,2, 9,1, "TOS setup" },
	{ SGTEXT, 0, 0, 2,5, 25,1, "TOS image:" },
	{ SGBUTTON, 0, 0, 42,5, 8,1, "Browse" },
	{ SGTEXT, 0, 0, 2,7, 46,1, NULL },
	{ SGBOX, 0, 0, 1,10, 50,8, NULL },
	{ SGTEXT, 0, 0, 18,11, 15,1, "Cartridge setup" },
	{ SGTEXT, 0, 0, 2,14, 25,1, "Cartridge image:" },
	{ SGBUTTON, 0, 0, 32,14, 8,1, "Eject" },
	{ SGBUTTON, 0, 0, 42,14, 8,1, "Browse" },
	{ SGTEXT, 0, 0, 2,16, 46,1, NULL },
	{ SGTEXT, 0, 0, 2,19, 25,1, "A reset is needed after changing these options." },
	{ SGBUTTON, 0, 0, 16,21, 20,1, "Back to main menu" },
	{ -1, 0, 0, 0,0, 0,0, NULL }
};


/*-----------------------------------------------------------------------*/
/*
  Show and process the ROM dialog.
*/
void DlgRom_Main(void)
{
	char *tmpname;
	char szDlgTosName[47];
	char szDlgCartName[47];
	int but;

	tmpname = malloc(FILENAME_MAX);
	if (tmpname == NULL)
		return;

	SDLGui_CenterDlg(romdlg);

	File_ShrinkName(szDlgTosName, DialogParams.Rom.szTosImageFileName, sizeof(szDlgTosName)-1);
	romdlg[DLGROM_TOSNAME].txt = szDlgTosName;

	File_ShrinkName(szDlgCartName, DialogParams.Rom.szCartridgeImageFileName, sizeof(szDlgCartName)-1);
	romdlg[DLGROM_CARTNAME].txt = szDlgCartName;

	do
	{
		but = SDLGui_DoDialog(romdlg, NULL);
		switch (but)
		{
		 case DLGROM_TOSBROWSE:
			strcpy(tmpname, DialogParams.Rom.szTosImageFileName);
			if (SDLGui_FileSelect(tmpname, NULL, FALSE))   /* Show and process the file selection dlg */
			{
				if (!File_DoesFileNameEndWithSlash(tmpname) && File_Exists(tmpname))
				{
					strcpy(DialogParams.Rom.szTosImageFileName, tmpname);
					File_ShrinkName(szDlgTosName, DialogParams.Rom.szTosImageFileName, sizeof(szDlgTosName)-1);
				}
			}
			break;

		 case DLGROM_CARTEJECT:
			szDlgCartName[0] = 0;
			DialogParams.Rom.szCartridgeImageFileName[0] = 0;
			break;

		 case DLGROM_CARTBROWSE:
			strcpy(tmpname, DialogParams.Rom.szCartridgeImageFileName);
			File_MakeAbsoluteName(tmpname);
			if (SDLGui_FileSelect(tmpname, NULL, FALSE))   /* Show and process the file selection dlg */
			{
				if (!File_DoesFileNameEndWithSlash(tmpname) && File_Exists(tmpname))
				{
					strcpy(DialogParams.Rom.szCartridgeImageFileName, tmpname);
					File_ShrinkName(szDlgCartName, DialogParams.Rom.szCartridgeImageFileName, sizeof(szDlgCartName)-1);
				}
				else
				{
					szDlgCartName[0] = 0;
					DialogParams.Rom.szCartridgeImageFileName[0] = 0;
				}
			}
			break;
		}
	}
	while (but != DLGROM_EXIT && but != SDLGUI_QUIT && !bQuitProgram);

	free(tmpname);
}
