/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits.compression.algorithm.rice;

import nom.tam.fits.compression.algorithm.api.ICompressOption;
import nom.tam.fits.compression.provider.param.api.ICompressParameters;
import nom.tam.util.type.PrimitiveTypes;

public class RiceCompressOption
implements ICompressOption {
    public static final int DEFAULT_RICE_BLOCKSIZE = 32;
    public static final int DEFAULT_RICE_BYTEPIX = PrimitiveTypes.INT.size();
    private ICompressParameters parameters;
    private int blockSize = 32;
    private Integer bytePix = null;
    private RiceCompressOption original;

    @Override
    public RiceCompressOption copy() {
        try {
            return ((RiceCompressOption)this.clone()).setOriginal(this);
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("option could not be cloned", e);
        }
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public int getBytePix() {
        return this.bytePix;
    }

    @Override
    public ICompressParameters getCompressionParameters() {
        return this.parameters;
    }

    @Override
    public boolean isLossyCompression() {
        return false;
    }

    public RiceCompressOption setBlockSize(int value) {
        this.blockSize = value;
        return this;
    }

    public RiceCompressOption setBytePix(int value) {
        this.bytePix = value;
        return this;
    }

    @Override
    public void setParameters(ICompressParameters parameters) {
        this.parameters = parameters;
    }

    @Override
    public RiceCompressOption setTileHeight(int value) {
        return this;
    }

    @Override
    public RiceCompressOption setTileWidth(int value) {
        return this;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) {
        if (clazz.isAssignableFrom(this.getClass())) {
            return clazz.cast(this);
        }
        return null;
    }

    private RiceCompressOption setOriginal(RiceCompressOption riceCompressOption) {
        this.original = riceCompressOption;
        this.parameters = this.parameters.copy(this);
        return this;
    }

    protected RiceCompressOption setDefaultBytePix(int defaultBytePix) {
        if (this.original != null) {
            this.original.setDefaultBytePix(defaultBytePix);
            this.bytePix = this.original.getBytePix();
        } else if (this.bytePix == null) {
            this.bytePix = defaultBytePix;
        }
        return this;
    }
}

