/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.image.compression.hdu;

import java.nio.Buffer;
import nom.tam.fits.BinaryTable;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.fits.HeaderCard;
import nom.tam.fits.compression.algorithm.api.ICompressOption;
import nom.tam.fits.header.Compression;
import nom.tam.fits.header.IFitsHeader;
import nom.tam.image.compression.hdu.CompressedImageHDU;
import nom.tam.image.compression.tile.TiledImageCompressionOperation;
import nom.tam.util.ArrayFuncs;

public class CompressedImageData
extends BinaryTable {
    private TiledImageCompressionOperation tiledImageOperation;

    protected CompressedImageData() {
    }

    protected CompressedImageData(Header hdr) throws FitsException {
        super(hdr);
    }

    @Override
    public void fillHeader(Header h) throws FitsException {
        super.fillHeader(h);
        h.addValue((IFitsHeader)Compression.ZIMAGE, true);
    }

    private TiledImageCompressionOperation tiledImageOperation() {
        if (this.tiledImageOperation == null) {
            this.tiledImageOperation = new TiledImageCompressionOperation(this);
        }
        return this.tiledImageOperation;
    }

    protected void compress(CompressedImageHDU hdu) throws FitsException {
        this.tiledImageOperation().compress(hdu);
    }

    protected void forceNoLoss(int x, int y, int width, int heigth) {
        this.tiledImageOperation.forceNoLoss(x, y, width, heigth);
    }

    protected <T extends ICompressOption> T getCompressOption(Class<T> clazz) {
        return (T)((ICompressOption)this.tiledImageOperation().compressOptions().unwrap(clazz));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Buffer getUncompressedData(Header hdr) throws FitsException {
        try {
            this.tiledImageOperation = new TiledImageCompressionOperation(this).read(hdr);
            Buffer buffer = this.tiledImageOperation.decompress();
            return buffer;
        }
        finally {
            this.tiledImageOperation = null;
        }
    }

    protected void prepareUncompressedData(Object data, Header header) throws FitsException {
        this.tiledImageOperation().readPrimaryHeaders(header);
        Buffer source = this.tiledImageOperation().getBaseType().newBuffer(this.tiledImageOperation.getBufferSize());
        ArrayFuncs.copyInto(data, source.array());
        this.tiledImageOperation().prepareUncompressedData(source);
    }

    protected void preserveNulls(long nullValue, String compressionAlgorithm) {
        this.tiledImageOperation().preserveNulls(nullValue, compressionAlgorithm);
    }

    protected CompressedImageData setAxis(int[] axes) {
        this.tiledImageOperation().setAxes(axes);
        return this;
    }

    protected void setCompressAlgorithm(HeaderCard compressAlgorithmCard) {
        this.tiledImageOperation().setCompressAlgorithm(compressAlgorithmCard);
    }

    protected void setQuantAlgorithm(HeaderCard quantAlgorithmCard) throws FitsException {
        this.tiledImageOperation().setQuantAlgorithm(quantAlgorithmCard);
    }

    protected CompressedImageData setTileSize(int ... axes) throws FitsException {
        this.tiledImageOperation().setTileAxes(axes);
        return this;
    }
}

