/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.util;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import nom.tam.util.ArrayDataInput;
import nom.tam.util.BufferDecoder;
import nom.tam.util.BufferPointer;
import nom.tam.util.LoggerHelper;

public class BufferedDataInputStream
extends BufferedInputStream
implements ArrayDataInput {
    private static final Logger LOG = LoggerHelper.getLogger(BufferedDataInputStream.class);
    private static final int SKIP_BUFFER_SIZE = 8192;
    private final BufferPointer sharedBuffer = new BufferPointer().init(8);
    private final BufferDecoder bufferDecoder = new BufferDecoder(this.sharedBuffer){

        @Override
        protected void checkBuffer(int needBytes) throws IOException {
            if (needBytes > 0) {
                BufferedDataInputStream.this.readBytesIntoSharedBuffer(needBytes);
            }
        }

        @Override
        protected int eofCheck(EOFException e, int start, int index, int length) throws EOFException {
            return BufferedDataInputStream.this.eofCheck(e, index, start, length);
        }

        @Override
        protected int read(byte[] buf, int offset, int length) throws IOException {
            return BufferedDataInputStream.this.read(buf, offset, length);
        }
    };
    private byte[] skipBuf = null;

    public BufferedDataInputStream(InputStream o) {
        this(o, 32768);
    }

    public BufferedDataInputStream(InputStream o, int bufLength) {
        super(o, bufLength);
    }

    private int eofCheck(EOFException e, int i, int start, int length) throws EOFException {
        if (i == start) {
            throw e;
        }
        return (i - start) * length;
    }

    @Override
    public int read(boolean[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(boolean[] b, int start, int length) throws IOException {
        return this.bufferDecoder.read(b, start, length);
    }

    @Override
    public int read(byte[] obuf, int offset, int length) throws IOException {
        int total = 0;
        int remainingToRead = length;
        int currentOffset = offset;
        while (remainingToRead > 0) {
            int xlen = super.read(obuf, currentOffset, remainingToRead);
            if (xlen <= 0) {
                if (total == 0) {
                    throw new EOFException();
                }
                return total;
            }
            remainingToRead -= xlen;
            total += xlen;
            currentOffset += xlen;
        }
        return total;
    }

    @Override
    public int read(char[] c) throws IOException {
        return this.read(c, 0, c.length);
    }

    @Override
    public int read(char[] c, int start, int length) throws IOException {
        return this.bufferDecoder.read(c, start, length);
    }

    @Override
    public int read(double[] d) throws IOException {
        return this.read(d, 0, d.length);
    }

    @Override
    public int read(double[] d, int start, int length) throws IOException {
        return this.bufferDecoder.read(d, start, length);
    }

    @Override
    public int read(float[] f) throws IOException {
        return this.read(f, 0, f.length);
    }

    @Override
    public int read(float[] f, int start, int length) throws IOException {
        return this.bufferDecoder.read(f, start, length);
    }

    @Override
    public int read(int[] i) throws IOException {
        return this.read(i, 0, i.length);
    }

    @Override
    public int read(int[] i, int start, int length) throws IOException {
        return this.bufferDecoder.read(i, start, length);
    }

    @Override
    public int read(long[] l) throws IOException {
        return this.read(l, 0, l.length);
    }

    @Override
    public int read(long[] l, int start, int length) throws IOException {
        return this.bufferDecoder.read(l, start, length);
    }

    @Override
    public int read(short[] s) throws IOException {
        return this.read(s, 0, s.length);
    }

    @Override
    public int read(short[] s, int start, int length) throws IOException {
        return this.bufferDecoder.read(s, start, length);
    }

    @Override
    @Deprecated
    public int readArray(Object o) throws IOException {
        return (int)this.readLArray(o);
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.read() == 1;
    }

    @Override
    public byte readByte() throws IOException {
        return (byte)this.read();
    }

    private void readBytesIntoSharedBuffer(int bytes) throws IOException, EOFException {
        this.sharedBuffer.invalidate();
        if (this.read(this.sharedBuffer.buffer, 0, bytes) < bytes) {
            throw new EOFException();
        }
    }

    @Override
    public char readChar() throws IOException {
        return this.bufferDecoder.readChar();
    }

    @Override
    public double readDouble() throws IOException {
        return this.bufferDecoder.readDouble();
    }

    @Override
    public float readFloat() throws IOException {
        return this.bufferDecoder.readFloat();
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.bufferDecoder.readFully(b, 0, b.length);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        this.bufferDecoder.readFully(b, off, len);
    }

    @Override
    public int readInt() throws IOException {
        return this.bufferDecoder.readInt();
    }

    @Override
    public long readLArray(Object o) throws IOException {
        return this.bufferDecoder.readLArray(o);
    }

    @Override
    @Deprecated
    public String readLine() throws IOException {
        int chr;
        StringBuilder b = new StringBuilder(0);
        while ((chr = this.read()) >= 0) {
            if (chr != 10) {
                b.append((char)chr);
                continue;
            }
            return b.toString();
        }
        return b.toString();
    }

    @Override
    public long readLong() throws IOException {
        return this.bufferDecoder.readLong();
    }

    @Deprecated
    public int readPrimitiveArray(Object o) throws IOException {
        return (int)this.readLArray(o);
    }

    @Override
    public short readShort() throws IOException {
        return this.bufferDecoder.readShort();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.read() & 0xFF;
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.bufferDecoder.readShort() & 0xFFFF;
    }

    @Override
    public String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    @Override
    public void skipAllBytes(int toSkip) throws IOException {
        this.skipAllBytes((long)toSkip);
    }

    @Override
    public void skipAllBytes(long toSkip) throws IOException {
        long need = toSkip;
        while (need > 0L) {
            try {
                long got = this.skip(need);
                if (got <= 0L) break;
                need -= got;
            }
            catch (IOException e) {
                need = this.handleExceptionInSkip(need, e);
            }
        }
        if (need > 0L) {
            throw new EOFException();
        }
    }

    private long handleExceptionInSkip(long skip, IOException e) throws IOException {
        long remainingToSkip;
        int got;
        LOG.log(Level.WARNING, "Error while skipping bytes", e);
        if (this.skipBuf == null) {
            this.skipBuf = new byte[8192];
        }
        for (remainingToSkip = skip; remainingToSkip > 8192L && (got = this.read(this.skipBuf, 0, 8192)) > 0; remainingToSkip -= (long)got) {
        }
        while (remainingToSkip > 0L && (got = this.read(this.skipBuf, 0, (int)remainingToSkip)) > 0) {
            remainingToSkip -= (long)got;
        }
        return remainingToSkip;
    }

    @Override
    public int skipBytes(int toSkip) throws IOException {
        this.skipAllBytes(toSkip);
        return toSkip;
    }

    public String toString() {
        return super.toString() + "[count=" + this.count + ",pos=" + this.pos + "]";
    }
}

