/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.util.type;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import nom.tam.util.type.PrimitiveTypeBase;

class IntType
extends PrimitiveTypeBase<IntBuffer> {
    private static final int BIT_PIX = 32;
    private static final int SIZE = 4;

    protected IntType() {
        super(4, false, Integer.TYPE, Integer.class, IntBuffer.class, 'I', 32);
    }

    @Override
    public void appendBuffer(IntBuffer buffer, IntBuffer dataToAppend) {
        int[] temp = new int[Math.min(1024, dataToAppend.remaining())];
        while (dataToAppend.hasRemaining()) {
            int nrObBytes = Math.min(temp.length, dataToAppend.remaining());
            dataToAppend.get(temp, 0, nrObBytes);
            buffer.put(temp, 0, nrObBytes);
        }
    }

    @Override
    public IntBuffer asTypedBuffer(ByteBuffer buffer) {
        return buffer.asIntBuffer();
    }

    @Override
    public void getArray(IntBuffer buffer, Object array, int length) {
        buffer.get((int[])array, 0, length);
    }

    @Override
    public Object newArray(int length) {
        return new int[length];
    }

    @Override
    public void putArray(IntBuffer buffer, Object array, int length) {
        buffer.put((int[])array, 0, length);
    }

    @Override
    public IntBuffer sliceBuffer(IntBuffer buffer) {
        return buffer.slice();
    }

    @Override
    public IntBuffer wrap(Object array) {
        return IntBuffer.wrap((int[])array);
    }
}

