#ifndef ADDREAPLETHEADER_H_
#define ADDREAPLETHEADER_H_

/*

  Heap Layers: An Extensible Memory Allocation Infrastructure
  
  Copyright (C) 2000-2003 by Emery Berger
  http://www.cs.umass.edu/~emery
  emery@cs.umass.edu
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

/**
 * @class AddReapletHeader
 * @brief Add a Reaplet header to every allocated object.
 */

namespace HL {

template <int ReapletSize,
	  class TopHeap>
class AddReapletHeader : public TopHeap {
public:
#if 1
public:

  AddReapletHeader (void)
  {
    sassert <(TopAlignment % ReapletSize) == 0> verifyAlignment;
  }

  enum { TopAlignment = TopHeap::Alignment };

  enum { Alignment = sizeof(double) };

  __forceinline void * malloc (size_t sz) {
    ReapletBase * m
      = (ReapletBase *) TopHeap::malloc (sz + sizeof(ReapletBase));
    // printf ("m = %x, size = %d\n", m, ReapletSize);
    // Verify alignment.
    assert (((size_t) m & (ReapletSize - 1)) == 0);
    // Put a reaplet base object as a header in the beginning. We
    // need this for size information.
    new (m) ReapletBase (sz, (char *) (m + 1)); 
    return (void *) (m + 1);
  }
  __forceinline void free (void * ptr) {
    TopHeap::free ((ReapletBase *) ptr - 1);
  }
  inline void clear (void) {}

#endif
  inline size_t getSize (void * ptr) {
    return (enclosingReaplet (ptr))->getSize();
  }
private:
  __forceinline static ReapletBase * enclosingReaplet (void * ptr) {
    // Find the enclosing reaplet for this pointer.
    ReapletBase * r
      = (ReapletBase *) (((size_t) ptr) & ~(ReapletSize - 1));
    return r;
  }
};

};

#endif
