#!/bin/bash
#
# Copyright (C) 2004 Andrew Beekhof <andrew@beekhof.net>
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#

required_nodes=2
testdir=/usr/lib/heartbeat/crmtest
. ${testdir}/helper.sh || exit 1

CRM_ERR_SHUTDOWN=0
test_nodes=2

while [ $iteration -lt $repeats ]; do
    iteration=`expr $iteration + 1`
    echo -ne "\033]0;$test_type : Iteration $iteration of $repeats\007"
    echo "########### Begining iteration $iteration of $repeats ###########"
(
# make *sure* theres nothing left over from last time
crm-cleanup

#----

start_node $test_node_1

#----

do_cmd echo "Analyse CRMd startup"
do_cmd ${testdir}/testutils.pl -p $crm_log_pos -l ${logfile} --search  -a -m 90 \
    -s "crmd(.*) State transition (.*) \-> S_ELECTION" \
    -s "crmd(.*) State transition (.*) \-> S_INTEGRATION" 
cts_assert "DC election on ${test_node_1} failed."

do_cmd ${testdir}/testutils.pl -p $crm_log_pos -l ${logfile} --search  -a -m 500 \
    -s "Updating node state to member for ${test_node_1}" \
    -s "crmd(.*) State transition (.*) \-> S_IDLE" 
cts_assert "IDLE and CRMd join on ${test_node_1} failed."

do_cmd wait_for_state S_IDLE 30 $test_node_1 
cts_assert "S_IDLE not reached on $test_node_1 (startup)!"

#----

do_cmd echo Create the first constraint and wait for S_IDLE
rsc=rsc1
uuid1=`uuidgen`
uuid2=`uuidgen`
uuid3=`uuidgen`
node_xml="<rsc_location id=\\\"${uuid1}\\\" rsc=\\\"${rsc}\\\">
        <rule id=\\\"${uuid2}\\\" result=\\\"can\\\"/>
	<rule id=\\\"${uuid3}\\\" score=\\\"1000\\\" boolean_op=\\\"or\\\">
	  <expression attribute=\\\"uname\\\" operation=\\\"eq\\\" value=\\\"${test_node_1}\\\"/>
	</rule>
      </rsc_location>"
crm_log_pos=$(stat -L -c %s $logfile)
do_cmd make_constraint_adv $test_node_1 $node_xml
do_cmd ${testdir}/testutils.pl -p $crm_log_pos -l ${logfile} --search -a -m 100 \
    -s "crmd(.*) State transition (.*) \-> S_IDLE"
#cts_assert Adding constraint1 did not pass

#----

do_cmd echo Create the second constraint and wait for S_IDLE
rsc=rsc2
uuid1=`uuidgen`
uuid2=`uuidgen`
uuid3=`uuidgen`
node_xml="<rsc_location id=\\\"${uuid1}\\\" rsc=\\\"${rsc}\\\">
	        <rule id=\\\"${uuid2}\\\" result=\\\"can\\\"/>
		<rule id=\\\"${uuid3}\\\" score=\\\"1000\\\" boolean_op=\\\"or\\\">
		   <expression attribute=\\\"uname\\\" operation=\\\"eq\\\" value=\\\"${test_node_2}\\\"/>
		</rule>
	   </rsc_location>"
crm_log_pos=$(stat -L -c %s $logfile)
do_cmd make_constraint_adv $test_node_1 $node_xml
do_cmd ${testdir}/testutils.pl -p $crm_log_pos -l ${logfile} --search -a -m 100 \
    -s "crmd(.*) State transition (.*) \-> S_IDLE"
#cts_assert Adding constraint2 did not pass

#----

do_cmd echo Create the first resource and wait for S_IDLE after start
args="<nvpair name=\\\"1\\\" value=\\\"${ip_rsc_1}\\\"/>"
crm_log_pos=$(stat -L -c %s $logfile)
do_cmd make_resource $test_node_1 rsc1 heartbeat IPaddr - - - $args
do_cmd ${testdir}/testutils.pl -p $crm_log_pos -l ${logfile} --search -a -m 200 \
    -s "crmd(.*) State transition (.*) \-> S_IDLE" \
    -s "crmd(.*) Performing op start(.*) on rsc1"
cts_assert Adding rsc1 did not pass

#----

do_cmd echo Create the second resource and wait for S_IDLE after start
args="<nvpair name=\\\"1\\\" value=\\\"${ip_rsc_2}\\\"/>"
crm_log_pos=$(stat -L -c %s $logfile)
do_cmd make_resource $test_node_1 rsc2 heartbeat IPaddr - - - $args
do_cmd ${testdir}/testutils.pl -p $crm_log_pos -l ${logfile} --search -a -m 200 \
    -s "crmd(.*) State transition (.*) \-> S_IDLE" \
    -s "crmd(.*) Performing op start(.*) on rsc2"
cts_assert Adding rsc2 did not pass

#----

do_cmd echo Various sanity checks - stage 1
do_cmd wait_for_state S_IDLE 3 $test_node_1 
cts_assert "S_IDLE not reached on $test_node_1 (CIB create)!"

do_cmd is_running rsc1 $test_node_1
cts_assert "rsc1 NOT running"

do_cmd is_running rsc2 $test_node_1
cts_assert "rsc2 NOT running"

do_cmd is_dc $test_node_1
cts_assert "$test_node_1 is supposed to be the DC"

do_cmd is_running rsc1 $test_node_1 x$test_node_1
cts_assert_false "rsc1 IS running on x$test_node_1"

do_cmd is_running rsc1 $test_node_1 $test_node_1
cts_assert "rsc1 NOT running on $test_node_1"

do_cmd is_running rsc2 $test_node_1 $test_node_1
cts_assert "rsc2 NOT running on $test_node_1"

#----

start_node $test_node_2

#----

do_cmd echo "Analyse CRMd startup"
do_cmd ${testdir}/testutils.pl -p $crm_log_pos -l ${logfile} --search -a -m 400 \
    -s "${test_node_2} crmd(.*) State transition S_PENDING \-> S_NOT_DC" 
cts_assert "CRMd startup on ${test_node_2} failed."

do_cmd ${testdir}/testutils.pl -p $crm_log_pos -l ${logfile} --search -a -m 2000 \
    -s "${test_node_1} crmd(.*) State transition(.*) \-> S_IDLE" \
    -s "${test_node_2} crmd(.*) Performing op start(.*) on rsc2"
cts_assert "rsc2 was not transferred to ${test_node_2} on startup."

#----

do_cmd echo Various sanity checks - stage 2
do_cmd wait_for_state S_NOT_DC 30 $test_node_2 
cts_assert "S_NOT_DC not reached on $test_node_2 (startup - 2)!"

do_cmd wait_for_state S_IDLE 30 $test_node_1 
cts_assert "S_IDLE not reached on $test_node_1 (startup - 2)!"

do_cmd is_running rsc1 $test_node_1
cts_assert "rsc1 NOT running"

do_cmd is_running rsc2 $test_node_1
cts_assert "rsc2 NOT running"

do_cmd is_running rsc1 $test_node_1 $test_node_1
cts_assert "rsc1 NOT running on $test_node_1"

do_cmd is_running rsc2 $test_node_1 $test_node_2
cts_assert "rsc2 NOT running on $test_node_2"

#----

stop_node $test_node_1 crmd

do_cmd ${testdir}/testutils.pl -p $crm_log_pos -l ${logfile} --search -a -m 2000 \
    -s "${test_node_2} crmd(.*) State transition (.*) \-> S_ELECTION" \
    -s "${test_node_1} crmd(.*) State transition (.*) \-> S_NOT_DC"
cts_assert "Transition of the DC from ${test_node_1} to ${test_node_2} failed."

do_cmd ${testdir}/testutils.pl -p $crm_log_pos -l ${logfile} --search -a -m 4000 \
    -s "crmd(.*) Performing op start(.*) on rsc1"
cts_assert "rsc1 was not transferred to ${test_node_2} on shutdown."

#----

do_cmd echo Various sanity checks - stage 3
do_cmd wait_for_state S_IDLE 60 $test_node_2
cts_assert "S_IDLE not reached on $test_node_2 after shutdown!"

do_cmd is_running rsc1 $test_node_2
cts_assert "rsc1 NOT running"

do_cmd is_running rsc2 $test_node_2
cts_assert "rsc2 NOT running"

do_cmd is_running rsc1 $test_node_2 $test_node_1
cts_assert_false "rsc1 IS running on $test_node_1"

do_cmd is_running rsc2 $test_node_2 $test_node_2
cts_assert "rsc2 NOT running on $test_node_2"

#----

stop_node $test_node_2 crmd

#----

do_cmd remote_cmd $CRMD_USER $test_node_2 killall -9 crmd

echo "test: PASSED"
)
done
