#!/bin/bash
#
# Copyright (C) 2004 Andrew Beekhof  <andrew@beekhof.net>
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#

testdir=/usr/lib/heartbeat/crmtest
. ${testdir}/helper.sh || exit 1

erase_sync_1="<?xml version=\"1.0\"?>
<cib_fragment section=\"all\" generated_on=\"$test_node_1\">
  <cib generated=\"true\">
    <configuration>
      <crm_config/>
      <nodes/>
      <resources/>
      <constraints/>
    </configuration>
    <status/>
  </cib>
</cib_fragment>
"

erase_sync_2="<?xml version=\"1.0\"?>
<cib_fragment section=\"all\" generated_on=\"$test_node_2\">
  <cib generated=\"true\">
    <configuration>
      <crm_config/>
      <nodes/>
      <resources/>
      <constraints/>
    </configuration>
    <status/>
  </cib>
</cib_fragment>
"

erase_sync_3="<?xml version=\"1.0\"?>
<cib_fragment section=\"all\" generated_on=\"$test_node_3\">
  <cib generated=\"true\">
    <configuration>
      <crm_config/>
      <nodes/>
      <resources/>
      <constraints/>
    </configuration>
    <status/>
  </cib>
</cib_fragment>
"

create_1="<?xml version=\"1.0\"?>
<cib_fragment section=\"all\" generated_on=\"$test_node_1\">
  <cib generated=\"true\" cib_feature_revision=\"1\" debug_source=\"handleCibMod\">
    <configuration>
      <crm_config/>
      <nodes>
        <node uname=\"$test_node_1\" description=\"test node: $test_node_1\" type=\"member\"/>
        <node uname=\"$test_node_2\" description=\"test node: $test_node_2\" type=\"member\"/>
      </nodes>
      <resources/>
      <constraints/>
    </configuration>
    <status/>
  </cib>
</cib_fragment>
"

create_2="<?xml version=\"1.0\"?>
<cib_fragment section=\"all\" generated_on=\"$test_node_2\">
  <cib generated=\"true\" cib_feature_revision=\"1\" debug_source=\"handleCibMod\">
    <configuration>
      <crm_config/>
      <nodes>
        <node uname=\"$test_node_1\" description=\"test node: $test_node_1\" type=\"member\"/>
        <node uname=\"$test_node_2\" description=\"test node: $test_node_2\" type=\"member\"/>
      </nodes>
      <resources/>
      <constraints/>
    </configuration>
    <status/>
  </cib>
</cib_fragment>
"

create_3="<?xml version=\"1.0\"?>
<cib_fragment section=\"all\" generated_on=\"$test_node_3\">
  <cib generated=\"true\" cib_feature_revision=\"1\" debug_source=\"handleCibMod\">
    <configuration>
      <crm_config/>
      <nodes>
        <node uname=\"$test_node_1\" description=\"test node: $test_node_1\" type=\"member\"/>
        <node uname=\"$test_node_2\" description=\"test node: $test_node_2\" type=\"member\"/>
      </nodes>
      <resources/>
      <constraints/>
    </configuration>
    <status/>
  </cib>
</cib_fragment>
"

create_local_1="<?xml version=\"1.0\"?>
<cib_fragment section=\"all\" generated_on=\"$test_node_1\">
  <cib generated=\"true\" cib_feature_revision=\"1\" debug_source=\"handleCibMod\">
    <configuration>
      <crm_config/>
      <nodes>
        <node uname=\"$test_node_1\" description=\"test node: $test_node_1\" type=\"member\"/>
        <node uname=\"$test_node_2\" description=\"test node: $test_node_2\" type=\"member\"/>
        <node uname=\"$test_node_3\" description=\"test node: $test_node_3\" type=\"member\"/>
      </nodes>
      <resources/>
      <constraints/>
    </configuration>
    <status/>
  </cib>
</cib_fragment>
"

create_local_2="<?xml version=\"1.0\"?>
<cib_fragment section=\"all\" generated_on=\"$test_node_2\">
  <cib generated=\"true\" cib_feature_revision=\"1\" debug_source=\"handleCibMod\">
    <configuration>
      <crm_config/>
      <nodes>
        <node uname=\"$test_node_1\" description=\"test node: $test_node_1\" type=\"member\"/>
        <node uname=\"$test_node_2\" description=\"test node: $test_node_2\" type=\"member\"/>
      </nodes>
      <resources/>
      <constraints/>
    </configuration>
    <status/>
  </cib>
</cib_fragment>
"

create_local_3="<?xml version=\"1.0\"?>
<cib_fragment section=\"all\" generated_on=\"$test_node_3\">
  <cib generated=\"true\" cib_feature_revision=\"1\" debug_source=\"handleCibMod\">
    <configuration>
      <crm_config/>
      <nodes>
        <node uname=\"$test_node_1\" description=\"test node: $test_node_1\" type=\"member\"/>
        <node uname=\"$test_node_2\" description=\"test node: $test_node_2\" type=\"member\"/>
      </nodes>
      <resources/>
      <constraints/>
    </configuration>
    <status/>
  </cib>
</cib_fragment>
"

bump_local_1="<?xml version=\"1.0\"?>
<cib_fragment section=\"all\" generated_on=\"$test_node_1\">
  <cib generated=\"true\" cib_feature_revision=\"1\" debug_source=\"handleCibMod\">
    <configuration>
      <crm_config/>
      <nodes>
        <node uname=\"$test_node_1\" description=\"test node: $test_node_1\" type=\"member\"/>
        <node uname=\"$test_node_2\" description=\"test node: $test_node_2\" type=\"member\"/>
        <node uname=\"$test_node_3\" description=\"test node: $test_node_3\" type=\"member\"/>
      </nodes>
      <resources/>
      <constraints/>
    </configuration>
    <status/>
  </cib>
</cib_fragment>
"

bump_local_2="<?xml version=\"1.0\"?>
<cib_fragment section=\"all\" generated_on=\"$test_node_2\">
  <cib generated=\"true\" cib_feature_revision=\"1\" debug_source=\"handleCibMod\" epoche=\"1\">
    <configuration>
      <crm_config/>
      <nodes>
        <node uname=\"$test_node_1\" description=\"test node: $test_node_1\" type=\"member\"/>
        <node uname=\"$test_node_2\" description=\"test node: $test_node_2\" type=\"member\"/>
      </nodes>
      <resources/>
      <constraints/>
    </configuration>
    <status/>
  </cib>
</cib_fragment>
"

bump_local_3="<?xml version=\"1.0\"?>
<cib_fragment section=\"all\" generated_on=\"$test_node_3\">
  <cib generated=\"true\" cib_feature_revision=\"1\" debug_source=\"handleCibMod\">
    <configuration>
      <crm_config/>
      <nodes>
        <node uname=\"$test_node_1\" description=\"test node: $test_node_1\" type=\"member\"/>
        <node uname=\"$test_node_2\" description=\"test node: $test_node_2\" type=\"member\"/>
      </nodes>
      <resources/>
      <constraints/>
    </configuration>
    <status/>
  </cib>
</cib_fragment>
"

bump_remote_1="<?xml version=\"1.0\"?>
<cib_fragment section=\"all\" generated_on=\"$test_node_1\">
  <cib generated=\"true\" cib_feature_revision=\"1\" debug_source=\"handleCibMod\">
    <configuration>
      <crm_config/>
      <nodes>
        <node uname=\"$test_node_1\" description=\"test node: $test_node_1\" type=\"member\"/>
        <node uname=\"$test_node_2\" description=\"test node: $test_node_2\" type=\"member\"/>
        <node uname=\"$test_node_3\" description=\"test node: $test_node_3\" type=\"member\"/>
      </nodes>
      <resources/>
      <constraints/>
    </configuration>
    <status/>
  </cib>
</cib_fragment>
"

bump_remote_2="<?xml version=\"1.0\"?>
<cib_fragment section=\"all\" generated_on=\"$test_node_2\">
  <cib generated=\"true\" cib_feature_revision=\"1\" debug_source=\"handleCibMod\" epoche=\"2\">
    <configuration>
      <crm_config/>
      <nodes>
        <node uname=\"$test_node_1\" description=\"test node: $test_node_1\" type=\"member\"/>
        <node uname=\"$test_node_2\" description=\"test node: $test_node_2\" type=\"member\"/>
      </nodes>
      <resources/>
      <constraints/>
    </configuration>
    <status/>
  </cib>
</cib_fragment>
"

bump_remote_3="<?xml version=\"1.0\"?>
<cib_fragment section=\"all\" generated_on=\"$test_node_3\">
  <cib generated=\"true\" cib_feature_revision=\"1\" debug_source=\"handleCibMod\">
    <configuration>
      <crm_config/>
      <nodes>
        <node uname=\"$test_node_1\" description=\"test node: $test_node_1\" type=\"member\"/>
        <node uname=\"$test_node_2\" description=\"test node: $test_node_2\" type=\"member\"/>
      </nodes>
      <resources/>
      <constraints/>
    </configuration>
    <status/>
  </cib>
</cib_fragment>
"

bump_1="<?xml version=\"1.0\"?>
<cib_fragment section=\"all\" generated_on=\"$test_node_1\">
  <cib generated=\"true\" cib_feature_revision=\"1\" debug_source=\"handleCibMod\">
    <configuration>
      <crm_config/>
      <nodes>
        <node uname=\"$test_node_1\" description=\"test node: $test_node_1\" type=\"member\"/>
        <node uname=\"$test_node_2\" description=\"test node: $test_node_2\" type=\"member\"/>
        <node uname=\"$test_node_3\" description=\"test node: $test_node_3\" type=\"member\"/>
      </nodes>
      <resources/>
      <constraints/>
    </configuration>
    <status/>
  </cib>
</cib_fragment>
"

bump_2="<?xml version=\"1.0\"?>
<cib_fragment section=\"all\" generated_on=\"$test_node_2\">
  <cib generated=\"true\" cib_feature_revision=\"1\" debug_source=\"handleCibMod\" epoche=\"1\">
    <configuration>
      <crm_config/>
      <nodes>
        <node uname=\"$test_node_1\" description=\"test node: $test_node_1\" type=\"member\"/>
        <node uname=\"$test_node_2\" description=\"test node: $test_node_2\" type=\"member\"/>
      </nodes>
      <resources/>
      <constraints/>
    </configuration>
    <status/>
  </cib>
</cib_fragment>
"

bump_3="<?xml version=\"1.0\"?>
<cib_fragment section=\"all\" generated_on=\"$test_node_3\">
  <cib generated=\"true\" cib_feature_revision=\"1\" debug_source=\"handleCibMod\">
    <configuration>
      <crm_config/>
      <nodes>
        <node uname=\"$test_node_1\" description=\"test node: $test_node_1\" type=\"member\"/>
        <node uname=\"$test_node_2\" description=\"test node: $test_node_2\" type=\"member\"/>
      </nodes>
      <resources/>
      <constraints/>
    </configuration>
    <status/>
  </cib>
</cib_fragment>
"


sync_from_1="<?xml version=\"1.0\"?>
<cib_fragment section=\"all\" generated_on=\"$test_node_1\">
  <cib generated=\"true\" cib_feature_revision=\"1\" debug_source=\"handleCibMod\" epoche=\"2\">
    <configuration>
      <crm_config/>
      <nodes>
        <node uname=\"$test_node_1\" description=\"test node: $test_node_1\" type=\"member\"/>
        <node uname=\"$test_node_2\" description=\"test node: $test_node_2\" type=\"member\"/>
      </nodes>
      <resources/>
      <constraints/>
    </configuration>
    <status/>
  </cib>
</cib_fragment>
"

sync_from_2="<?xml version=\"1.0\"?>
<cib_fragment section=\"all\" generated_on=\"$test_node_2\">
  <cib generated=\"true\" cib_feature_revision=\"1\" debug_source=\"handleCibMod\" epoche=\"2\">
    <configuration>
      <crm_config/>
      <nodes>
        <node uname=\"$test_node_1\" description=\"test node: $test_node_1\" type=\"member\"/>
        <node uname=\"$test_node_2\" description=\"test node: $test_node_2\" type=\"member\"/>
      </nodes>
      <resources/>
      <constraints/>
    </configuration>
    <status/>
  </cib>
</cib_fragment>
"

sync_from_3="<?xml version=\"1.0\"?>
<cib_fragment section=\"all\" generated_on=\"$test_node_3\">
  <cib generated=\"true\" cib_feature_revision=\"1\" debug_source=\"handleCibMod\" epoche=\"2\">
    <configuration>
      <crm_config/>
      <nodes>
        <node uname=\"$test_node_1\" description=\"test node: $test_node_1\" type=\"member\"/>
        <node uname=\"$test_node_2\" description=\"test node: $test_node_2\" type=\"member\"/>
      </nodes>
      <resources/>
      <constraints/>
    </configuration>
    <status/>
  </cib>
</cib_fragment>
"

# make *sure* theres nothing left over from last time
crm-cleanup

function compare_cibs()
{
    cib_cmp_base=$1; shift
    cib_cmp_host=$1; shift
    cib_cmp_opts=$*
    cib_cmp_output=${cib_cmp_base}.out
    cib_cmp_expected=${cib_cmp_base}.exp
    cib_cmp_failed=$test_dump_dir/test.txt
    cib_cmp_diff_opts="--ignore-all-space -U 1 -u"
    
    remote_cmd $CRMD_USER $cib_cmp_host "$HALIB_DIR/cibadmin -Q ${cib_cmp_opts}" > $cib_cmp_output
    cts_assert "compare_cibs(): Could not perform query: opts=$cib_cmp_opts"
    
    gres ' timestamp=\"[0123456789]*\"' "" ${cib_cmp_output}
    gres ' id=\"[0123456789abcdef-]*\"' "" ${cib_cmp_output}

    # this is the value stored in a variable named $cib_cmp_base
    echo -e "${!cib_cmp_base}" > $cib_cmp_expected

#    if [ "$create_mode" = "true" -a ! -f $cib_cmp_expected ]; then
#	cp "$cib_cmp_output" "$cib_cmp_expected"
#    fi
    
    if [ -f $cib_cmp_expected ]; then
	diff $cib_cmp_diff_opts -q $cib_cmp_expected $cib_cmp_output >/dev/null
	rc=$?
    fi
    
#    if [ "$create_mode" = "true" ]; then
#	echo "Test $cib_cmp_base...	Created expected output" 
#    el
    if [ ! -f $cib_cmp_expected ]; then
	echo "==== Raw results for CIB test ($cib_cmp_base) ====" >> $cib_cmp_failed
	cat $cib_cmp_output 2>/dev/null >> $cib_cmp_failed
	cat $cib_cmp_output
	
    elif [ "$rc" = 0 ]; then
	do_cmd echo "Test $cib_cmp_base...	Passed";
    elif [ "$rc" = 1 ]; then
	do_cmd echo "Test $cib_cmp_base...	* Failed";
	diff $cib_cmp_diff_opts $cib_cmp_expected $cib_cmp_output 2>/dev/null >> $cib_cmp_failed
	diff $cib_cmp_diff_opts $cib_cmp_expected $cib_cmp_output
    else 
	do_cmd echo "Test $cib_cmp_base...	Error (diff: $rc)";
	do_cmd echo "==== Raw results for test ($cib_cmp_base) ====" >> $cib_cmp_failed
	cat $cib_cmp_output 2>/dev/null >> $cib_cmp_failed
	cat $cib_cmp_output
    fi
    
    rm $cib_cmp_output .gres.$cib_cmp_output $cib_cmp_expected

    do_cts_assert $rc 0 "diff for $cib_cmp_base found differences"
}


#----

do_cmd echo "wait for HA to start"
crm_log_pos=$(stat -L -c %s $logfile)
do_cmd remote_cmd $INIT_USER $test_node_1 $HALIB_DIR/heartbeat -M "2>&1 >/dev/null" &
do_cmd remote_cmd $INIT_USER $test_node_2 $HALIB_DIR/heartbeat -M "2>&1 >/dev/null" &
do_cmd remote_cmd $INIT_USER $test_node_3 $HALIB_DIR/heartbeat -M "2>&1 >/dev/null" &
do_cmd ${testdir}/testutils.pl -l ${logfile} -p $crm_log_pos --search -a -m 3500 \
    -s "${test_node_1} heartbeat(.*) info: Starting child client(.*)cib" \
    -e "${test_node_1} heartbeat(.*)Client(.*)/cib \"respawning too fast" \
    -s "${test_node_2} heartbeat(.*) info: Starting child client(.*)cib" \
    -e "${test_node_2} heartbeat(.*)Client(.*)/cib \"respawning too fast" \
    -s "${test_node_3} heartbeat(.*) info: Starting child client(.*)cib" \
    -e "${test_node_3} heartbeat(.*)Client(.*)/cib \"respawning too fast"
cts_assert "Startup of Heartbeat on ${test_node_1}, ${test_node_2} and ${test_node_3} failed."

#----

do_cmd echo "is master instance?"
do_cmd remote_cmd $CRMD_USER $test_node_1 "$HALIB_DIR/cibadmin -M"
do_cts_assert $? 35 "CIB service on $test_node_1 should not be in master mode by default"

#----

do_cmd echo "local query"
do_cmd remote_cmd $CRMD_USER $test_node_1 "$HALIB_DIR/cibadmin -Q -l"
cts_assert "Could not query local CIB service on $test_node_1"

#----

do_cmd echo "queries with hostname"
do_cmd remote_cmd $CRMD_USER $test_node_1 "$HALIB_DIR/cibadmin -Q -h $test_node_2"
cts_assert "Could not query CIB service on $test_node_2 from $test_node_1"

do_cmd remote_cmd $CRMD_USER $test_node_1 "$HALIB_DIR/cibadmin -Q -l -h $test_node_1"
cts_assert "Could not query CIB service on $test_node_1 from $test_node_1"

do_cmd remote_cmd $CRMD_USER $test_node_1 "$HALIB_DIR/cibadmin -Q -h $test_node_1"
cts_assert "Could not query CIB service on $test_node_1 from $test_node_1 without -l flag"

#----

do_cmd echo "make sure all instances are slaves"
do_cmd remote_cmd $CRMD_USER $test_node_1 "$HALIB_DIR/cibadmin -r"
cts_assert "Could not set CIB services to slaves"

#----

do_cmd echo "make local the master instance"
do_cmd remote_cmd $CRMD_USER $test_node_1 "$HALIB_DIR/cibadmin -w"
cts_assert "Could not set CIB service on $test_node_1 to master"
do_cmd remote_cmd $CRMD_USER $test_node_1 "$HALIB_DIR/cibadmin -M"
cts_assert "Could not set CIB service on $test_node_1 to master"

#----

do_cmd echo "erase CIB contents and sync"
do_cmd remote_cmd $CRMD_USER $test_node_1 "$HALIB_DIR/cibadmin -E"
cts_assert "Could not erase CIB contents"
do_cmd remote_cmd $CRMD_USER $test_node_1 "$HALIB_DIR/cibadmin -S"
cts_assert "Could not sync CIB to all nodes"

#----

do_cmd echo "verify the CIB contents"
compare_cibs erase_sync_1 $test_node_1 -l
compare_cibs erase_sync_2 $test_node_1 -h $test_node_2
compare_cibs erase_sync_3 $test_node_1 -l -h $test_node_3

#----

do_cmd echo "make some nodes in the CIB"
do_cmd make_node $test_node_1 $test_node_1 "member"
cts_assert "Could not create $test_node_1"
do_cmd make_node $test_node_1 $test_node_2 "member"
cts_assert "Could not create $test_node_2"

#----

do_cmd echo "verify the CIB contents"
compare_cibs create_1 $test_node_1 -l
compare_cibs create_2 $test_node_2 -l
compare_cibs create_3 $test_node_3 -l

#----

do_cmd make_node_local $test_node_1 $test_node_3 "member"
cts_assert "Could not create $test_node_3 locally"

#----

do_cmd echo "verify the CIB contents on all nodes"
compare_cibs create_local_1 $test_node_1 -l
compare_cibs create_local_2 $test_node_2 -l
compare_cibs create_local_3 $test_node_3 -l

#----

do_cmd echo "make all slaves"
do_cmd remote_cmd $CRMD_USER $test_node_1 "$HALIB_DIR/cibadmin -r"
cts_assert "Could not set CIB services to slaves"

do_cmd echo "make node2 master"
do_cmd remote_cmd $CRMD_USER $test_node_2 "$HALIB_DIR/cibadmin -w"
cts_assert "Could not set CIB service on $test_node_1 to master"

#----

do_cmd echo "bump master twice (so we can use it in a sync later)"

#----

do_cmd remote_cmd $CRMD_USER $test_node_2 "$HALIB_DIR/cibadmin -B"
cts_assert "Could not perform bump on $test_node_2"

do_cmd echo "verify the CIB contents on all nodes"
compare_cibs bump_1 $test_node_1 -l
compare_cibs bump_2 $test_node_2 -l
compare_cibs bump_3 $test_node_3 -l

#----

do_cmd remote_cmd $CRMD_USER $test_node_1 "$HALIB_DIR/cibadmin -B"
cts_assert "Could not perform bump on $test_node_2 via $test_node_1"

do_cmd echo "verify the CIB contents on all nodes"
compare_cibs bump_remote_1 $test_node_1 -l
compare_cibs bump_remote_2 $test_node_2 -l
compare_cibs bump_remote_3 $test_node_3 -l

#----

do_cmd echo "make all slaves"
do_cmd remote_cmd $CRMD_USER $test_node_1 "$HALIB_DIR/cibadmin -r"
cts_assert "Could not set CIB services to slaves"

do_cmd echo "make node1 master"
do_cmd remote_cmd $CRMD_USER $test_node_1 "$HALIB_DIR/cibadmin -w"
cts_assert "Could not set CIB service on $test_node_1 to master"

#----

do_cmd echo "sync from node2"
do_cmd remote_cmd $CRMD_USER $test_node_1 "$HALIB_DIR/cibadmin -S -h $test_node_2"
cts_assert "Could not sync from $test_node_2"

#----

do_cmd echo "verify the CIB contents on all nodes"
compare_cibs sync_from_1 $test_node_1 -l
compare_cibs sync_from_2 $test_node_2 -l
compare_cibs sync_from_3 $test_node_3 -l

#----

do_cmd remote_cmd $CRMD_USER $test_node_2 "$HALIB_DIR/cibadmin -B -l"
cts_assert "Could not perform local bump on $test_node_2"

do_cmd echo "verify the CIB contents on all nodes"
compare_cibs bump_local_1 $test_node_1 -l
compare_cibs bump_local_2 $test_node_2 -l
compare_cibs bump_local_3 $test_node_3 -l


echo "test: PASSED"

