/*
 * Copyright (c) 1997, 1998 Kungliga Tekniska Hgskolan
 * (Royal Institute of Technology, Stockholm, Sweden). 
 * All rights reserved. 
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions 
 * are met: 
 *
 * 1. Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright 
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the distribution. 
 *
 * 3. Neither the name of the Institute nor the names of its contributors 
 *    may be used to endorse or promote products derived from this software 
 *    without specific prior written permission. 
 *
 * THIS SOFTWARE IS PROVIDED BY THE INSTITUTE AND CONTRIBUTORS ``AS IS'' AND 
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE INSTITUTE OR CONTRIBUTORS BE LIABLE 
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS 
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT 
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY 
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF 
 * SUCH DAMAGE. 
 */

#include "krb5_locl.h"

RCSID("$Id: net_write.c,v 1.9 2004/05/25 21:36:09 lha Exp $");

krb5_ssize_t KRB5_LIB_FUNCTION
krb5_net_write (krb5_context context,
		void *p_fd,
		const void *buf,
		size_t len)
{
  int fd = *((int *)p_fd);

  return net_write (fd, buf, len);
}

krb5_ssize_t KRB5_LIB_FUNCTION
krb5_net_write_block(krb5_context context,
		     void *p_fd,
		     const void *buf,
		     size_t len,
		     time_t timeout)
{
  int fd = *((int *)p_fd);
  int ret;
  struct timeval tv, *tvp;
  const char *cbuf = (const char *)buf;
  size_t rem = len;
  ssize_t count;
  fd_set wfds;

  do {
      FD_ZERO(&wfds);
      FD_SET(fd, &wfds);
      
      if (timeout != 0) {
	  tv.tv_sec = timeout;
	  tv.tv_usec = 0;
	  tvp = &tv;
      } else
	  tvp = NULL;

      ret = select(fd + 1, NULL, &wfds, NULL, tvp);
      if (ret < 0) {
	  if (errno == EINTR)
	      continue;
	  return -1;
      } else if (ret == 0)
	  return 0;
      
      if (!FD_ISSET(fd, &wfds)) {
	  errno = ETIMEDOUT;
	  return -1;
      }

#ifdef WIN32
      count = send (fd, cbuf, rem, 0);
#else
      count = write (fd, cbuf, rem);
#endif
      if (count < 0) {
	  if (errno == EINTR)
	      continue;
	  else
	      return count;
      }
      cbuf += count;
      rem -= count;

  } while (rem > 0);

  return len;
}
