/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: pxgifff.h,v 1.2.24.1 2004/07/09 01:54:17 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef PXGIFFF_H
#define PXGIFFF_H

// Forward declarations
typedef _INTERFACE IHXRequest            IHXRequest;
typedef _INTERFACE IHXFormatResponse     IHXFormatResponse;
typedef _INTERFACE IHXFileObject         IHXFileObject;
typedef _INTERFACE IHXBuffer             IHXBuffer;
typedef _INTERFACE IHXFragmentedBuffer   IHXFragmentedBuffer;
typedef _INTERFACE IHXPacket             IHXPacket;
typedef _INTERFACE IHXCommonClassFactory IHXCommonClassFactory;
typedef _INTERFACE IHXErrorMessages      IHXErrorMessages;
typedef _INTERFACE IHXFileStat           IHXFileStat;
class CHXSimpleList;
class CHXString;
class CGIFCodec;

class CGIFFileFormat : public CHXBaseCountingObject,
                       public IHXPlugin,
                       public IHXFileFormatObject,
                       public IHXFileResponse,
                       public IHXFileStatResponse,
		       public IHXThreadSafeMethods
{
public:
    CGIFFileFormat();
    virtual ~CGIFFileFormat();

    // IUnknown Methods
    STDMETHOD (QueryInterface)  (THIS_ REFIID ID, void** ppObj);
    STDMETHOD_(UINT32, AddRef)  (THIS);
    STDMETHOD_(UINT32, Release) (THIS);

    // IHXPlugin Methods
    STDMETHOD(GetPluginInfo) (THIS_ REF(BOOL)        bMultipleLoad,
                                    REF(const char*) pDescription,
                                    REF(const char*) pCopyright,
                                    REF(const char*) pMoreInfoURL,
                                    REF(ULONG32)     ulVersionNumber);
    STDMETHOD(InitPlugin)    (THIS_ IUnknown *pContext);

    // IHXFileFormatObject methods
    STDMETHOD(GetFileFormatInfo) (THIS_ REF(const char**) pFileMimeTypes,
                                        REF(const char**) pFileExtensions,
                                        REF(const char**) pFileOpenNames);
    STDMETHOD(InitFileFormat)    (THIS_ IHXRequest*        pRequest,
                                        IHXFormatResponse* pFormatResponse,
                                        IHXFileObject*     pFileObject);
    STDMETHOD(GetFileHeader)     (THIS);
    STDMETHOD(GetStreamHeader)   (THIS_ UINT16 usStreamNum);
    STDMETHOD(GetPacket)         (THIS_ UINT16 usStreamNum);
    STDMETHOD(Seek)              (THIS_ UINT32 ulRequestedTime);
    STDMETHOD(Close)             (THIS);

    // IHXFileResponse Methods
    STDMETHOD(InitDone)  (THIS_ HX_RESULT status);
    STDMETHOD(SeekDone)  (THIS_ HX_RESULT status);
    STDMETHOD(ReadDone)  (THIS_ HX_RESULT status, IHXBuffer* pBuffer);
    STDMETHOD(WriteDone) (THIS_ HX_RESULT status);
    STDMETHOD(CloseDone) (THIS_ HX_RESULT status);

    // IHXFileStatResponse methods
    STDMETHOD(StatDone) (THIS_ HX_RESULT status, UINT32 ulSize, UINT32 ulCreationTime,
                               UINT32 ulAccessTime, UINT32 ulModificationTime, UINT32 ulMode);

    // IHXThreadSafeMethods methods
    STDMETHOD_(UINT32,IsThreadSafe)(THIS);

    // CGIFFileFormat methods
    static HX_RESULT STDAPICALLTYPE HXCreateInstance(IUnknown** ppIUnknown);
protected:
    enum
    {
        kDefaultBitRate        = 12000,
        kDefaultDuration       = 5000,
        kStateConstructed      = 0,
        kStateFileInit         = 1,
        kStateFileStat         = 2,
        kStateFileRead         = 3,
        kStateInitialized      = 4,
        kStateFileHeaderSent   = 5,
        kStateStreamHeaderSent = 6,
        kStateFinished         = 7,
        kTargetBrowser         = 0,
        kTargetPlayer          = 1,
        kURLTypeNormal         = 0,
        kURLTypeCommandPause   = 1,
        kURLTypeCommandPlay    = 2,
        kURLTypeCommandSeek    = 3,
        kURLTypeCommandStop    = 4
    };

    INT32                   m_lRefCount;
    IUnknown*               m_pContext;
    IHXFileObject*         m_pFileObject;
    IHXFileStat*           m_pFileStat;
    IHXFormatResponse*     m_pFormatResponse;
    IHXCommonClassFactory* m_pCommonClassFactory;
    IHXErrorMessages*      m_pError;
    UINT32                  m_ulBitRate;
    UINT32                  m_ulPreroll;
    UINT32                  m_ulDuration;
    CHXString*              m_pURL;
    CHXString*              m_pRequestURL;
    BYTE                    m_ucTarget;
    BYTE                    m_ucURLType;
    UINT32                  m_ulSeekTime;
    UINT32                  m_ulBackgroundColor;
    INT32                   m_lCurrentTime;
    INT32*                  m_plImageStartTime;
    INT32                   m_lCurImgIndex;
    UINT32                  m_ulState;
    UINT32                  m_ulFileSize;
    IHXBuffer*             m_pFileBuffer;
    IHXFragmentedBuffer*   m_pFragFileBuffer;
    CGIFCodec*              m_pGIFCodec;
    BOOL                    m_bReliable;
    UINT32                  m_ulNumBytesRead;
    IHXPacket**            m_ppPacket;
    UINT32                  m_ulNumPackets;
    UINT32                  m_ulCurrentPacketIndex;
    BOOL                    m_bParseFailed;
    IHXBuffer*             m_pMediaRepeatStr;

    static const char* const     m_pszDescription;
    static const char* const     m_pszCopyright;
    static const char* const     m_pszMoreInfoURL;
    static const char* const     m_ppszFileMimeTypes[];
    static const char* const     m_ppszFileExtensions[];
    static const char* const     m_ppszFileOpenNames[];
    static const char* const     m_pszStreamMimeType;
    static const char* const     m_pszBadStreamMimeType;
    static const UINT32     m_ulContentVersion;
    static const UINT32     m_ulStreamVersion;

    void      ReportError(UINT32 ulErrorID, const char* pszArg = NULL);
    HX_RESULT GetResourceErrorString(UINT32 ulErrorID, CHXString& rErrorStr);
    HX_RESULT ParseFile();
    HX_RESULT MakeAllPackets();
};

#endif
