/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: sm1time.h,v 1.2.12.1 2004/07/09 01:57:34 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef _SM1TIME_H_
#define _SM1TIME_H_

class CSmil1TimelineElement;

class CSmil1TimelineElementManager
{
public:
    CSmil1TimelineElementManager		();
    ~CSmil1TimelineElementManager	();

    void addTimelineElement		(CSmil1TimelineElement* pElement);
    void addNotification		(const char* pID,
					CSmil1TimelineElement* pElement);
    void notify				(const char* pID);
    void resetTimeline			();

    CSmil1TimelineElement*
	getTimelineElement		(const char* pID);

private:
    CHXMapStringToOb*			m_pElementMap;
    CHXMapStringToOb*			m_pNotifierMap;
};

class CSmil1TimelineElement
{
public:
    CSmil1TimelineElement		(CSmil1Element *pSourceElement,
					CSmil1Parser* pParser);
    virtual ~CSmil1TimelineElement	();

    virtual void setDelay		(UINT32 ulDelay);
    virtual void setDuration		(UINT32 ulDuration,
					BOOL bSetFromParent = FALSE);
    virtual void setMaxDuration		(UINT32 ulMaxDuration);
    virtual void adjustDependentDuration(CSmil1TimelineElement* pDependent);
    virtual void addDuration		(UINT32 ulDuration, 
					UINT32 ulDelay,
					const char* pID)
					{
					}

    BOOL initialDelaySet		()
					{ return m_bDelaySet; }

    BOOL delayEvent			()		
					{ return m_bDelayEvent; }

    BOOL durationSet			()		
					{ return m_bDurationSet; }

    BOOL durationEvent			()		
					{ return m_bDurationEvent; }

    void reset				();

    virtual void elementResolved	(CSmil1TimelineElement* pElement);

    void setParent			(CSmil1TimelineElement* pParent)
    {
        m_pParent = pParent;
    }

    void setDependent			(CSmil1TimelineElement* pDependent)
    {
        m_pDependent = pDependent;
    }

    void addChild			(CSmil1TimelineElement* pChild);

    UINT32 getDuration			();
    UINT32 getDelay			();

    virtual void dump			();
    char*				m_pID;

protected:
    CSmil1Element*			m_pSourceElement;
    CSmil1Parser*			m_pParser;
    CHXSimpleList*			m_pChildren;
    CSmil1TimelineElement*		m_pParent;
    CSmil1TimelineElement*		m_pDependent;

    BOOL				m_bDelaySet;
    BOOL				m_bDelayEvent;
    BOOL				m_bDurationEvent;
    BOOL				m_bDurationSet;
    BOOL				m_bMaxDurationSet;
    BOOL				m_bDontResetDuration;
    //The following is for cases where a non-event delay and
    // an event delay exist and m_bDelaySet is not sufficient
    // to keep track of all 3 possible delaySet states.  The
    // non-event delay is always set before the event is resolved
    // so that's why there are 3 and not 4 states:
    BOOL				m_bNonEventDelaySet;

    friend class CSmil1TimelinePar;
    friend class CSmil1TimelineSeq;
    friend class CSmil1TimelineAnchor;
};

	
class CSmil1TimelinePar: public CSmil1TimelineElement
{
public:
    CSmil1TimelinePar			(CSmil1Element* pSourceElement, 
					CSmil1Parser* pRenderer);
    virtual ~CSmil1TimelinePar		();

    virtual void setDelay		(UINT32 ulDelay);
    virtual void setDuration		(UINT32 ulDuration,
					BOOL bSetFromParent = FALSE);
    virtual void setMaxDuration		(UINT32 ulMaxDuration);
    virtual void adjustDependentDuration(CSmil1TimelineElement* pDependent);
    virtual void addDuration		(UINT32 ulDuration, 
					UINT32 ulDelay,
					const char* pID);
    virtual void elementResolved	(CSmil1TimelineElement* pElement);
    void durationResolved		(UINT32 ulDuration,
					BOOL bUpdateChildren);

private:
    int					m_nDurationAdded;
    UINT32				m_ulFirstDuration;
    UINT32				m_ulLastDuration;
};

class CSmil1TimelineSeq: public CSmil1TimelineElement
{
public:
    CSmil1TimelineSeq			(CSmil1Element* pSourceElement, 
					CSmil1Parser* pRenderer);

    virtual void setDelay		(UINT32 ulDelay);
    virtual void setDuration		(UINT32 ulDuration,
					BOOL bSetFromParent = FALSE);
    virtual void setMaxDuration		(UINT32 ulMaxDuration);
    virtual void adjustDependentDuration(CSmil1TimelineElement* pDependent);
    BOOL	 setElementDuration	(UINT32& ulDurationLeft, CSmil1TimelineElement* pElement);
    virtual void addDuration		(UINT32 ulDuration, 
					UINT32 ulDelay,
					const char* pID);

private:
    int					m_nDurationAdded;
};

class CSmil1TimelineAnchor: public CSmil1TimelineElement
{
public:
    CSmil1TimelineAnchor			(CSmil1Element* pSourceElement, 
					CSmil1Parser* pRenderer);
    virtual ~CSmil1TimelineAnchor		();

    virtual void elementResolved	(CSmil1TimelineElement* pElement);
    void durationResolved		(UINT32 ulDuration);

private:
    int					m_nDurationAdded;
};

#endif	/* _SM1TIME_H_ */
