# ***** BEGIN LICENSE BLOCK *****
# Source last modified: $Id: wininstaller.py,v 1.1.2.2 2004/07/09 02:02:53 hubbe Exp $
# 
# Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
# 
# The contents of this file, and the files included with this file,
# are subject to the current version of the RealNetworks Public
# Source License (the "RPSL") available at
# http://www.helixcommunity.org/content/rpsl unless you have licensed
# the file under the current version of the RealNetworks Community
# Source License (the "RCSL") available at
# http://www.helixcommunity.org/content/rcsl, in which case the RCSL
# will apply. You may also obtain the license terms directly from
# RealNetworks.  You may not use this file except in compliance with
# the RPSL or, if you have a valid RCSL with RealNetworks applicable
# to this file, the RCSL.  Please see the applicable RPSL or RCSL for
# the rights, obligations and limitations governing use of the
# contents of the file.
# 
# Alternatively, the contents of this file may be used under the
# terms of the GNU General Public License Version 2 or later (the
# "GPL") in which case the provisions of the GPL are applicable
# instead of those above. If you wish to allow use of your version of
# this file only under the terms of the GPL, and not to allow others
# to use your version of this file under the terms of either the RPSL
# or RCSL, indicate your decision by deleting the provisions above
# and replace them with the notice and other provisions required by
# the GPL. If you do not delete the provisions above, a recipient may
# use your version of this file under the terms of any one of the
# RPSL, the RCSL or the GPL.
# 
# This file is part of the Helix DNA Technology. RealNetworks is the
# developer of the Original Code and owns the copyrights in the
# portions it created.
# 
# This file, and the files included with this file, is distributed
# and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
# KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
# ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
# OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
# ENJOYMENT OR NON-INFRINGEMENT.
# 
# Technology Compatibility Kit Test Suite(s) Location:
#    http://www.helixcommunity.org/content/tck
# 
# Contributor(s):
# 
# ***** END LICENSE BLOCK *****

#
# wininstaller.py - Windows installer class
#
#######################################################################

execfile(os.path.join(project.inst_script_dir, "installer.py"))

class WinInstaller(Installer):

    def __init__(self):
        Installer.__init__(self)

        self.zip_command = "zip"

        # Package dynamically linked (with the crt) modules with the statically 
        # linked installer        
        if(project.BuildOption("static") and \
            project.output_dir[len(project.output_dir)-1] == 's'):

            # Whack off the trailing 's' to get the dynamic link directory
            self.module_output_dir = \
            project.output_dir[0:len(project.output_dir)-1]
        self.tar_command = os.path.join(project.hxar_path, 
            self.inst_output_dir, "hxar")

    ############################################################
    # NativePath: converts a path to the native separator format
    def NativePath(self, path):
        return string.replace(path, '/', '\\')

    #######################################################################
    # SetArchiveType: sets the archive type
    def SetArchiveType(self, archive_type):
        Installer.SetArchiveType(self, archive_type)
        if (self.include_archive_prog):
            self.archive_prog = self.archive_prog + ".exe"

    ############################################################
    # MakeArchive: Writes the makefile to create the archive file.
    def MakeArchive(self):
        project.writeln("all:")

        #for bz2
        if (self.archive_type == "bz2"):
            project.writeln("\t%s -c -C %s . | %s -zvc > %s" % \
                (self.tar_command, self.tempdir, self.archive_prog, 
                self.archive_file))

        #for zip
        if (self.archive_type == "zip"):
            project.writeln("\tcd %s" % self.tempdir)
            project.writeln("\t%s -r %s ." % (self.zip_command, 
                    os.path.join("..", inst.archive_file)))

        self.CreateInfoHeader()

        project.writeln("depend:")
        project.writeln("\t" + platform.rm.cmd + " " + self.archive_file)
        project.writeln("")
        project.writeln("clean:")
        project.writeln("\t" + platform.rm.cmd + " " + self.archive_file)
        project.writeln("")

    #######################################################################
    # CreateInfoHeader: Writes the archive_info header
    def CreateInfoHeader(self):
        project.writeln("\techo /* auto-generated, do not edit*/ > " + \
            self.archive_info_header)

        project.writeln("\techo #define ARCHIVE_TYPE \"%s\" >> %s" % \
            (self.archive_type, self.archive_info_header))

        # ARCHIVE_FILE and ARCHIVE_PROG define the build machine's
        # paths, to be included from the rc file that adds them

        project.writeln("\techo #define ARCHIVE_FILE \"%s\" >> %s" % \
            (self.archive_file, self.archive_info_header))
        
        # Copy the archive prog to the working directory
        if (self.include_archive_prog):
            arch_prog_path = self.arch_prog_cp_path
            project.writeln("\t%s %s %s" % (platform.copy.cmd, 
            self.archive_prog, arch_prog_path))
        else:
            arch_prog_path = "NULL"

        project.writeln("\techo #define ARCHIVE_PROG \"%s\" >> %s" % \
            (arch_prog_path, self.archive_info_header))


    ############################################################
    # MakeSymbols: Writes the makefile to create symbol
    # files and strip binaries in Unix. Does nothing in Windows -
    # binaries do not include symbols. Use the "-t map" build 
    # options to generate map files.
    def MakeSymbols(self, *files):
        return

    #######################################################################
    # MakeArchive: Writes the makefile to create the final installer.
    # Does nothing in windows, since stage1 does everything.
    def MakeInstaller(self, stage1_path = None):
       return
