/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: about.cpp,v 1.1.2.8.2.3 2004/09/20 07:42:25 rggammon Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#include "about.h"
#include "commonapp.h"
#include "hxplayer-i18n.h"
#include "appver.h"

/* Helix headers */
#include "hxcom.h"
#include "hxwintyp.h"
#include "hxplugn.h"
#include "hxcore.h"
#include "ihxpckts.h"

#include "commonapp.h"


typedef struct
{
    GladeXML* xml;
    
} HXAboutDialog;

static void
hxplay_about_dialog_destroy (GtkWidget* /* widget */,
                             HXAboutDialog* about)
{
    if(about->xml)
    {
        glade_xml_destroy(about->xml);
    }

    g_free(about);
}

static void
populate_copyrights_text_view (GtkWidget* copyrights_text_view,
                               HXPlayer*  player)
{
    GString* str;

    str = g_string_new("");

    /* Get the plugin enumerator */
    IHXPlugin2Handler* pPlugin2Handler;
    UINT32 nNumPlugins;
    UINT32 nIndex;
    IHXValues* pPluginProps;
    IHXBuffer* pCopyright;
    IHXBuffer* pDescription;
    IUnknown* pUnk;
    HX_RESULT retVal;

    gboolean result;
    
    result = hx_player_get_unknown(player,
                                   (void**)&pUnk);
    g_return_if_fail(result != FALSE);

    retVal = pUnk->QueryInterface(IID_IHXPlugin2Handler,
                                  (void**)&pPlugin2Handler);
    g_return_if_fail(pPlugin2Handler && SUCCEEDED(retVal));
    
    nNumPlugins = pPlugin2Handler->GetNumOfPlugins2();
    
    for(nIndex = 0; nIndex < nNumPlugins; nIndex++)
    {
        pCopyright = NULL;
        pDescription = NULL;
        gchar* copyright = NULL;
        gchar* description = NULL;

        pPlugin2Handler->GetPluginInfo(nIndex, pPluginProps);

        retVal = pPluginProps->GetPropertyCString("Description", pDescription);
        if(SUCCEEDED(retVal))
        {
            description = (gchar*) pDescription->GetBuffer();
        }
        

        retVal = pPluginProps->GetPropertyCString("Copyright", pCopyright);
        if(SUCCEEDED(retVal))
        {
            copyright = (gchar*) pCopyright->GetBuffer();
        }

        if(copyright && description)
        {
            g_string_append_printf(str, "%s:\n", description);
            g_string_append_printf(str, "%s\n\n", copyright);
        }

        if(pCopyright)
        {
            HX_RELEASE(pCopyright);
        }

        if(pDescription)
        {
            HX_RELEASE(pDescription);
        }
    }
    
    HX_RELEASE(pPlugin2Handler);
    HX_RELEASE(pUnk);


    GtkTextBuffer* buffer;

    buffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(copyrights_text_view));

    gtk_text_buffer_set_text(buffer, str->str, str->len);
    
    g_string_free(str, TRUE);
}

GtkDialog*
hxplay_about_dialog_new (HXPlayer* player,
                         const gchar* distcode,
                         const gchar* origcode)
{
    GtkWidget* dialog;
    GtkWidget* version;
    GtkWidget* misc_build_info;
    GtkWidget* url_label;
    GtkWidget* copyrights_text_view;
    GtkWidget* distcode_origcode_label;
    gchar* filename;
    gchar* version_markup;
    gchar* misc_build_info_markup;
    gchar* dialog_title;
    gchar* origcode_distcode;
    HXAboutDialog* about;

    about = g_new0(HXAboutDialog, 1);
    
    filename = hxcommon_locate_file("about.glade");
    about->xml = glade_xml_new(filename, NULL, NULL);
    g_free(filename);
    g_return_val_if_fail(about->xml != NULL, NULL);
    
    dialog = glade_xml_get_widget(about->xml, "hxplayer_about_dialog");

    version = glade_xml_get_widget(about->xml, "had_version");
    misc_build_info = glade_xml_get_widget(about->xml, "had_misc_build_info");
    url_label = glade_xml_get_widget(about->xml, "had_url");

    distcode_origcode_label = glade_xml_get_widget(about->xml, "had_distcode_origcode");

    copyrights_text_view = glade_xml_get_widget (about->xml, "had_copyrights");

    g_return_val_if_fail(dialog && version && misc_build_info &&
                         url_label && copyrights_text_view &&
                         distcode_origcode_label, NULL);

    dialog_title = g_strdup_printf(_("About %s"), APP_NAME_LONG);
    gtk_window_set_title(GTK_WINDOW(dialog), dialog_title);
    g_free(dialog_title);

    if(origcode && distcode)
    {
        origcode_distcode = g_strdup_printf("%s (%s)",
                                            distcode, origcode);

        gtk_label_set_text(GTK_LABEL(distcode_origcode_label), origcode_distcode);
    }
    else
    {
        gtk_label_set_text(GTK_LABEL(distcode_origcode_label), "");
    }
    
    version_markup = g_strdup_printf(_("<span size=\"xx-large\" weight=\"bold\">"
				       APP_NAME_LONG " %s (%s)</span>"),
				       TARVER_STRING_VERSION, 
				       _(PLATFORM_BUILD_STATUS));
    gtk_label_set_markup(GTK_LABEL(version), version_markup);        
    g_free(version_markup);

    gtk_label_set_text(GTK_LABEL(url_label), APP_URL);
    
#if defined(__GNUC__) && defined(__GNUC_MINOR__) && defined(__GNUC_PATCHLEVEL__)
    misc_build_info_markup = g_strdup_printf(_("<span size=\"small\">Built with gcc %d.%d.%d on %s</span>"),
                                               __GNUC__,
                                               __GNUC_MINOR__,
                                               __GNUC_PATCHLEVEL__ ,
                                               __DATE__);
#else
    misc_build_info_markup = g_strdup_printf(_("<span size=\"small\">Built on %s</span>"),
                                               __DATE__);
#endif

    gtk_label_set_markup(GTK_LABEL(misc_build_info), misc_build_info_markup);        
    g_free(misc_build_info_markup);

    populate_copyrights_text_view(copyrights_text_view, player);
    
    g_signal_connect (G_OBJECT (dialog), "destroy",
                      G_CALLBACK (hxplay_about_dialog_destroy),
                      about);
    
    return GTK_DIALOG(dialog);
}
