/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: sysinfo.h,v 1.1.2.1.2.2 2004/09/18 01:58:13 rggammon Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef _SYSINFO_H_
#define _SYSINFO_H_

#include <glib.h>

typedef enum
{
    /* from uname() */
    HX_SYS_INFO_OPERATING_SYSTEM = 0,
    HX_SYS_INFO_KERNEL_VERSION,
    HX_SYS_INFO_PROCESSOR_TYPE,

    /* from /etc/lsb-release (may also get filled in by another /etc
       file, as this is not a very widely implemented standard) */
    HX_SYS_INFO_LSB_VERSION,         /* 1.3    */
    HX_SYS_INFO_DISTRIB_ID,          /* Debian */
    HX_SYS_INFO_DISTRIB_RELEASE,     /* 3.1    */
    HX_SYS_INFO_DISTRIB_DESCRIPTION, /* Debian GNU/Linux */
    HX_SYS_INFO_DISTRIB_CODENAME,    /* Sarge */
    
    /* from the player */
    HX_SYS_INFO_PLAYER_NAME,      /* RealPlayer, Helix Player */
    HX_SYS_INFO_PLAYER_VERSION,   /* 0.4.0.123 */    
    HX_SYS_INFO_PLAYER_DISTCODE,  /* RPX11D */
    HX_SYS_INFO_PLAYER_ORIGCODE,  /* RPX10D -- before any upgrades */

    /* set at compile time */
    HX_SYS_INFO_GCC_VERSION,      /* 3.3.3 */

    /* from LANG environment variables */
    HX_SYS_INFO_GETTEXT_LANGUAGE,         /* fr_FR:de_DE.utf-8:en */
    
    /* XXXRGG: Implement the rest of these */
    
    /* for shared clients, down the road... */
//    HX_SYS_INFO_CLIENT_VERSION,
//    HX_SYS_INFO_CLIENT_INSTALLER, /* rpm, binary, unknown */
//    HX_SYS_INFO_CLIENT_ORIGIN,    /* helixcommunity.org */
    
    /* xdpyinfo information */
//    HX_SYS_INFO_XSERVER_VERSION,  /* 4.3.0.1 */

    /* from gtk */
//    HX_SYS_INFO_GTK_VERSION,      /* 2.0.9   */
//    HX_SYS_INFO_LIBC_VERSION,     /* 2.3.2   */

    /* xvinfo information */
//    HX_SYS_INFO_XV_DRIVER,         /* ATI Radeon Video Overlay */

    /* maybe /dev/sndstat? */
//    HX_SYS_INFO_SOUND_DRIVER,      /* emu10k1 */    
//    HX_SYS_INFO_SOUND_DRIVER_TYPE  /* oss     */
} HXSysInfoParamType;

typedef struct _HXSysInfo HXSysInfo;

HXSysInfo* hx_sys_info_new       (void);
gchar*     hx_sys_info_get_param (HXSysInfo*         info,
                                  HXSysInfoParamType param);
void       hx_sys_info_destroy   (HXSysInfo*         info);

// XXXRGG: Hack! FIXME when we fix preferences
void       hx_sys_info_set_distcode (const gchar* distcode);
void       hx_sys_info_set_origcode (const gchar* origcode);

#endif
