/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: hxerrorstrings.h,v 1.2.10.3.2.1 2004/08/25 18:35:18 rggammon Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */


/* XXXRGG: This file was created from Helix.strings from the mac project.
   I did this by hand -- in the future, the core is changing the way they
   do strings. */

/* This should only be included by hx_error.cpp. All other files should use
   the hx_error_get_message_from_hxresult function. */

#include "hxresult.h" 

#include "hx-i18n.h"

static const struct
{
    guint code;
    const gchar* message;
} g_hxerror_to_message_map[] =
{
    { HXR_COULDNOTINITCORE,     N_("Could not initialize the playback engine.") },
    { HXR_FAIL,                 N_("A general error has occurred.")             },
    { HXR_OUTOFMEMORY,          N_("Out of memory. You may need to close some other applications to play this content.") },
    { HXR_INVALID_PARAMETER,    N_("Invalid parameter. Unable to process request.") },
    { HXR_NOT_INITIALIZED,      N_("Not initialized.") },
    { HXR_INVALID_FILE,         N_("Unsupported document type.") },
    { HXR_INVALID_VERSION,      N_("Invalid file version number.") },
    { HXR_DOC_MISSING,          N_("Requested file not found. The link you followed may be outdated or inaccurate.") },
    { HXR_BAD_FORMAT,           N_("Unknown data format.") },
    { HXR_NET_SOCKET_INVALID,   N_("Invalid socket error.") },
    { HXR_NET_CONNECT,          N_("Connection to server could not be established. You may be experiencing network problems.") },
    { HXR_BIND,                 N_("An error occurred binding to network socket.") },
    { HXR_SOCKET_CREATE,        N_("An error occurred while creating a network socket.") },
    { HXR_INVALID_HOST,         N_("Unable to establish a connection with the server.") },
    { HXR_INVALID_PATH,         N_("Requested URL is not valid.") },

    { HXR_MULTICAST_JOIN,          N_("An error occurred attempting to join multicast session.") },
    { HXR_MULTICAST_UDP,           N_("Cannot receive audio data from this multicast session. You may wish to try the TCP data option in the Network Preferences. Please contact your system administrator for more information.") },
    { HXR_NO_CODECS,               N_("No codecs have been installed on your system.") },
    { HXR_SLOW_MACHINE,            N_("Your CPU is unable to decode this content in real time. Try closing other applications, or setting your bandwidth preference lower to receive less complex content.") },
    { HXR_INVALID_HTTP_PROXY_HOST, N_("Invalid hostname for HTTP proxy.") },
    { HXR_INVALID_METAFILE,        N_("Invalid Metafile") },
    { HXR_BAD_TRANSPORT,           N_("Bad Transport") },
    { HXR_UNSUPPORTED_VIDEO,       N_("The file contains an unsupported video format. The needed codec is not installed on your system.") },
    { HXR_UNSUPPORTED_AUDIO,       N_("The file contains an unsupported audio format. The needed codec is not installed on your system.") },
    { HXR_MISSING_COMPONENTS,      N_("Some components are not available to provide playback of this presentation on your system.") },
    { HXR_TRY_AUTOCONFIG,          N_("Unable to connect to server.  Check network transport settings or run auto-configure.") },
    { HXR_NOTENOUGH_BANDWIDTH,     N_("You cannot receive this content.  You do not have enough network bandwidth.") },

    { HXR_NET_READ,              N_("An error occurred while reading data from the network.") },
    { HXR_NET_WRITE,             N_("An error occurred while writing data to the network.") },
    { HXR_NET_UDP,               N_("Cannot receive UDP data packets. You may wish to try the TCP data option in Network Preferences. You may also want to configure firewall proxy settings in Proxy Preferences. Please contact your system administrator for more information.") },
    { HXR_SERVER_TIMEOUT,        N_("Connection to server has timed out. You may be experiencing network problems.") },
    { HXR_SERVER_DISCONNECTED,   N_("Connection to server has been lost. You may be experiencing network problems.") },
    { HXR_DNR,                   N_("Unable to locate server. This server does not have a DNS entry. Please check the server name in the URL and try again.") },
    { HXR_OPEN_DRIVER,           N_("Cannot open the network drivers.") },
    { HXR_BAD_SERVER,            N_("This server is not using a recognized protocol.") },
    { HXR_ADVANCED_SERVER,       N_("You need a newer version of this product to access the requested server. Please upgrade.") },
    { HXR_OLD_SERVER,            N_("Connection closed. The host's version of the RealNetworks server is too old for this client.") },
    { HXR_DEC_NOT_FOUND,         N_("File compression not supported. Cannot locate the requested decoder.") },
    { HXR_DEC_INVALID,           N_("The requested decoder is not valid.") },
    { HXR_DEC_TYPE_MISMATCH,     N_("Decoder type mismatch. Cannot load the requested decoder.") },
    { HXR_DEC_INIT_FAILED,       N_("Requested decoder cannot be found or cannot be used on this machine.") },
    { HXR_DEC_NOT_INITED,        N_("Decoder was not initialized before attempting to use it.") },

     
    { HXR_DEC_DECOMPRESS,     N_("Unable to decompress this content.") },
    { HXR_SERVER_ALERT,       N_("Server alert.") },
    { HXR_PROXY,              N_("Proxy status error.") },
    { HXR_PROXY_RESPONSE,     N_("Proxy invalid response error.") },
    { HXR_OLD_PROXY,          N_("Connection closed. The proxy is too old for this client.") },
    { HXR_AUDIO_DRIVER,       N_("Cannot open the audio device. Another application may be using it.") },
    { HXR_INVALID_PROTOCOL,   N_("Invalid protocol specified in URL. URLs should typically start with 'rtsp://', 'pnm://', or 'http://'") },
    { HXR_INVALID_URL_OPTION, N_("Invalid option specified in URL.") },
    { HXR_INVALID_URL_HOST,   N_("Invalid host string in requested URL.") },
    { HXR_INVALID_URL_PATH,   N_("Invalid resource path string in requested URL.") },
    { HXR_GENERAL_NONET,      N_("Cannot find winsock services. Please remove old Internet software from your system and try again.") },
//  { HXR_NEED_256_COLORS,    N_("A minimum of 256 colors is required to properly display video.  If you would like to enable video, please modify your display settings and restart.") },
//  { HXR_CLV_NOT_SUPPORTED,  N_("ClearVideo not supported in this OS.") },
//  { HXR_CANNOTGOFULLSCREEN, N_("Cannot switch to fullscreen mode.") },

    { HXR_ADVANCED_PROXY,            N_("You need a newer version of this product to access the requested proxy. Please upgrade.") },
//  { HXR_UPGRADE_NO_RESPONSE,       N_("Upgrade site is not responding") },
//  { HXR_AC_DNS_TIMEOUT,            N_("No response from the Domain Name Server. Please re-check your Internet connection and try again.") },
//  { HXR_HTTP_NOTAVAIL,             N_("Content not available by HTTP") },
    { HXR_HTTP_CONNECT,              N_("Could not connect to Server using HTTP") },
//  { HXR_WIN32_INVALID_SOCKET,      N_("Unsupported Internet Software. This product requires Internet software built for Windows 95/NT or later. Be sure you have the latest software from your Internet Service Provider.") },
    { HXR_PULL_AUTHENTICATION_FAILED,N_("The User Name and Password entered are not valid.  Would you like to try again?") },
//  { HXR_VFW_NOT_SUPPORTED,         N_("Video for Windows not supported by the OS.") },
    { HXR_PERFECTPLAY_NOT_SUPPORTED, N_("Requested server does not support PerfectPlay.") },
    { HXR_NO_LIVE_PERFECTPLAY,       N_("PerfectPlay not supported for live streams.") },
    { HXR_NOT_AUTHORIZED,            N_("Access Denied") },
    { HXR_RIGHTS_EXPIRED,            N_("Your rights to view this content have expired.") },
    { HXR_CHECK_RIGHTS,              N_("Viewing time for this playback has expired. Check for more plays in View Content Rights.") },
    { HXR_RESTORE_SERVER_DENIED,     N_("Server has denied your restore request.") },
    { HXR_DEBUGGER_DETECTED,         N_("Please quit any debuggers before attempting to play secure content.") },
    { HXR_RESTORE_SERVER_CONNECT,    N_("Connection to restoration server could not be established. You may be experiencing network problems.") },
    { HXR_RESTORE_SERVER_TIMEOUT,    N_("Connection to restoration server has timed out. You may be experiencing network problems.") },
    { HXR_REVOKE_SERVER_CONNECT,     N_("Connection to revocation server to get the updated revocation list could not be established. You may be experiencing network problems. Playback cannot continue until a connection is established.") },
    { HXR_REVOKE_SERVER_TIMEOUT,     N_("Connection to revocation server to get the updated revocation list has timed out. You may be experiencing network problems. Playback cannot continue until a connection is established.") },
    { HXR_RESTORATION_COMPLETE,      N_("Your rights have been restored successfully.") },
    { HXR_BACKUP_COMPLETE,           N_("Your rights have been backed up successfully.") },
    { HXR_TLC_NOT_CERTIFIED,         N_("This application is not certified to play secure content.") },
    { HXR_CORRUPTED_BACKUP_FILE,     N_("The backup file is invalid.") },
    { HXR_PERFECTPLAY_NOT_ALLOWED,   N_("PerfectPlay not allowed on this clip.") },
    { HXR_GENERAL_MULTICAST,         N_("An error occurred accessing a multicast session.") },
    { HXR_PROXY_DNR,                 N_("Unable to locate proxy server. This proxy server does not have a DNS entry. Please check the proxy server name and try again") },
    { HXR_PROXY_NET_CONNECT,         N_("Connection to proxy server could not be established. You may be experiencing network problems.") },				

    { HXR_VIEW_SOURCE_NOCLIP,        N_("No clip is available.") },
    { HXR_VIEW_SOURCE_DISSABLED,     N_("The provider of this content has not granted permission to view the source.") },
    { HXR_VIEW_RIGHTS_NODRM,         N_("None of the installed Digital Rights Managers support viewing rights.") },
    { HXR_VSRC_DISABLED,             N_("Select More Info to learn about viewing clip source.") },
    { HXR_VSRC_NOCLIP,               N_("Select More Info to learn about viewing clip source.") },
    { HXR_VSRC_NODRM,                N_("Play some secure content to upgrade to a secure DRM.") },
};
