/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: CHXStatisticTracker.h,v 1.4.20.4 2004/07/09 01:49:47 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef _CHXSTATISTIC_TRACKER_H_
#define _CHXSTATISTIC_TRACKER_H_

// #define LOG_STATISTICS_DEBUG_INFO 1

#include "CHXClientUnknown.h"

#include "enter_hx_headers.h"
#include "hxmon.h"   // IHXRegistry, IHXPropWatch, IHXPropWatchResponse, HXPropType
#include "hxengin.h" // IHXInterruptSafe
#include "exit_hx_headers.h"

#include "HXClientCallbacks.h"

	typedef int HXBOOL;

class CHXFlatArray;
class CHXStatisticTracker;
class CHXStatisticTrackerNode
	: public CHXClientUnknown
	, public IHXPropWatchResponse
{
    DECLARE_UNKNOWN_NOCREATE( CHXStatisticTrackerNode )

private:

	IHXRegistry* m_pRegistry;
	IHXPropWatch* m_pPropWatch;
	char* m_PropName;
	CHXStatisticTracker* m_pParentTracker;
	UINT32 m_PropID;
		
protected:

	CHXStatisticTracker* GetParentTracker( void ) const
	{
		return m_pParentTracker;
	}
	
public:

	CHXStatisticTrackerNode( IHXRegistry* pIRegistry, CHXStatisticTracker* pParentTracker, UINT32 propID, const char* pFullPropName );
	virtual ~CHXStatisticTrackerNode( void );

	bool IsWatchingMe( void ) const;
	virtual bool StartWatchingMe( void );
	void StopWatchingMe( void );
	
	IHXRegistry* GetRegistry( void ) const
	{
		return m_pRegistry;
	}
	UINT32 GetPropID( void ) const
	{
		return m_PropID;
	}
	const char* GetPropName( void ) const
	{
		return m_PropName;
	}
	bool GetStatisticsFor( const char* pStatisticKey, unsigned char* pValueBuffer, UINT32 bufferLength, int* pValueType, UINT32* pUsedBufferLength = NULL );

	virtual bool AddObserver( const char* pStatisticKey, const HXStatisticsCallbacks* pStatisticsCallbacks, void* observerInfo ) = 0;
	virtual void RemoveObserver( const char* pStatisticKey, const HXStatisticsCallbacks* pStatisticsCallbacks, void* observerInfo ) = 0;

#ifdef LOG_STATISTICS_DEBUG_INFO
	void ExamineProperty( const UINT32 ulId, const char* pMsg );
	void ExamineStatistics( void );
#endif
};

struct SHXTrackerEntryObserverData
{
	const HXStatisticsCallbacks* m_pStatisticsCallbacks;
	void* m_ObserverInfo;
};

class CHXStatisticTrackerEntry
	: public CHXStatisticTrackerNode
{
    DECLARE_UNKNOWN_NOCREATE( CHXStatisticTrackerEntry )

private:

	CHXFlatArray* m_pEntryObservers;
		
public:

	CHXStatisticTrackerEntry( IHXRegistry* pIRegistry, CHXStatisticTracker* pParentTracker, UINT32 propID, const char* pFullPropName );
	virtual ~CHXStatisticTrackerEntry( void );
	
	virtual bool AddObserver( const char* pStatisticKey, const HXStatisticsCallbacks* pStatisticsCallbacks, void* observerInfo );
	virtual void RemoveObserver( const char* pStatisticKey, const HXStatisticsCallbacks* pStatisticsCallbacks, void* observerInfo );

	// IHXPropWatchResponse
	STDMETHOD ( AddedProp ) ( THIS_ const UINT32 ulId, const HXPropType propType, const UINT32 ulParentID );
	STDMETHOD ( ModifiedProp ) ( THIS_ const UINT32 ulId, const HXPropType propType, const UINT32 ulParentID );
	STDMETHOD ( DeletedProp ) ( THIS_ const UINT32 ulId, const UINT32 ulParentID );
};

struct SHXTrackerObserverData
{
	char* m_StatisticKey;
	const HXStatisticsCallbacks* m_pStatisticsCallbacks;
	void* m_ObserverInfo;
};

_INTERFACE IHXPlayer;
class CHXStatisticTracker
	: public CHXStatisticTrackerNode
	, public IHXInterruptSafe
{
    DECLARE_UNKNOWN_NOCREATE( CHXStatisticTracker )

private:

	CHXFlatArray* m_pStatisticTrackerNodes;
	CHXFlatArray* m_pObservers;
	
	CHXStatisticTrackerNode* FindStatisticTrackerNode( const UINT32 ulId, UINT32* pOutIndex ) const;
	
public:

	CHXStatisticTracker( IHXRegistry* pIRegistry, CHXStatisticTracker* pParentTracker, UINT32 propID, const char* pFullPropName );
	virtual ~CHXStatisticTracker( void );

	static CHXStatisticTracker* CreatePlayerStatisticTracker( IHXPlayer* pIHXPlayer );
	static void DestroyPlayerStatisticTracker( CHXStatisticTracker* pPlayerStatisticTracker );
	
	virtual bool StartWatchingMe( void );
	
	virtual bool AddObserver( const char* pStatisticKey, const HXStatisticsCallbacks* pStatisticsCallbacks, void* observerInfo );
	virtual void RemoveObserver( const char* pStatisticKey, const HXStatisticsCallbacks* pStatisticsCallbacks, void* observerInfo );
	
	// IHXPropWatchResponse
	STDMETHOD ( AddedProp ) ( THIS_ const UINT32 ulId, const HXPropType propType, const UINT32 ulParentID );
	STDMETHOD ( ModifiedProp ) ( THIS_ const UINT32 ulId, const HXPropType propType, const UINT32 ulParentID );
	STDMETHOD ( DeletedProp ) ( THIS_ const UINT32 ulId, const UINT32 ulParentID );

	// IHXInterruptSafe
	STDMETHOD_( HXBOOL, IsInterruptSafe ) ( THIS );
};

#endif
