/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: casyntim.cpp,v 1.5.32.1 2004/07/09 02:06:33 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#include "hxtypes.h"
#include "hxresult.h"
#include "hxtick.h"

#include "timeval.h"
#include "pq.h"
#include "hxthread.h"

#include "hxcom.h"
#include "hxengin.h"
#include "hxsched.h"

#include "hxmsgs.h"
#include "casyntim.h"

#include "hxheap.h"
#ifdef _DEBUG
#undef HX_THIS_FILE		
static const char HX_THIS_FILE[] = __FILE__;
#endif

//XXXgfw when we do thread priorities on linux we will change this.
#ifdef _UNIX
#define THREAD_PRIORITY_HIGHEST 1
#define THREAD_PRIORITY_NORMAL  0
#elif defined (_CARBON)
#define THREAD_PRIORITY_HIGHEST 10000
#define THREAD_PRIORITY_NORMAL 100
#elif defined(_SYMBIAN)
#include <e32std.h>
#define THREAD_PRIORITY_HIGHEST EPriorityMuchMore
#define THREAD_PRIORITY_NORMAL EPriorityNormal
#elif defined(_OPENWAVE)
#define THREAD_PRIORITY_HIGHEST 1
#define THREAD_PRIORITY_NORMAL  0
#endif

void* ThreadRoutine2(void * pArg);

CAsyncTimer::CAsyncTimer(HXScheduler* pScheduler)
{
    m_pScheduler    = pScheduler;
    m_ulStartTime   = 0;
    m_ulGranularity = 100;
    m_pThread	    = NULL;
    m_pQuitEvent    = NULL;
    m_uPlayingStateCount = 0;
}

CAsyncTimer::~CAsyncTimer()
{
    StopTimer();
}

//  timegettime

HX_RESULT CAsyncTimer::StartTimer(void)
{
    HX_RESULT theErr = HXR_OK;

#ifdef THREADS_SUPPORTED
    theErr = HXThread::MakeThread(m_pThread);
    HXEvent::MakeEvent(m_pQuitEvent, NULL);
#else
    theErr = HXThread::MakeStubThread(m_pThread);
    HXEvent::MakeStubEvent(m_pQuitEvent, NULL);
#endif

    if (!theErr)
    {
	theErr = m_pThread->CreateThread(ThreadRoutine2, (void*) this);
    }

    return theErr;
}

HX_RESULT CAsyncTimer::StopTimer(void)
{
    if (m_pThread)
    {
	HXThreadMessage msg(HXMSG_QUIT, NULL, NULL);
	if (m_pThread->PostMessage(&msg) == HXR_OK)
	{
	    m_pQuitEvent->Wait(ALLFS);
	}
	m_pThread->Exit(0);
	delete m_pThread;
	m_pThread = 0;
    }

    if (m_pQuitEvent)
    {
	delete m_pQuitEvent;
	m_pQuitEvent = 0;
    }

    return HXR_OK;
}

BOOL CAsyncTimer::InTimerThread(void)
{
    BOOL bRet = FALSE;

    if (m_pThread)
    {
	UINT32 ulThreadId = 0;

	m_pThread->GetThreadId(ulThreadId);

	if (ulThreadId == m_pThread->GetCurrentThreadID())
	{
	    bRet = TRUE;
	}
    }

    return bRet;
}

void CAsyncTimer::NotifyPlayState(BOOL bInPlayingState)
{
    HX_ASSERT(bInPlayingState || (m_uPlayingStateCount > 0));

    if (bInPlayingState)
    {
	m_uPlayingStateCount++;
	HX_ASSERT(m_pThread != NULL);
	if (m_uPlayingStateCount == 1 && m_pThread)
	{
	    m_pThread->SetPriority(THREAD_PRIORITY_HIGHEST);
	}
    }
    else if (m_uPlayingStateCount > 0)
    {
	m_uPlayingStateCount--;
	HX_ASSERT(m_pThread != NULL);
	if (m_uPlayingStateCount == 0 && m_pThread)
	{
	    m_pThread->SetPriority(THREAD_PRIORITY_NORMAL);
	}
    }
}

void* ThreadRoutine2(void * pArg)
{
    CAsyncTimer* pAsyncTimer = (CAsyncTimer*) pArg;
    ULONG32 ulSleepTime = pAsyncTimer->m_ulGranularity;

    ULONG32 ulStartTime = HX_GET_TICKCOUNT();

    HXThread*	    pThread = pAsyncTimer->m_pThread;
    HXThreadMessage msg;
    BOOL	    bDone   = FALSE;
    UINT32	    ulLastTimerCallback = ulStartTime;

    UINT32 ulTimerId = HXAsyncTimer::SetTimer(ulSleepTime, pThread );
    
    while (!bDone && pThread->GetMessage(&msg, 0,0) == HXR_OK)
    {
	switch (msg.m_ulMessage)
	{
	    case HXMSG_ASYNC_TIMER: 
		{
		    ULONG32 ulCurrentTime = HX_GET_TICKCOUNT();
		    if (CALCULATE_ELAPSED_TICKS(ulLastTimerCallback, ulCurrentTime) 
			    >= ulSleepTime)
		    {
			ulLastTimerCallback = ulCurrentTime;
			pAsyncTimer->m_pScheduler->OnTimeSync(TRUE);
		    }
		}
		break;
	    case HXMSG_QUIT:
		bDone	= TRUE;
		break;
	    default:
		pThread->DispatchMessage(&msg);
		break;
	}
    }

    HXAsyncTimer::KillTimer(ulTimerId);

    pAsyncTimer->m_pQuitEvent->SignalEvent();

    return (void*) 0;
}
