/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: cladvsnk.h,v 1.1.26.1 2004/07/09 01:54:36 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef CLADVSNK_H
#define CLADVSNK_H

// Forward declarations
typedef _INTERFACE IHXPlayer IHXPlayer;

class PXClientAdviseSinkResponse
{
public:
    // IUnknown methods
    STDMETHOD(QueryInterface)   (THIS_ REFIID riid, void** ppvObj) PURE;
    STDMETHOD_(ULONG32,AddRef)  (THIS) PURE;
    STDMETHOD_(ULONG32,Release) (THIS) PURE;
    // PXClientAdviseSinkResponse methods
    STDMETHOD(CASOnPosLength)          (THIS_ UINT32 ulPosition, UINT32 ulLength) PURE;
    STDMETHOD(CASOnPresentationOpened) (THIS) PURE;
    STDMETHOD(CASOnPresentationClosed) (THIS) PURE;
    STDMETHOD(CASOnStatisticsChanged)  (THIS) PURE;
    STDMETHOD(CASOnPreSeek)            (THIS_ ULONG32 ulOldTime, ULONG32 ulNewTime) PURE;
    STDMETHOD(CASOnPostSeek)           (THIS_ ULONG32 ulOldTime, ULONG32 ulNewTime) PURE;
    STDMETHOD(CASOnStop)               (THIS) PURE;
    STDMETHOD(CASOnPause)              (THIS_ ULONG32 ulTime) PURE;
    STDMETHOD(CASOnBegin)              (THIS_ ULONG32 ulTime) PURE;
    STDMETHOD(CASOnBuffering)          (THIS_ ULONG32 ulFlags, UINT16 unPercentComplete) PURE;
    STDMETHOD(CASOnContacting)         (THIS_ const char* pHostName) PURE;
};

class PXClientAdviseSink : public IHXClientAdviseSink
{
public:
    PXClientAdviseSink();
    virtual ~PXClientAdviseSink();

    // IUnknown methods
    STDMETHOD(QueryInterface)   (THIS_ REFIID riid, void** ppvObj);
    STDMETHOD_(ULONG32,AddRef)  (THIS);
    STDMETHOD_(ULONG32,Release) (THIS);
    // PXClientAdviseSink methods
    STDMETHOD(Init)  (THIS_ IHXPlayer*                 pPlayer,
                            PXClientAdviseSinkResponse* pResponse);
    STDMETHOD(Close) (THIS);
    // IHXClientAdviseSink methods
    STDMETHOD(OnPosLength)          (THIS_ UINT32 ulPosition, UINT32 ulLength);
    STDMETHOD(OnPresentationOpened) (THIS);
    STDMETHOD(OnPresentationClosed) (THIS);
    STDMETHOD(OnStatisticsChanged)  (THIS);
    STDMETHOD(OnPreSeek)            (THIS_ ULONG32 ulOldTime, ULONG32 ulNewTime);
    STDMETHOD(OnPostSeek)           (THIS_ ULONG32 ulOldTime, ULONG32 ulNewTime);
    STDMETHOD(OnStop)               (THIS);
    STDMETHOD(OnPause)              (THIS_ ULONG32 ulTime);
    STDMETHOD(OnBegin)              (THIS_ ULONG32 ulTime);
    STDMETHOD(OnBuffering)          (THIS_ ULONG32 ulFlags, UINT16 unPercentComplete);
    STDMETHOD(OnContacting)         (THIS_ const char* pHostName);
protected:
    INT32                       m_lRefCount;
    IHXPlayer*                 m_pPlayer;
    PXClientAdviseSinkResponse* m_pResponse;
};

#endif
