/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: pxgifrnd.h,v 1.3.22.1 2004/07/09 01:54:03 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef _GIF_RENDER_H
#define _GIF_RENDER_H

// Forward declarations
typedef _INTERFACE IHXStream                        IHXStream;
typedef _INTERFACE IHXPlayer                        IHXPlayer;
typedef _INTERFACE IHXValues                        IHXValues;
typedef _INTERFACE IHXPacket                        IHXPacket;
typedef _INTERFACE IHXBuffer                        IHXBuffer;
typedef _INTERFACE IHXSite                          IHXSite;
typedef _INTERFACE IHXVideoSurface                  IHXVideoSurface;
typedef _INTERFACE IHXMultiInstanceSiteUserSupplier IHXMultiInstanceSiteUserSupplier;
typedef _INTERFACE IHXCommonClassFactory            IHXCommonClassFactory;
typedef _INTERFACE IHXHyperNavigate                 IHXHyperNavigate;
typedef _INTERFACE IHXScheduler                     IHXScheduler;
typedef _INTERFACE IHXStatusMessage                 IHXStatusMessage;
typedef _INTERFACE IHXErrorMessages                 IHXErrorMessages;
typedef _INTERFACE IHXUpdateProperties              IHXUpdateProperties;
class CGIFCodec;
class CResourceLoader;
class PXCallback;
class PXClientAdviseSink;

class CGIFRenderer : public CHXBaseCountingObject,
                     public IHXPlugin, 
                     public IHXRenderer, 
                     public IHXSiteUser,
                     public IHXStatistics,
                     public IHXValues,
                     public IHXUpdateProperties,
                     public PXCallbackResponse,
                     public PXClientAdviseSinkResponse
{
public:
    CGIFRenderer();
    virtual ~CGIFRenderer();

    // IUnknown Methods
    STDMETHOD (QueryInterface)  (THIS_ REFIID ID, void** ppObj);
    STDMETHOD_(UINT32, AddRef)  (THIS);
    STDMETHOD_(UINT32, Release) (THIS);

    // IHXPlugin Methods
    STDMETHOD(GetPluginInfo) (THIS_ REF(BOOL)        rbLoadMultiple,
                                    REF(const char*) rpszDescription,
                                    REF(const char*) rpszCopyright,
                                    REF(const char*) rpszMoreInfoURL,
                                    REF(UINT32)      rulVersionNumber);
    STDMETHOD(InitPlugin)    (THIS_ IUnknown* pContext);

    // IHXRenderer Methods
    STDMETHOD(GetRendererInfo) (THIS_ REF(const char**) rppszStreamMimeType,
                                      REF(UINT32)        rulInitialGranularity);
    STDMETHOD(StartStream)     (THIS_ IHXStream* pStream, IHXPlayer* pPlayer);
    STDMETHOD(EndStream)       (THIS);
    STDMETHOD(OnHeader)        (THIS_ IHXValues* pStreamHeaderObj);
    STDMETHOD(OnPacket)        (THIS_ IHXPacket* pPacket, INT32 lTimeOffset);
    STDMETHOD(OnTimeSync)      (THIS_ UINT32 ulTime);
    STDMETHOD(OnPreSeek)       (THIS_ UINT32 ulTimeBefore, UINT32 ulTimeAfter);
    STDMETHOD(OnPostSeek)      (THIS_ UINT32 ulTimeBefore, UINT32 ulTimeAfter);
    STDMETHOD(OnPause)         (THIS_ UINT32 ulTimeBeforePause);
    STDMETHOD(OnBegin)         (THIS_ UINT32 ulTimeAfterBegin);
    STDMETHOD(OnBuffering)     (THIS_ UINT32 ulReason, UINT16 usPercentComplete);
    STDMETHOD(GetDisplayType)  (THIS_ REF(HX_DISPLAY_TYPE) rDisplayType,
                                      REF(IHXBuffer*)     rpDisplayInfo);
    STDMETHOD(OnEndofPackets)  (THIS);

    // IHXSiteUser Methods
    STDMETHOD(AttachSite)               (THIS_ IHXSite* pSite);
    STDMETHOD(DetachSite)               (THIS);
    STDMETHOD(HandleEvent)              (THIS_ HXxEvent* pEvent);
    STDMETHOD_(BOOL,NeedsWindowedSites) (THIS);

    // IHXStatistics methods
    STDMETHOD(InitializeStatistics) (THIS_ UINT32 ulRegistryID);
    STDMETHOD(UpdateStatistics)     (THIS);

    // IHXValues methods
    STDMETHOD(SetPropertyULONG32)      (THIS_ const char* pName, ULONG32 ulVal);
    STDMETHOD(GetPropertyULONG32)      (THIS_ const char* pName, REF(ULONG32) rulVal);
    STDMETHOD(GetFirstPropertyULONG32) (THIS_ REF(const char*) rpName, REF(ULONG32) rulVal);
    STDMETHOD(GetNextPropertyULONG32)  (THIS_ REF(const char*) rpName, REF(ULONG32) rulVal);
    STDMETHOD(SetPropertyBuffer)       (THIS_ const char* pName, IHXBuffer* pVal);
    STDMETHOD(GetPropertyBuffer)       (THIS_ const char* pName, REF(IHXBuffer*) rpVal);
    STDMETHOD(GetFirstPropertyBuffer)  (THIS_ REF(const char*) rpName, REF(IHXBuffer*) rpVal);
    STDMETHOD(GetNextPropertyBuffer)   (THIS_ REF(const char*) rpName, REF(IHXBuffer*) rpVal);
    STDMETHOD(SetPropertyCString)      (THIS_ const char* pName, IHXBuffer* pVal);
    STDMETHOD(GetPropertyCString)      (THIS_ const char* pName, REF(IHXBuffer*) rpVal);
    STDMETHOD(GetFirstPropertyCString) (THIS_ REF(const char*) rpName, REF(IHXBuffer*) rpVal);
    STDMETHOD(GetNextPropertyCString)  (THIS_ REF(const char*) rpName, REF(IHXBuffer*) rpVal);

    // IHXUpdateProperties methods
    STDMETHOD(UpdatePacketTimeOffset)  (THIS_ INT32 lTimeOffset);
    STDMETHOD(UpdatePlayTimes)	       (THIS_
				        IHXValues* pProps);
    // PXCallbackResponse methods
    STDMETHOD(HandleCallback) (THIS_ UINT32 ulSchedulerTime, UINT32 ulInstance);

    // PXClientAdviseSinkResponse methods
    STDMETHOD(CASOnPosLength)          (THIS_ UINT32 ulPosition, UINT32 ulLength);
    STDMETHOD(CASOnPresentationOpened) (THIS);
    STDMETHOD(CASOnPresentationClosed) (THIS);
    STDMETHOD(CASOnStatisticsChanged)  (THIS);
    STDMETHOD(CASOnPreSeek)            (THIS_ ULONG32 ulOldTime, ULONG32 ulNewTime);
    STDMETHOD(CASOnPostSeek)           (THIS_ ULONG32 ulOldTime, ULONG32 ulNewTime);
    STDMETHOD(CASOnStop)               (THIS);
    STDMETHOD(CASOnPause)              (THIS_ ULONG32 ulTime);
    STDMETHOD(CASOnBegin)              (THIS_ ULONG32 ulTime);
    STDMETHOD(CASOnBuffering)          (THIS_ ULONG32 ulFlags, UINT16 unPercentComplete);
    STDMETHOD(CASOnContacting)         (THIS_ const char* pHostName);

    // CGIFRenderer methods
    void      HandleClick();
    void      DrawToRMASurface(IHXVideoSurface* pVideoSurface, UINT32 ulX, UINT32 ulY, const HXxSize &size);
    HX_RESULT RMASurfaceUpdate2(IHXSubRectVideoSurface* pSurface,
                                HXxRect*                 pExtents,
                                HXxBoxRegion*              pDirtyRegion);
    HX_RESULT UpdateDisplay(UINT32 ulTime);

    // CGIFRenderer static public methods
    static HX_RESULT STDAPICALLTYPE HXCreateInstance(IUnknown** ppIUnknown);
protected:
    enum
    {
        kCallbackInterval      = 30,
        kMinCallbackInterval   = 20,
        kNotFinishedInterval   = 100,
        kTargetBrowser         = 0,
        kTargetPlayer          = 1
    };

    INT32                              m_lRefCount;
    IUnknown*                          m_pContext;
    IHXStream*                        m_pStream;
    HXxSize                            m_cSize;
    IHXMultiInstanceSiteUserSupplier* m_pMISUS;
    IHXSite*                          m_pMISUSSite;
    IHXCommonClassFactory*            m_pCommonClassFactory;
    IHXHyperNavigate*                 m_pHyperNavigate;
    CGIFCodec*                         m_pGIFCodec;
    UINT32                             m_ulBitsPerPixel;
    UINT32                             m_ulBytesPerPixel;
    UINT32                             m_ulPadWidth;
    UINT32                             m_ulCurImg;
    UINT32                             m_ulCurImgRenderTime;
    UINT32                             m_ulCurDelayTime;
    UINT32                             m_ulDataWidth;
    IHXBuffer*                        m_pOutputBuffer;
    BYTE                               m_ucTarget;
    GString                            m_cURL;
    UINT32                             m_ulBackgroundColor;
    IHXScheduler*                     m_pScheduler;
    UINT32                             m_ulLoopsDone;
    IHXStatusMessage*                 m_pStatusMessage;
    INT16                              m_sOldMouseX;
    INT16                              m_sOldMouseY;
    INT32                              m_lLastImg;
    IHXErrorMessages*                 m_pErrorMessages;
#if defined(_WINDOWS)
    HCURSOR                            m_hPreHyperlinkCursor;
    HCURSOR                            m_hHyperlinkCursor;
#elif defined(_MACINTOSH)
    CursHandle                         m_hHyperlinkCursor;
    typedef enum
    {
        CURSOR_ARROW,
        CURSOR_HYPERLINK
    }
    CursorShapes;
    CursorShapes                       m_eCurrentCursor;
    CResourceLoader*                   m_pResourceLoader;
#elif defined(_UNIX) && defined(USE_XWINDOWS)
    Cursor                              m_hHyperlinkCursor;
    Cursor                              m_hCurrentCursor;
    Display*                            m_pDisplay;          
    Window                              m_Window;
#endif
    IHXBuffer*                        m_pStreamHeaderBuffer;
    UINT32                             m_ulStreamHeaderOffset;
    PXCallback*                        m_pCallback;
    UINT32                             m_ulRendererFlags;
    UINT32                             m_ulWidth;
    UINT32                             m_ulHeight;
    IHXValues*                        m_pValues;
    UINT32                             m_ulBackgroundOpacity;
    UINT32                             m_ulMediaOpacity;
    UINT32                             m_ulMediaChromaKey;
    UINT32                             m_ulMediaChromaKeyTolerance;
    UINT32                             m_ulMediaChromaKeyOpacity;
    INT32                              m_lTimeOffset;
    HXTimeval                         m_tSchedulerTimeBase;
    UINT32                             m_ulTimeAtSchedulerTimeBase;
    UINT32                             m_ulCurFrameIndex;
    PXClientAdviseSink*                m_pClientAdviseSink;
    UINT32                             m_ulEndTime;
    // ONLY HX_BITFIELD MEMBERS SHOULD GO BELOW THIS LINE!
    // ALL OTHER MEMBER TYPES SHOULD GO ABOVE THIS LINE!
    HX_BITFIELD                        m_bRowsInverted : 1;
    HX_BITFIELD                        m_bRGBOrdering : 1;
    HX_BITFIELD                        m_bDecompressFinished : 1;
    HX_BITFIELD                        m_bSetHyperlinkCursor : 1;
    HX_BITFIELD                        m_bStatusMsgWillNeedErasing : 1;
    HX_BITFIELD                        m_bFirstTimeSync : 1;
    HX_BITFIELD                        m_bFirstDraw : 1;
    HX_BITFIELD                        m_bSiteAttached : 1;
    HX_BITFIELD                        m_bIgnorePackets : 1;
    HX_BITFIELD                        m_bImageBombed : 1;
    HX_BITFIELD                        m_bMediaChromaKeySpecified : 1;
    HX_BITFIELD                        m_bUsesAlphaChannel : 1;
    HX_BITFIELD                        m_bPreserveMediaRepeat : 1;
    HX_BITFIELD                        m_bPaused : 1;
    HX_BITFIELD                        m_bNoNativeSize : 1;
    HX_BITFIELD                        m_bCanBltSubRects : 1;

    static const char* const           m_pszName;
    static const char* const           m_pszDescription;
    static const char* const           m_pszCopyright;
    static const char* const           m_pszMoreInfoURL;
    static const char* const           m_ppszStreamMimeType[];
    static const UINT32                m_ulHighestSupportedContentVersion;
    static const UINT32                m_ulHighestSupportedStreamVersion;

    HX_RESULT                          GetCurrentMousePos(INT16& rsXPos, INT16& rsYPos);
    void                               OnMouseMove(INT16 fwKeys, INT16 xPos, INT16 yPos);
    HX_RESULT                          CopyBombImage();
    void                               DrawBackgroundColor();
    UINT32                             GetCycleTime();
    UINT32                             GetNextFrameTime(UINT32 ulTime);
    UINT32                             GetTimevalDiff(HXTimeval t1, HXTimeval t2);
    void                               DamageFrameRect(UINT32 i);
};

#endif
