/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: escrt.cpp,v 1.1.2.1 2004/07/09 01:50:34 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

 /****************************************************************************
 *  Escape RealText to HTML - Just uses the basic XMLtoHTML parser, because
 *  RealText has no links we want to reference.
 *
 */

#include "hxcom.h"     /* IUnknown */
#include "hxtypes.h" 
#include "hxbuffer.h"
#include "hxiids.h"
#include "hxstrutl.h"
#include "hxstring.h"

#include "growingq.h"
#include "xmlesc.h"
#include "escrt.h"
#include "vsrcinfo.h"

/*___________________________________________________________________________
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Static variable declarations
 *___________________________________________________________________________
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

const char* CEscapeRT::m_pHotRTTags[] = {0};

/*___________________________________________________________________________
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 *  CEscapeXMLtoHTML::OnTag(cp, pObj, queue)
 *
 *  PARAMETERS:
 *
 *	cp	It points to the first whitespace after a tag name we are
 *		looking for
 *	ulLen	Length to end of cp so we don't overrun the buffer
 *	pObj	The current state of the Parse Function, this can be used
 *		to continue parsing.
 *	queue	The queue to push the output to.
 *
 *  DESCRIPTION:
 *	Currently Real has no attributes. Therefore we should never get
 *	called.
 *
 *  RETURNS
 *	UINT32
 *	    number of characters used off cp
 *___________________________________________________________________________
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
UINT32 CEscapeRT::OnTag(const UCHAR* cp, UINT32 ulLen, DataObject* pObj,
			CBigByteGrowingQueue* pQueue)
{
    HX_ASSERT(FALSE);
    return 0;
}

/*___________________________________________________________________________
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 *  CEscapeXMLtoHTML::PushHeader(queue)
 *
 *  PARAMETERS:
 *	queue	The queue to push the output to.
 *
 *  DESCRIPTION:
 *	This function pushes the header information for the smil file.
 *
 *  RETURNS
 *	void
 *___________________________________________________________________________
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
void
CEscapeRT::PushHeader(CBigByteGrowingQueue* queue)
{
    queue->EnQueue(z_pOpen);
    char *buf = new char [ max(sizeof(z_pImage_ss) + 
                          sizeof(z_pRealTextGif) +
                          sizeof(z_pRealTextName),
                          sizeof(z_pXMLSource_s) + 
                          sizeof(z_pRealTextName))
                    ];
    sprintf(buf, z_pImage_ss, z_pRealTextGif, z_pRealTextName); /* Flawfinder: ignore */
    queue->EnQueue(buf);

    queue->EnQueue(z_pStream);
    queue->EnQueue(z_pRealTextName);
    queue->EnQueue(z_pEndLine);
    
    PushCommonHeader(queue);

    sprintf(buf, z_pXMLSource_s, z_pRealTextName); /* Flawfinder: ignore */
    queue->EnQueue(buf);
    queue->EnQueue(z_pClose);
    HX_VECTOR_DELETE(buf);
}
