# custom  macros
%define reldate	%(date '+%Y%m%d')
%define logdate	%(date '+%a %b %d %Y')

Summary		: RealPlayer
Name		: RealPlayer
Version		: _REPLACE_VERSION_
Release		: %{reldate}
Group		: Applications/Multimedia
License		: RPSL, EULA
Vendor		: RealNetworks, Inc
URL		: http://www.real.com/
Packager	: RealNetworks, Inc
Source0		: install.bz2
Prefix          : /usr/local
Requires        : gtk2
Obsoletes	: G2player, RealOne
BuildRoot	: %{_tmppath}/%{name}-buildroot
AutoReqProv     : no
# Disables generating dependencies automatically

%description
RealPlayer is a media player with the aim of providing solid media 
playback locally and via streaming. It plays RealAudio, RealVideo, MP3, 
3GPP Video, Flash, SMIL 2.0, JPEG, GIF, PNG, RealPix and RealText and 
more. The RealPlayer 10 for Linux builds on top of the popular 
open-source Helix Player.

%prep
rm -rf %buildroot
mkdir -p %buildroot%_prefix/RealPlayer


###############################################
# %setup macro
# -c      : Create directory before unpacking.
# -n name : Name the directory as name
# -T      : Disable the automatic unpacking of the archives.
# -q      : Run quiety with minimum output
###############################################
%setup -c -q

%install
mkdir -p %buildroot/usr/local
cp -a . %buildroot/usr/local/RealPlayer/
# this is not needed
rm -rf %buildroot/usr/local/RealPlayer/Bin

%post
( 
    APPNAME=RealPlayer
    TARGET=realplay
    INSTDIR="$RPM_INSTALL_PREFIX/$APPNAME"

    # setup the realplay script
    "$INSTDIR/postinst/confscript.sh" "$INSTDIR" > /dev/null

    # setup the bin link (try to find a good location for it)
    for BINDIR in "/usr/bin" "$RPM_INSTALL_PREFIX/bin" ; do
	if [ -d "$BINDIR" ] ; then
	    ln -sf "$INSTDIR/$TARGET" "$BINDIR"
	    break;
	fi
    done

    # setup mozilla
    for MOZDIR in "/usr/lib/mozilla/plugins" "/usr/lib/browser-plugins" "/opt/mozilla/lib/plugins" "/usr/lib/firefox/plugins" "/usr/lib/mozilla-firefox/plugins" "/usr/lib/netscape/plugins" "/opt/mozilla/plugins" "/opt/netscape/plugins"; do
	if [ -d "$MOZDIR" ] ; then
	    ln -sf "$INSTDIR/mozilla/nphelix.so" "$MOZDIR"
	    ln -sf "$INSTDIR/mozilla/nphelix.xpt" "$MOZDIR"
	fi
    done

    # setup .mo files
    LOCALEDIR="/usr/share/locale"
    for LANGUAGE in `ls $INSTDIR/share/locale`; do
	if [ -d "$LOCALEDIR/$LANGUAGE/LC_MESSAGES" ] ; then
	    cp "$INSTDIR/share/locale/$LANGUAGE/player.mo" "$LOCALEDIR/$LANGUAGE/LC_MESSAGES/realplay.mo"
	    cp "$INSTDIR/share/locale/$LANGUAGE/widget.mo" "$LOCALEDIR/$LANGUAGE/LC_MESSAGES/libgtkhx.mo"
	fi
    done

    # find gnome, install desktop files
    for PREFIX in "/opt/gnome" "/usr" ; do
	if [ -d "$PREFIX" ] ; then
	    SHARE="$PREFIX/share"
	    test -d "$SHARE/application-registry" && \
		install -p -m644 "$INSTDIR/share/$TARGET.applications" \
		"$SHARE/application-registry"
	    test -d "$SHARE/applications" && \
		install -p -m644 "$INSTDIR/share/$TARGET.desktop" \
		"$SHARE/applications"
	    test -d "$SHARE/mime-info" && \
		install -p -m644 "$INSTDIR/share/$TARGET.keys" \
		"$SHARE/mime-info"
	    test -d "$SHARE/mime-info" && \
		install -p -m644 "$INSTDIR/share/$TARGET.mime" \
		"$SHARE/mime-info"

        # install icons
        PIXMAPS="$SHARE/pixmaps"
        test -d "$PIXMAPS" && \
        install -p -m644 "$INSTDIR/share/$TARGET.png" "$PIXMAPS"
        HICOLOR="$SHARE/icons/hicolor"
        if [ -d "$HICOLOR" ] ; then
            for SIZE in "16x16" "32x32" "48x48" "128x128" "192x192" ; do
                mkdir -p "$HICOLOR/$SIZE"
                mkdir -p "$HICOLOR/$SIZE/apps"
                mkdir -p "$HICOLOR/$SIZE/mimetypes"

                ICON="$INSTDIR/share/icons/${TARGET}_$SIZE.png"
                if [ -f "$ICON" ] ; then
                    cp "$ICON" "$HICOLOR/$SIZE/apps/$TARGET.png"
                fi

                for MIME in \
                    "application-generic" \
                    "audio-generic"       \
                    "text-realtext"       \
                    "video-generic"       \
                    "video-ogg"           \
                    "application-ogg"     \
                    "application-ram"     \
                    "application-rpm"     \
                    "application-smil"    \
                    "application-rm"      \
                    "audio-aiff"          \
                    "audio-au"            \
                    "audio-mp3"           \
                    "audio-mp4"           \
                    "audio-ogg"           \
                    "audio-ra"            \
                    "audio-wav"           \
                    "video-avi"           \
                    "video-mov"           \
                    "video-rv"            \
                    "video-swf" ; do
                    ICON="$INSTDIR/share/icons/mime-${MIME}_$SIZE.png"
                    if [ -f "$ICON" ] ; then
                        cp "$ICON" "$HICOLOR/$SIZE/mimetypes/${TARGET}-${MIME}.png"
                    fi
                done
  	        done
	    fi
    fi
    done
)

%preun
if [ "$1" = 0 ] ; then
(
    INSTDIR="$RPM_INSTALL_PREFIX/$APPNAME"

    # remove .mo files
    LOCALEDIR="/usr/share/locale"
    for LANGUAGE in `ls $INSTDIR/share/locale`; do
        rm -f "$LOCALEDIR/$LANGUAGE/LC_MESSAGES/realplay.mo"
        rm -f "$LOCALEDIR/$LANGUAGE/LC_MESSAGES/libgtkhx.mo"
    done
)
fi

%postun
if [ "$1" = 0 ] ; then
( 
    APPNAME=RealPlayer
    TARGET=realplay
    INSTDIR="$RPM_INSTALL_PREFIX/$APPNAME"

    # remove backup file
    rm -f "$INSTDIR/$TARGET.bak"

    # remove the bin link (try to find where we put it)
    for BINDIR in "/usr/bin" "$RPM_INSTALL_PREFIX/bin" ; do
	if [ -h "$BINDIR/$TARGET" ] ; then
	    rm -f "$BINDIR/$TARGET"
	fi
    done

    # remove mozilla plugin
    for MOZDIR in "/usr/lib/mozilla" ; do
	rm -f "$MOZDIR/plugins/nphelix.so"
	rm -f "$MOZDIR/plugins/nphelix.xpt"
    done

    # find gnome, remove desktop files
    for PREFIX in "/opt/gnome" "/usr" ; do
	if [ -d "$PREFIX" ] ; then
	    SHARE="$PREFIX/share"
	    rm -f "$SHARE/application-registry/$TARGET.applications" 
	    rm -f "$SHARE/applications/$TARGET.desktop" 
	    rm -f "$SHARE/mime-info/$TARGET.keys" 
	    rm -f "$SHARE/mime-info/$TARGET.mime"

	    # uninstall icons
	    PIXMAPS="$SHARE/pixmaps"
        rm -f "$PIXMAPS/$TARGET.png"

        HICOLOR="$SHARE/icons/hicolor"
        if [ -d "$HICOLOR" ] ; then
            for SIZE in "16x16" "32x32" "48x48" "128x128" "192x192" ; do

                rm -f "$HICOLOR/$SIZE/apps/$TARGET.png"

                for MIME in \
                    "application-generic" \
                    "application-ogg"     \
                    "application-ram"     \
                    "application-rpm"     \
                    "application-smil"    \
                    "application-rm"      \
                    "audio-aiff"          \
                    "audio-au"            \
                    "audio-mp3"           \
                    "audio-mp4"           \
                    "audio-ogg"           \
                    "audio-ra"            \
                    "audio-wav"           \
                    "video-avi"           \
                    "video-mov"           \
                    "video-rv"            \
                    "video-swf" ; do
                    rm -f "$HICOLOR/$SIZE/mimetypes/${TARGET}-${MIME}.png"
                done
  	        done
	    fi
	fi
    done
)
fi

%clean
rm -rf %buildroot

%files
#####################################################

# %defattr sets the default attributes for all files
#####################################################
%defattr(-,root,root)
/usr/local/RealPlayer

%changelog
* Mon Jun 8 2004 Ryan Gammon <rgammon@real.com>
- Adding /usr/share/pixmap, document icons

* Mon Jun 7 2004 Nicholas Hart <nhart@real.com>
- added .mime/.keys/.applications files

* Wed May 5 2004 Ryan Gammon <rgammon@real.com> 
- First RPM build, derived from the HelixPlayer .spec file.
