/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: unixcmap.c,v 1.1.1.1.42.2 2004/07/09 12:48:45 pankajgupta Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#include "hxtypes.h"
#include "hxcom.h"
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include "unixcmap.h"

#define MAX_COLORS 256

XColor gHXCurrentColors[MAX_COLORS];
Colormap gHXColormap = 0;

Colormap HXGetXColormap(Display* pDisplay, Window window)
{
    XWindowAttributes attr;

    XLockDisplay(pDisplay);
    XGetWindowAttributes(pDisplay, window, &attr);
    XUnlockDisplay(pDisplay);

    return attr.colormap;
}

static void HXInitXColormap(Display* pDisplay, Colormap cmap)
{
    int i;
    for (i=0; i<MAX_COLORS; i++)
    {
	gHXCurrentColors[i].pixel = i;
    }
    gHXColormap = cmap;
    if (pDisplay && cmap)
    {
	XLockDisplay(pDisplay);
	XQueryColors(pDisplay, cmap,
	    gHXCurrentColors,
	    MAX_COLORS);
	XUnlockDisplay(pDisplay);
    }
}

static int Distance(XColor c1, XColor c2)
{
    return abs(c1.red - c2.red) + 
	   abs(c1.green - c2.green) + 
	   abs(c1.blue - c2.blue);
}

void HXFindBestXColor(Display* pDisplay, Colormap cmap, XColor* desired)
{
    BOOL foundMatch = FALSE;

    XColor bestMatch = gHXCurrentColors[0];
    unsigned int i, distance = ~0;


    if (desired)
    {
	if (XAllocColor(pDisplay, cmap, desired))
	{
	    return;
	} else if (cmap == gHXColormap) {
	    for (i=0; i<MAX_COLORS; i++)
	    {
		if (Distance(*desired, gHXCurrentColors[i]) < distance)
		{
		    bestMatch = gHXCurrentColors[i];
		    distance = Distance(*desired, gHXCurrentColors[i]);
		    foundMatch = TRUE;
		}
	    }
	}
    }

    if (foundMatch)
    {
	*desired = bestMatch;
    } else {
	HXInitXColormap(pDisplay, cmap);
	HXFindBestXColor(pDisplay, cmap, desired);
    }
}

