/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: baseroot.h,v 1.1.1.1.42.1 2004/07/09 01:58:56 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#include "coloracc.h"
#include "hxvsurf.h"
#include "hxengin.h"
#include "hxslist.h"

#ifndef _BASEROOT_H_
#define _BASEROOT_H_

// Forward declarations
class CBaseRootSurface;
class CHXBaseSite;

#define HX_WINDOWLESS_DEBUG       0
#define HX_WINDOWLESS_MINIMAL     1
#define HX_WINDOWLESS_COMPOSITION 2

#define TEXTOVERLAY "TextOverlay"

// You would think that Video and System would be exclusive. 
// Not so. There is a default which allows the system to decide.
#define HX_ACCELERATION_ON     1
#define HX_USE_VIDEO_MEMORY    2
#define HX_USE_SYSTEM_MEMORY   4

struct CModesDesc
{
   UINT32 m_nWidth;
   UINT32 m_nHeight;
   UINT32 m_nBitCount;
   UINT32 m_fourCC;
};

class CBaseRootSurface : public IUnknown
{
public:
    virtual ~CBaseRootSurface();
    CBaseRootSurface(IUnknown* pContext, CHXBaseSite* pSite);


    static CBaseRootSurface* Create(IUnknown* pContext, CHXBaseSite* pSite);

    //IUnknown methods
    STDMETHOD(QueryInterface) (THIS_ REFIID riid, void** ppvObj);
    STDMETHOD_(ULONG32,AddRef) (THIS);
    STDMETHOD_(ULONG32,Release) (THIS);

    //BLTing methods.
    STDMETHOD(Blt) (THIS_ UCHAR*                pImageData,
                          HXBitmapInfoHeader*   pBitmapInfo,
                          REF(HXxRect)          rDestRect,
                          REF(HXxRect)          rSrcRect,
                          CHXBaseSite*          pSite);

    STDMETHOD(BeginOptimizedBlt)(THIS_ HXBitmapInfoHeader* pBitmapInfo);
    STDMETHOD(OptimizedBlt) (THIS_ UCHAR* pImageBits,
                                   REF(HXxRect) rDestRect,
                                   REF(HXxRect) rSrcRect);
    STDMETHOD(EndOptimizedBlt) (THIS);
    STDMETHOD(GetOptimizedFormat)(THIS_ REF(HX_COMPRESSION_TYPE) ulType);
    STDMETHOD(GetPreferredFormat)(THIS_ REF(HX_COMPRESSION_TYPE) ulType);

    void BltComposition();

    void         DestroySurfaces();
    void         ReInitSurfaces();
    void         FillBorders();
    virtual void SetResolution(int x, int y, int depth, void* pWindow);
    void         SetBltLock(BOOL bSet);
    virtual void GetDisplayModes(CModesDesc* pModesDesc, INT32* nNumModes);
    HX_RESULT    Lock(UINT32 nID);
    HX_RESULT    Unlock(UINT32 nID, HXxWindow* pWindow, CHXBaseSite* pSite=NULL);
    BOOL         IsCompositionEnabled();
    virtual void ModifyBoundsRect(HXxRect* pRect);
    HX_RESULT    MinimalLock();
    HX_RESULT    MinimalUnlock(HXxWindow* pWindow);
    HX_RESULT    SizeChanged();
    virtual void _PreFlightBlt(HXxRect& dst) {}
    virtual BOOL _OptimizedSurfaceOpened();
    virtual UINT32	_GetNumberOfMonitors() { return 1; }
    virtual BOOL		_RectOnNthMonitor(HXxRect rect, UINT32 uMonitor, HXxRect& intersectRect);
    virtual BOOL _IsHardwareAccelerationAvail();
    virtual BOOL _AcquireHardwareAcceleration();
    virtual BOOL _LoseHardwareAcceleration();
    virtual BOOL _EnableHardwareAcceleration();
    virtual BOOL _DisableHardwareAcceleration();

    virtual void DrawFocusRect(int nSurfaceCID,
                              HXxSize *pSurfaceSize,
                              UCHAR *pVidMem,
                              CHXBaseSite* pSite);

#ifdef _WINDOWS
    IHXPlayer*  GetPlayer();
#endif

    void         LockCompMutex(); 
    void         UnlockCompMutex();

    ColorFuncAccess* GetColorAccess() {return zm_pColorAcc;}
   
protected:
    HXMutex*    m_pMutex;
    HXMutex*    m_pCompMutex;
    CHXSimpleList m_pBltRects;
    LONG32       m_lRefCount;
    IUnknown*    m_pContext;
    CHXBaseSite* m_pSite;    
    UINT32       m_fSurfaceType;
    INT32        m_nBLTMode;
    INT32        m_nCompositionSurfaceCID;
    HXxSize      m_allocatedScratchSize;
    UCHAR*       m_pCompositionSurface;
    HXxSize      m_allocatedCompositionSize;
    INT32        m_nCompositionPitch;
    HXxRect      m_boundsRect;
    HXxSize      m_compositionSize;
    BOOL         m_bCompositionSurfaceCreated;
#ifdef _WIN32
    BITMAPINFO   m_bmiComposition;
#else
    HXBitmapInfo m_bmiComposition;
#endif   
#ifdef _WINDOWS
    IHXPlayer*  m_pPlayer;
#endif
   
    BOOL         m_bUseCardMemory;
    CHXBaseSite* m_pUnlockingSite;

    ColorFuncAccess* zm_pColorAcc;
    
    HX_RESULT DebugBlt( UCHAR*                pImageData,
                        HXBitmapInfoHeader*  pBitmapInfo,
                        REF(HXxRect)          rDestRect,
                        REF(HXxRect)          rSrcRect);
    HX_RESULT MinimalBlt( UCHAR* pImageData, HXBitmapInfoHeader* pBitmapInfo,
                          REF(HXxRect) rDestRect, REF(HXxRect) rSrcRect, CHXBaseSite* pSite);

    // Pure virtuals....
   
    /************************************************************************
     *  Method:
     *      _BltFromScratchToComposition
     *  Purpose:
     *      Transfer data from the scratch surface to the composition surface.
     *      This may not be applicable on some platforms.
     */
    virtual void _BltFromScratchToComposition(HXxRect& rDestRect, HXxRect& rSrcRect)=0;
    
    /************************************************************************
     *  Method:
     *      _DebugBlt
     *  Purpose:
     *      Draw pImageData on the root surface's site.
     */
    virtual HX_RESULT _DebugBlt( UCHAR*                 pImageData,
                                 HXBitmapInfoHeader*    pBitmapInfo,
                                 REF(HXxRect)           rDestRect,
                                 REF(HXxRect)           rSrcRect) = 0;

    /************************************************************************
     *  Method:
     *      _GetYUVScratchWidthHeight
     *  Purpose:
     *      Query the dimensions of the scratch surface
     */
    virtual void _GetYUVScratchWidthHeight(UINT32* pWidth, UINT32* pHeight) = 0;

    /************************************************************************
     *  Method:
     *      _CreateYUVScratchSurface
     *  Purpose:
     *      Create an offscreen yuv surface.  This is used when we need to
     *      perform a 2 stage color converter (source->scratch->dest).
     */
    virtual void _CreateYUVScratchSurface(UINT32 width, UINT32 height) = 0;

    /************************************************************************
     *  Method:
     *      _GetYUVScratchSurfacePointer
     *  Purpose:
     *      Get a writable pointer and the pitch of the scratch buffer.
     */
    virtual void _GetYUVScratchSurfacePointer(UCHAR** pYUVBits, INT32* YUVPitch) = 0;

    /************************************************************************
     *  Method:
     *      CreateScratchSurface
     *  Purpose:
     *      Create an offscreen RGB surface to a 2 stage color convert
     *      when going from YUV->RGB.
     */
    virtual HX_RESULT CreateScratchSurface( int nCompositionSurfaceCID,
                                            HXxSize* pSize) = 0;
    /************************************************************************
     *  Method:
     *      ScratchLock
     *  Purpose:
     *      Get a writable pointer and the pitch of the scratch buffer.
     */
    virtual HX_RESULT ScratchLock(UCHAR** pBits, INT32* pPitch) = 0;

    /************************************************************************
     *  Method:
     *      ScratchUnlock
     *  Purpose:
     *      Finished writing to the scratch buffer.
     */
    virtual HX_RESULT ScratchUnlock(UCHAR* pBits) = 0;

    /************************************************************************
     *  Method:
     *      _MinimalUnlock
     *  Purpose:
     *      Unlocks the composition surface for writing
     */
    virtual HX_RESULT _MinimalUnlock(HXxWindow* pWindow) = 0;

    /************************************************************************
     *  Method:
     *      _LockComposition
     *  Purpose:
     *      Locks the composition surface for writing
     */
    virtual HX_RESULT _LockComposition(UCHAR** pBits, INT32* pPitch)=0;

    /************************************************************************
     *  Method:
     *      _CreateCompositionSurface
     *  Purpose:
     *      Create an offscreen video surface matching the size and format
     *      of the top level site.
     */
    virtual HX_RESULT _CreateCompositionSurface() = 0;

    /************************************************************************
     *  Method:
     *      _DestroyCompositionSurface
     *  Purpose:
     *      Destroy the composition surface
     */
    virtual HX_RESULT _DestroyCompositionSurface() = 0;

    virtual void _MinimalBlt(HXxRect& src, HXxRect& dest);
    virtual void _FillBorders() {};
    virtual void CreateColorAccess(IUnknown* pUnk) {zm_pColorAcc = new ColorFuncAccess(pUnk);}
   
private:

};

#endif  /* _BASEROOT_H_ */
