#include "statname.h"

extern const float coef32[31];
extern const float look_global[256+2+4];
extern const float look_scale[2][4][32];
extern const float look_pow[64];
extern const float look_subblock[8];
extern const float lr[2][8][2];
extern const float lr2[2][2][64][2];

/* 
pi = 4.0*atan(1.0);
n = 16;
k = 0;
for(i=0; i<5; i++, n=n/2) {
	for(p=0; p<n; p++, k++) {
		t = (pi/(4*n))*(2*p+1);
		coef32[k] = (float)(0.50/cos(t));
	}
}
*/
const float coef32[31] = {
	 5.0060302019e-001f,  5.0547093153e-001f,  5.1544731855e-001f,  5.3104257584e-001f, 
	 5.5310392380e-001f,  5.8293497562e-001f,  6.2250411510e-001f,  6.7480832338e-001f, 
	 7.4453628063e-001f,  8.3934962749e-001f,  9.7256821394e-001f,  1.1694399118e+000f, 
	 1.4841645956e+000f,  2.0577809811e+000f,  3.4076085091e+000f,  1.0190008163e+001f, 
	 5.0241929293e-001f,  5.2249860764e-001f,  5.6694406271e-001f,  6.4682179689e-001f, 
	 7.8815460205e-001f,  1.0606776476e+000f,  1.7224471569e+000f,  5.1011486053e+000f, 
	 5.0979560614e-001f,  6.0134488344e-001f,  8.9997619390e-001f,  2.5629155636e+000f, 
	 5.4119610786e-001f,  1.3065630198e+000f,  7.0710676908e-001f, 
};

/* 8 bit plus 2 lookup x = pow(2.0, 0.25*(global_gain-210))
 * extra 2 for ms scaling by 1/sqrt(2)
 * extra 4 for cvt to mono scaling by 1/2
 *
 *
 for(i=0;i<256+2+4;i++) 
	x[i] = (float)pow(2.0, 0.25*((i-(2+4)) - 210 + GLOBAL_GAIN_SCALE));

*/
const float look_global[256+2+4] = {
	 1.8189894035e-012f,  2.1631550717e-012f,  2.5724394403e-012f,  3.0591633827e-012f, 
	 3.6379788071e-012f,  4.3263101435e-012f,  5.1448788806e-012f,  6.1183267654e-012f, 
	 7.2759576142e-012f,  8.6526202869e-012f,  1.0289757761e-011f,  1.2236653531e-011f, 
	 1.4551915228e-011f,  1.7305240574e-011f,  2.0579515522e-011f,  2.4473307061e-011f, 
	 2.9103830457e-011f,  3.4610481148e-011f,  4.1159031045e-011f,  4.8946614123e-011f, 
	 5.8207660913e-011f,  6.9220962295e-011f,  8.2318062089e-011f,  9.7893228246e-011f, 
	 1.1641532183e-010f,  1.3844192459e-010f,  1.6463612418e-010f,  1.9578645649e-010f, 
	 2.3283064365e-010f,  2.7688384918e-010f,  3.2927224836e-010f,  3.9157291298e-010f, 
	 4.6566128731e-010f,  5.5376769836e-010f,  6.5854449671e-010f,  7.8314582597e-010f, 
	 9.3132257462e-010f,  1.1075353967e-009f,  1.3170889934e-009f,  1.5662916519e-009f, 
	 1.8626451492e-009f,  2.2150707935e-009f,  2.6341779868e-009f,  3.1325833039e-009f, 
	 3.7252902985e-009f,  4.4301415869e-009f,  5.2683559737e-009f,  6.2651666077e-009f, 
	 7.4505805969e-009f,  8.8602831738e-009f,  1.0536711947e-008f,  1.2530333215e-008f, 
	 1.4901161194e-008f,  1.7720566348e-008f,  2.1073423895e-008f,  2.5060666431e-008f, 
	 2.9802322388e-008f,  3.5441132695e-008f,  4.2146847790e-008f,  5.0121332862e-008f, 
	 5.9604644775e-008f,  7.0882265391e-008f,  8.4293695579e-008f,  1.0024266572e-007f, 
	 1.1920928955e-007f,  1.4176453078e-007f,  1.6858739116e-007f,  2.0048533145e-007f, 
	 2.3841857910e-007f,  2.8352906156e-007f,  3.3717478232e-007f,  4.0097066289e-007f, 
	 4.7683715820e-007f,  5.6705812312e-007f,  6.7434956463e-007f,  8.0194132579e-007f, 
	 9.5367431641e-007f,  1.1341162462e-006f,  1.3486991293e-006f,  1.6038826516e-006f, 
	 1.9073486328e-006f,  2.2682324925e-006f,  2.6973982585e-006f,  3.2077653032e-006f, 
	 3.8146972656e-006f,  4.5364649850e-006f,  5.3947965171e-006f,  6.4155306063e-006f, 
	 7.6293945313e-006f,  9.0729299700e-006f,  1.0789593034e-005f,  1.2831061213e-005f, 
	 1.5258789063e-005f,  1.8145859940e-005f,  2.1579186068e-005f,  2.5662122425e-005f, 
	 3.0517578125e-005f,  3.6291719880e-005f,  4.3158372137e-005f,  5.1324244851e-005f, 
	 6.1035156250e-005f,  7.2583439760e-005f,  8.6316744273e-005f,  1.0264848970e-004f, 
	 1.2207031250e-004f,  1.4516687952e-004f,  1.7263348855e-004f,  2.0529697940e-004f, 
	 2.4414062500e-004f,  2.9033375904e-004f,  3.4526697709e-004f,  4.1059395880e-004f, 
	 4.8828125000e-004f,  5.8066751808e-004f,  6.9053395418e-004f,  8.2118791761e-004f, 
	 9.7656250000e-004f,  1.1613350362e-003f,  1.3810679084e-003f,  1.6423758352e-003f, 
	 1.9531250000e-003f,  2.3226700723e-003f,  2.7621358167e-003f,  3.2847516704e-003f, 
	 3.9062500000e-003f,  4.6453401446e-003f,  5.5242716335e-003f,  6.5695033409e-003f, 
	 7.8125000000e-003f,  9.2906802893e-003f,  1.1048543267e-002f,  1.3139006682e-002f, 
	 1.5625000000e-002f,  1.8581360579e-002f,  2.2097086534e-002f,  2.6278013363e-002f, 
	 3.1250000000e-002f,  3.7162721157e-002f,  4.4194173068e-002f,  5.2556026727e-002f, 
	 6.2500000000e-002f,  7.4325442314e-002f,  8.8388346136e-002f,  1.0511205345e-001f, 
	 1.2500000000e-001f,  1.4865088463e-001f,  1.7677669227e-001f,  2.1022410691e-001f, 
	 2.5000000000e-001f,  2.9730176926e-001f,  3.5355338454e-001f,  4.2044821382e-001f, 
	 5.0000000000e-001f,  5.9460353851e-001f,  7.0710676908e-001f,  8.4089642763e-001f, 
	 1.0000000000e+000f,  1.1892070770e+000f,  1.4142135382e+000f,  1.6817928553e+000f, 
	 2.0000000000e+000f,  2.3784141541e+000f,  2.8284270763e+000f,  3.3635857105e+000f, 
	 4.0000000000e+000f,  4.7568283081e+000f,  5.6568541527e+000f,  6.7271714211e+000f, 
	 8.0000000000e+000f,  9.5136566162e+000f,  1.1313708305e+001f,  1.3454342842e+001f, 
	 1.6000000000e+001f,  1.9027313232e+001f,  2.2627416611e+001f,  2.6908685684e+001f, 
	 3.2000000000e+001f,  3.8054626465e+001f,  4.5254833221e+001f,  5.3817371368e+001f, 
	 6.4000000000e+001f,  7.6109252930e+001f,  9.0509666443e+001f,  1.0763474274e+002f, 
	 1.2800000000e+002f,  1.5221850586e+002f,  1.8101933289e+002f,  2.1526948547e+002f, 
	 2.5600000000e+002f,  3.0443701172e+002f,  3.6203866577e+002f,  4.3053897095e+002f, 
	 5.1200000000e+002f,  6.0887402344e+002f,  7.2407733154e+002f,  8.6107794189e+002f, 
	 1.0240000000e+003f,  1.2177480469e+003f,  1.4481546631e+003f,  1.7221558838e+003f, 
	 2.0480000000e+003f,  2.4354960938e+003f,  2.8963093262e+003f,  3.4443117676e+003f, 
	 4.0960000000e+003f,  4.8709921875e+003f,  5.7926186523e+003f,  6.8886235352e+003f, 
	 8.1920000000e+003f,  9.7419843750e+003f,  1.1585237305e+004f,  1.3777247070e+004f, 
	 1.6384000000e+004f,  1.9483968750e+004f,  2.3170474609e+004f,  2.7554494141e+004f, 
	 3.2768000000e+004f,  3.8967937500e+004f,  4.6340949219e+004f,  5.5108988281e+004f, 
	 6.5536000000e+004f,  7.7935875000e+004f,  9.2681898438e+004f,  1.1021797656e+005f, 
	 1.3107200000e+005f,  1.5587175000e+005f,  1.8536379688e+005f,  2.2043595313e+005f, 
	 2.6214400000e+005f,  3.1174350000e+005f,  3.7072759375e+005f,  4.4087190625e+005f, 
	 5.2428800000e+005f,  6.2348700000e+005f,  7.4145518750e+005f,  8.8174381250e+005f, 
	 1.0485760000e+006f,  1.2469740000e+006f,  1.4829103750e+006f,  1.7634876250e+006f, 
	 2.0971520000e+006f,  2.4939480000e+006f,  2.9658207500e+006f,  3.5269752500e+006f, 
	 4.1943040000e+006f,  4.9878960000e+006f,  5.9316415000e+006f,  7.0539505000e+006f, 
	 8.3886080000e+006f,  9.9757920000e+006f,  1.1863283000e+007f,  1.4107901000e+007f, 
	 1.6777216000e+007f,  1.9951584000e+007f,  2.3726566000e+007f,  2.8215802000e+007f, 
	 3.3554432000e+007f,  3.9903168000e+007f,  4.7453132000e+007f,  5.6431604000e+007f, 
	 6.7108864000e+007f,  7.9806336000e+007f, 
};

/*
for(scalefact_scale=0; scalefact_scale<2; scalefact_scale++) {
	for(preemp=0; preemp<4;  preemp++) {
		for(scalefac=0; scalefac<32; scalefac++) {
			ls[scalefact_scale][preemp][scalefac] = (float)pow(2.0, -0.5*(1+scalefact_scale)*(scalefac + preemp));
		}
	}
}
*/
const float look_scale[2][4][32] = {
	{
	{
		1.0000000000e+000f,  7.0710676908e-001f,  5.0000000000e-001f,  3.5355338454e-001f, 
		2.5000000000e-001f,  1.7677669227e-001f,  1.2500000000e-001f,  8.8388346136e-002f, 
		6.2500000000e-002f,  4.4194173068e-002f,  3.1250000000e-002f,  2.2097086534e-002f, 
		1.5625000000e-002f,  1.1048543267e-002f,  7.8125000000e-003f,  5.5242716335e-003f, 
		3.9062500000e-003f,  2.7621358167e-003f,  1.9531250000e-003f,  1.3810679084e-003f, 
		9.7656250000e-004f,  6.9053395418e-004f,  4.8828125000e-004f,  3.4526697709e-004f, 
		2.4414062500e-004f,  1.7263348855e-004f,  1.2207031250e-004f,  8.6316744273e-005f, 
		6.1035156250e-005f,  4.3158372137e-005f,  3.0517578125e-005f,  2.1579186068e-005f, 
	},
	{
		7.0710676908e-001f,  5.0000000000e-001f,  3.5355338454e-001f,  2.5000000000e-001f, 
		1.7677669227e-001f,  1.2500000000e-001f,  8.8388346136e-002f,  6.2500000000e-002f, 
		4.4194173068e-002f,  3.1250000000e-002f,  2.2097086534e-002f,  1.5625000000e-002f, 
		1.1048543267e-002f,  7.8125000000e-003f,  5.5242716335e-003f,  3.9062500000e-003f, 
		2.7621358167e-003f,  1.9531250000e-003f,  1.3810679084e-003f,  9.7656250000e-004f, 
		6.9053395418e-004f,  4.8828125000e-004f,  3.4526697709e-004f,  2.4414062500e-004f, 
		1.7263348855e-004f,  1.2207031250e-004f,  8.6316744273e-005f,  6.1035156250e-005f, 
		4.3158372137e-005f,  3.0517578125e-005f,  2.1579186068e-005f,  1.5258789063e-005f, 
	},
	{
		5.0000000000e-001f,  3.5355338454e-001f,  2.5000000000e-001f,  1.7677669227e-001f, 
		1.2500000000e-001f,  8.8388346136e-002f,  6.2500000000e-002f,  4.4194173068e-002f, 
		3.1250000000e-002f,  2.2097086534e-002f,  1.5625000000e-002f,  1.1048543267e-002f, 
		7.8125000000e-003f,  5.5242716335e-003f,  3.9062500000e-003f,  2.7621358167e-003f, 
		1.9531250000e-003f,  1.3810679084e-003f,  9.7656250000e-004f,  6.9053395418e-004f, 
		4.8828125000e-004f,  3.4526697709e-004f,  2.4414062500e-004f,  1.7263348855e-004f, 
		1.2207031250e-004f,  8.6316744273e-005f,  6.1035156250e-005f,  4.3158372137e-005f, 
		3.0517578125e-005f,  2.1579186068e-005f,  1.5258789063e-005f,  1.0789593034e-005f, 
	},
	{
		3.5355338454e-001f,  2.5000000000e-001f,  1.7677669227e-001f,  1.2500000000e-001f, 
		8.8388346136e-002f,  6.2500000000e-002f,  4.4194173068e-002f,  3.1250000000e-002f, 
		2.2097086534e-002f,  1.5625000000e-002f,  1.1048543267e-002f,  7.8125000000e-003f, 
		5.5242716335e-003f,  3.9062500000e-003f,  2.7621358167e-003f,  1.9531250000e-003f, 
		1.3810679084e-003f,  9.7656250000e-004f,  6.9053395418e-004f,  4.8828125000e-004f, 
		3.4526697709e-004f,  2.4414062500e-004f,  1.7263348855e-004f,  1.2207031250e-004f, 
		8.6316744273e-005f,  6.1035156250e-005f,  4.3158372137e-005f,  3.0517578125e-005f, 
		2.1579186068e-005f,  1.5258789063e-005f,  1.0789593034e-005f,  7.6293945313e-006f, 
	}
	},

	{
	{
		1.0000000000e+000f,  5.0000000000e-001f,  2.5000000000e-001f,  1.2500000000e-001f, 
		6.2500000000e-002f,  3.1250000000e-002f,  1.5625000000e-002f,  7.8125000000e-003f, 
		3.9062500000e-003f,  1.9531250000e-003f,  9.7656250000e-004f,  4.8828125000e-004f, 
		2.4414062500e-004f,  1.2207031250e-004f,  6.1035156250e-005f,  3.0517578125e-005f, 
		1.5258789063e-005f,  7.6293945313e-006f,  3.8146972656e-006f,  1.9073486328e-006f, 
		9.5367431641e-007f,  4.7683715820e-007f,  2.3841857910e-007f,  1.1920928955e-007f, 
		5.9604644775e-008f,  2.9802322388e-008f,  1.4901161194e-008f,  7.4505805969e-009f, 
		3.7252902985e-009f,  1.8626451492e-009f,  9.3132257462e-010f,  4.6566128731e-010f, 
	},
	{
		5.0000000000e-001f,  2.5000000000e-001f,  1.2500000000e-001f,  6.2500000000e-002f, 
		3.1250000000e-002f,  1.5625000000e-002f,  7.8125000000e-003f,  3.9062500000e-003f, 
		1.9531250000e-003f,  9.7656250000e-004f,  4.8828125000e-004f,  2.4414062500e-004f, 
		1.2207031250e-004f,  6.1035156250e-005f,  3.0517578125e-005f,  1.5258789063e-005f, 
		7.6293945313e-006f,  3.8146972656e-006f,  1.9073486328e-006f,  9.5367431641e-007f, 
		4.7683715820e-007f,  2.3841857910e-007f,  1.1920928955e-007f,  5.9604644775e-008f, 
		2.9802322388e-008f,  1.4901161194e-008f,  7.4505805969e-009f,  3.7252902985e-009f, 
		1.8626451492e-009f,  9.3132257462e-010f,  4.6566128731e-010f,  2.3283064365e-010f, 
	},
	{
		2.5000000000e-001f,  1.2500000000e-001f,  6.2500000000e-002f,  3.1250000000e-002f, 
		1.5625000000e-002f,  7.8125000000e-003f,  3.9062500000e-003f,  1.9531250000e-003f, 
		9.7656250000e-004f,  4.8828125000e-004f,  2.4414062500e-004f,  1.2207031250e-004f, 
		6.1035156250e-005f,  3.0517578125e-005f,  1.5258789063e-005f,  7.6293945313e-006f, 
		3.8146972656e-006f,  1.9073486328e-006f,  9.5367431641e-007f,  4.7683715820e-007f, 
		2.3841857910e-007f,  1.1920928955e-007f,  5.9604644775e-008f,  2.9802322388e-008f, 
		1.4901161194e-008f,  7.4505805969e-009f,  3.7252902985e-009f,  1.8626451492e-009f, 
		9.3132257462e-010f,  4.6566128731e-010f,  2.3283064365e-010f,  1.1641532183e-010f, 
	},
	{
		1.2500000000e-001f,  6.2500000000e-002f,  3.1250000000e-002f,  1.5625000000e-002f, 
		7.8125000000e-003f,  3.9062500000e-003f,  1.9531250000e-003f,  9.7656250000e-004f, 
		4.8828125000e-004f,  2.4414062500e-004f,  1.2207031250e-004f,  6.1035156250e-005f, 
		3.0517578125e-005f,  1.5258789063e-005f,  7.6293945313e-006f,  3.8146972656e-006f, 
		1.9073486328e-006f,  9.5367431641e-007f,  4.7683715820e-007f,  2.3841857910e-007f, 
		1.1920928955e-007f,  5.9604644775e-008f,  2.9802322388e-008f,  1.4901161194e-008f, 
		7.4505805969e-009f,  3.7252902985e-009f,  1.8626451492e-009f,  9.3132257462e-010f, 
		4.6566128731e-010f,  2.3283064365e-010f,  1.1641532183e-010f,  5.8207660913e-011f, 
	}
	}
};

/* --- iSample**(4/3) lookup, -32<=i<=31 ---

for(i=0;i<64;i++) {
    tmp = i-32;
    x[i] = (float)( tmp*pow(fabs(tmp), (1.0/3.0)) );
}
*/
const float look_pow[64] = {
	-1.0159366608e+002f, -9.7382797241e+001f, -9.3216972351e+001f, -8.9097190857e+001f, 
	-8.5024490356e+001f, -8.1000000000e+001f, -7.7024894714e+001f, -7.3100440979e+001f, 
	-6.9227981567e+001f, -6.5408943176e+001f, -6.1644866943e+001f, -5.7937408447e+001f, 
	-5.4288352966e+001f, -5.0699630737e+001f, -4.7173343658e+001f, -4.3711788177e+001f, 
	-4.0317474365e+001f, -3.6993179321e+001f, -3.3741992950e+001f, -3.0567350388e+001f, 
	-2.7473142624e+001f, -2.4463781357e+001f, -2.1544347763e+001f, -1.8720754623e+001f, 
	-1.6000000000e+001f, -1.3390518188e+001f, -1.0902723312e+001f, -8.5498800278e+000f, 
	-6.3496041298e+000f, -4.3267488480e+000f, -2.5198421478e+000f, -1.0000000000e+000f, 
	 0.0000000000e+000f,  1.0000000000e+000f,  2.5198421478e+000f,  4.3267488480e+000f, 
	 6.3496041298e+000f,  8.5498800278e+000f,  1.0902723312e+001f,  1.3390518188e+001f, 
	 1.6000000000e+001f,  1.8720754623e+001f,  2.1544347763e+001f,  2.4463781357e+001f, 
	 2.7473142624e+001f,  3.0567350388e+001f,  3.3741992950e+001f,  3.6993179321e+001f, 
	 4.0317474365e+001f,  4.3711788177e+001f,  4.7173343658e+001f,  5.0699630737e+001f, 
	 5.4288352966e+001f,  5.7937408447e+001f,  6.1644866943e+001f,  6.5408943176e+001f, 
	 6.9227981567e+001f,  7.3100440979e+001f,  7.7024894714e+001f,  8.1000000000e+001f, 
	 8.5024490356e+001f,  8.9097190857e+001f,  9.3216972351e+001f,  9.7382797241e+001f, 
};

/* -- pow(2.0, -0.25*8.0*subblock_gain)  3 bits --

for(i=0;i<8;i++) {
	x[i] = (float)pow(2.0, 0.25 * -8.0 * i );
}
*/
const float look_subblock[8] = {
	 1.0000000000e+000f,  2.5000000000e-001f,  6.2500000000e-002f,  1.5625000000e-002f, 
	 3.9062500000e-003f,  9.7656250000e-004f,  2.4414062500e-004f,  6.1035156250e-005f, 
};

/* intensity stereo 
 * if ms mode quant pre-scales all values by 1.0/sqrt(2.0)
   ms_mode in table compensates 

pi = 4.0*atan(1.0);
t = pi/12.0;
for(i=0;i<7;i++) {
    s = sin(i*t);
    c = cos(i*t);
    ** ms_mode = 0 **
    lr[0][i][0] = (float)(s/(s+c));
    lr[0][i][1] = (float)(c/(s+c));
    ** ms_mode = 1 **
    lr[1][i][0] = (float)(sqrt(2.0)*(s/(s+c)));
    lr[1][i][1] = (float)(sqrt(2.0)*(c/(s+c)));
}
** sf = 7 **
** ms_mode = 0 **
lr[0][i][0] = 1.0f;
lr[0][i][1] = 0.0f;
** ms_mode = 1, in is bands is routine does ms processing **
lr[1][i][0] = 1.0f;
lr[1][i][1] = 1.0f;
*/

const float lr[2][8][2] = {	/* [ms_mode 0/1][sf][left/right]  */
	{
		{0.0000000000e+000f,  1.0000000000e+000f},  {2.1132487059e-001f,  7.8867512941e-001f}, 
		{3.6602541804e-001f,  6.3397461176e-001f},  {5.0000000000e-001f,  5.0000000000e-001f}, 
		{6.3397461176e-001f,  3.6602541804e-001f},  {7.8867512941e-001f,  2.1132487059e-001f}, 
		{1.0000000000e+000f,  6.1230317691e-017f},  {1.0000000000e+000f,  0.0000000000e+000f}, 
	},
	{
		{0.0000000000e+000f,  1.4142135382e+000f},  {2.9885849357e-001f,  1.1153550148e+000f}, 
		{5.1763808727e-001f,  8.9657545090e-001f},  {7.0710676908e-001f,  7.0710676908e-001f}, 
		{8.9657545090e-001f,  5.1763808727e-001f},  {1.1153550148e+000f,  2.9885849357e-001f}, 
		{1.4142135382e+000f,  8.6592747298e-017f},  {1.0000000000e+000f,  1.0000000000e+000f}, 
	}
};


/* intensity stereo MPEG2 */
/* lr2[intensity_scale][ms_mode][sflen_offset+sf][left/right] */

/* intensity stereo MPEG2 
  lr2[intensity_scale][ms_mode][sflen_offset+sf][left/right] 

for(intensity_scale=0;intensity_scale<2;intensity_scale++) {
	t = pow(2.0, -0.25*(1+intensity_scale));
	for(ms_mode=0;ms_mode<2;ms_mode++) {
		n = 1;
		k = 0;
		for(sflen=0;sflen<6;sflen++) {
			for(sf=0;sf<(n-1);sf++, k++) {
				if( sf == 0 ) {
					lr[intensity_scale][ms_mode][k][0] = ms_factor[ms_mode]*1.0f;
					lr[intensity_scale][ms_mode][k][1] = ms_factor[ms_mode]*1.0f;
				}
				else if( (sf & 1) ) {
					lr[intensity_scale][ms_mode][k][0] = 
						(float)(ms_factor[ms_mode]*pow(t,(sf+1)/2));
					lr[intensity_scale][ms_mode][k][1] = ms_factor[ms_mode]*1.0f;
				}
				else {
					lr[intensity_scale][ms_mode][k][0] = ms_factor[ms_mode]*1.0f;
					lr[intensity_scale][ms_mode][k][1] = 
						(float)(ms_factor[ms_mode]*pow(t,sf/2));
				}
			}
			
			** illegal is_pos used to do ms processing **
			if( ms_mode == 0 ) {** ms_mode = 0 **
				lr[intensity_scale][ms_mode][k][0] = 1.0f;
				lr[intensity_scale][ms_mode][k][1] = 0.0f;
			}
			else {
				** ms_mode = 1, in is bands is routine does ms processing **
				lr[intensity_scale][ms_mode][k][0] = 1.0f;
				lr[intensity_scale][ms_mode][k][1] = 1.0f;
			}
			k++;
			n = n + n;
		}
	}
}
*/

const float lr2[2][2][64][2] = {
	{
		{
		{1.0000000000e+000f,  0.0000000000e+000f},  {1.0000000000e+000f,  1.0000000000e+000f}, 
		{1.0000000000e+000f,  0.0000000000e+000f},  {1.0000000000e+000f,  1.0000000000e+000f}, 
		{8.4089642763e-001f,  1.0000000000e+000f},  {1.0000000000e+000f,  8.4089642763e-001f}, 
		{1.0000000000e+000f,  0.0000000000e+000f},  {1.0000000000e+000f,  1.0000000000e+000f}, 
		{8.4089642763e-001f,  1.0000000000e+000f},  {1.0000000000e+000f,  8.4089642763e-001f}, 
		{7.0710676908e-001f,  1.0000000000e+000f},  {1.0000000000e+000f,  7.0710676908e-001f}, 
		{5.9460353851e-001f,  1.0000000000e+000f},  {1.0000000000e+000f,  5.9460353851e-001f}, 
		{1.0000000000e+000f,  0.0000000000e+000f},  {1.0000000000e+000f,  1.0000000000e+000f}, 
		{8.4089642763e-001f,  1.0000000000e+000f},  {1.0000000000e+000f,  8.4089642763e-001f}, 
		{7.0710676908e-001f,  1.0000000000e+000f},  {1.0000000000e+000f,  7.0710676908e-001f}, 
		{5.9460353851e-001f,  1.0000000000e+000f},  {1.0000000000e+000f,  5.9460353851e-001f}, 
		{5.0000000000e-001f,  1.0000000000e+000f},  {1.0000000000e+000f,  5.0000000000e-001f}, 
		{4.2044821382e-001f,  1.0000000000e+000f},  {1.0000000000e+000f,  4.2044821382e-001f}, 
		{3.5355338454e-001f,  1.0000000000e+000f},  {1.0000000000e+000f,  3.5355338454e-001f}, 
		{2.9730176926e-001f,  1.0000000000e+000f},  {1.0000000000e+000f,  2.9730176926e-001f}, 
		{1.0000000000e+000f,  0.0000000000e+000f},  {1.0000000000e+000f,  1.0000000000e+000f}, 
		{8.4089642763e-001f,  1.0000000000e+000f},  {1.0000000000e+000f,  8.4089642763e-001f}, 
		{7.0710676908e-001f,  1.0000000000e+000f},  {1.0000000000e+000f,  7.0710676908e-001f}, 
		{5.9460353851e-001f,  1.0000000000e+000f},  {1.0000000000e+000f,  5.9460353851e-001f}, 
		{5.0000000000e-001f,  1.0000000000e+000f},  {1.0000000000e+000f,  5.0000000000e-001f}, 
		{4.2044821382e-001f,  1.0000000000e+000f},  {1.0000000000e+000f,  4.2044821382e-001f}, 
		{3.5355338454e-001f,  1.0000000000e+000f},  {1.0000000000e+000f,  3.5355338454e-001f}, 
		{2.9730176926e-001f,  1.0000000000e+000f},  {1.0000000000e+000f,  2.9730176926e-001f}, 
		{2.5000000000e-001f,  1.0000000000e+000f},  {1.0000000000e+000f,  2.5000000000e-001f}, 
		{2.1022410691e-001f,  1.0000000000e+000f},  {1.0000000000e+000f,  2.1022410691e-001f}, 
		{1.7677669227e-001f,  1.0000000000e+000f},  {1.0000000000e+000f,  1.7677669227e-001f}, 
		{1.4865088463e-001f,  1.0000000000e+000f},  {1.0000000000e+000f,  1.4865088463e-001f}, 
		{1.2500000000e-001f,  1.0000000000e+000f},  {1.0000000000e+000f,  1.2500000000e-001f}, 
		{1.0511205345e-001f,  1.0000000000e+000f},  {1.0000000000e+000f,  1.0511205345e-001f}, 
		{8.8388346136e-002f,  1.0000000000e+000f},  {1.0000000000e+000f,  8.8388346136e-002f}, 
		{7.4325442314e-002f,  1.0000000000e+000f},  {1.0000000000e+000f,  7.4325442314e-002f}, 
		{1.0000000000e+000f,  0.0000000000e+000f},  {0.0000000000e+000f,  0.0000000000e+000f}, 
		},
		{
		{1.0000000000e+000f,  1.0000000000e+000f},  {1.4142135382e+000f,  1.4142135382e+000f}, 
		{1.0000000000e+000f,  1.0000000000e+000f},  {1.4142135382e+000f,  1.4142135382e+000f}, 
		{1.1892070770e+000f,  1.4142135382e+000f},  {1.4142135382e+000f,  1.1892070770e+000f}, 
		{1.0000000000e+000f,  1.0000000000e+000f},  {1.4142135382e+000f,  1.4142135382e+000f}, 
		{1.1892070770e+000f,  1.4142135382e+000f},  {1.4142135382e+000f,  1.1892070770e+000f}, 
		{1.0000000000e+000f,  1.4142135382e+000f},  {1.4142135382e+000f,  1.0000000000e+000f}, 
		{8.4089642763e-001f,  1.4142135382e+000f},  {1.4142135382e+000f,  8.4089642763e-001f}, 
		{1.0000000000e+000f,  1.0000000000e+000f},  {1.4142135382e+000f,  1.4142135382e+000f}, 
		{1.1892070770e+000f,  1.4142135382e+000f},  {1.4142135382e+000f,  1.1892070770e+000f}, 
		{1.0000000000e+000f,  1.4142135382e+000f},  {1.4142135382e+000f,  1.0000000000e+000f}, 
		{8.4089642763e-001f,  1.4142135382e+000f},  {1.4142135382e+000f,  8.4089642763e-001f}, 
		{7.0710676908e-001f,  1.4142135382e+000f},  {1.4142135382e+000f,  7.0710676908e-001f}, 
		{5.9460353851e-001f,  1.4142135382e+000f},  {1.4142135382e+000f,  5.9460353851e-001f}, 
		{5.0000000000e-001f,  1.4142135382e+000f},  {1.4142135382e+000f,  5.0000000000e-001f}, 
		{4.2044821382e-001f,  1.4142135382e+000f},  {1.4142135382e+000f,  4.2044821382e-001f}, 
		{1.0000000000e+000f,  1.0000000000e+000f},  {1.4142135382e+000f,  1.4142135382e+000f}, 
		{1.1892070770e+000f,  1.4142135382e+000f},  {1.4142135382e+000f,  1.1892070770e+000f}, 
		{1.0000000000e+000f,  1.4142135382e+000f},  {1.4142135382e+000f,  1.0000000000e+000f}, 
		{8.4089642763e-001f,  1.4142135382e+000f},  {1.4142135382e+000f,  8.4089642763e-001f}, 
		{7.0710676908e-001f,  1.4142135382e+000f},  {1.4142135382e+000f,  7.0710676908e-001f}, 
		{5.9460353851e-001f,  1.4142135382e+000f},  {1.4142135382e+000f,  5.9460353851e-001f}, 
		{5.0000000000e-001f,  1.4142135382e+000f},  {1.4142135382e+000f,  5.0000000000e-001f}, 
		{4.2044821382e-001f,  1.4142135382e+000f},  {1.4142135382e+000f,  4.2044821382e-001f}, 
		{3.5355338454e-001f,  1.4142135382e+000f},  {1.4142135382e+000f,  3.5355338454e-001f}, 
		{2.9730176926e-001f,  1.4142135382e+000f},  {1.4142135382e+000f,  2.9730176926e-001f}, 
		{2.5000000000e-001f,  1.4142135382e+000f},  {1.4142135382e+000f,  2.5000000000e-001f}, 
		{2.1022410691e-001f,  1.4142135382e+000f},  {1.4142135382e+000f,  2.1022410691e-001f}, 
		{1.7677669227e-001f,  1.4142135382e+000f},  {1.4142135382e+000f,  1.7677669227e-001f}, 
		{1.4865088463e-001f,  1.4142135382e+000f},  {1.4142135382e+000f,  1.4865088463e-001f}, 
		{1.2500000000e-001f,  1.4142135382e+000f},  {1.4142135382e+000f,  1.2500000000e-001f}, 
		{1.0511205345e-001f,  1.4142135382e+000f},  {1.4142135382e+000f,  1.0511205345e-001f}, 
		{1.0000000000e+000f,  1.0000000000e+000f},  {0.0000000000e+000f,  0.0000000000e+000f}, 
		}
	},
	{
		{
		{1.0000000000e+000f,  0.0000000000e+000f},  {1.0000000000e+000f,  1.0000000000e+000f}, 
		{1.0000000000e+000f,  0.0000000000e+000f},  {1.0000000000e+000f,  1.0000000000e+000f}, 
		{7.0710676908e-001f,  1.0000000000e+000f},  {1.0000000000e+000f,  7.0710676908e-001f}, 
		{1.0000000000e+000f,  0.0000000000e+000f},  {1.0000000000e+000f,  1.0000000000e+000f}, 
		{7.0710676908e-001f,  1.0000000000e+000f},  {1.0000000000e+000f,  7.0710676908e-001f}, 
		{5.0000000000e-001f,  1.0000000000e+000f},  {1.0000000000e+000f,  5.0000000000e-001f}, 
		{3.5355338454e-001f,  1.0000000000e+000f},  {1.0000000000e+000f,  3.5355338454e-001f}, 
		{1.0000000000e+000f,  0.0000000000e+000f},  {1.0000000000e+000f,  1.0000000000e+000f}, 
		{7.0710676908e-001f,  1.0000000000e+000f},  {1.0000000000e+000f,  7.0710676908e-001f}, 
		{5.0000000000e-001f,  1.0000000000e+000f},  {1.0000000000e+000f,  5.0000000000e-001f}, 
		{3.5355338454e-001f,  1.0000000000e+000f},  {1.0000000000e+000f,  3.5355338454e-001f}, 
		{2.5000000000e-001f,  1.0000000000e+000f},  {1.0000000000e+000f,  2.5000000000e-001f}, 
		{1.7677669227e-001f,  1.0000000000e+000f},  {1.0000000000e+000f,  1.7677669227e-001f}, 
		{1.2500000000e-001f,  1.0000000000e+000f},  {1.0000000000e+000f,  1.2500000000e-001f}, 
		{8.8388346136e-002f,  1.0000000000e+000f},  {1.0000000000e+000f,  8.8388346136e-002f}, 
		{1.0000000000e+000f,  0.0000000000e+000f},  {1.0000000000e+000f,  1.0000000000e+000f}, 
		{7.0710676908e-001f,  1.0000000000e+000f},  {1.0000000000e+000f,  7.0710676908e-001f}, 
		{5.0000000000e-001f,  1.0000000000e+000f},  {1.0000000000e+000f,  5.0000000000e-001f}, 
		{3.5355338454e-001f,  1.0000000000e+000f},  {1.0000000000e+000f,  3.5355338454e-001f}, 
		{2.5000000000e-001f,  1.0000000000e+000f},  {1.0000000000e+000f,  2.5000000000e-001f}, 
		{1.7677669227e-001f,  1.0000000000e+000f},  {1.0000000000e+000f,  1.7677669227e-001f}, 
		{1.2500000000e-001f,  1.0000000000e+000f},  {1.0000000000e+000f,  1.2500000000e-001f}, 
		{8.8388346136e-002f,  1.0000000000e+000f},  {1.0000000000e+000f,  8.8388346136e-002f}, 
		{6.2500000000e-002f,  1.0000000000e+000f},  {1.0000000000e+000f,  6.2500000000e-002f}, 
		{4.4194173068e-002f,  1.0000000000e+000f},  {1.0000000000e+000f,  4.4194173068e-002f}, 
		{3.1250000000e-002f,  1.0000000000e+000f},  {1.0000000000e+000f,  3.1250000000e-002f}, 
		{2.2097086534e-002f,  1.0000000000e+000f},  {1.0000000000e+000f,  2.2097086534e-002f}, 
		{1.5625000000e-002f,  1.0000000000e+000f},  {1.0000000000e+000f,  1.5625000000e-002f}, 
		{1.1048543267e-002f,  1.0000000000e+000f},  {1.0000000000e+000f,  1.1048543267e-002f}, 
		{7.8125000000e-003f,  1.0000000000e+000f},  {1.0000000000e+000f,  7.8125000000e-003f}, 
		{5.5242716335e-003f,  1.0000000000e+000f},  {1.0000000000e+000f,  5.5242716335e-003f}, 
		{1.0000000000e+000f,  0.0000000000e+000f},  {0.0000000000e+000f,  0.0000000000e+000f}, 
		},
		{
		{1.0000000000e+000f,  1.0000000000e+000f},  {1.4142135382e+000f,  1.4142135382e+000f}, 
		{1.0000000000e+000f,  1.0000000000e+000f},  {1.4142135382e+000f,  1.4142135382e+000f}, 
		{1.0000000000e+000f,  1.4142135382e+000f},  {1.4142135382e+000f,  1.0000000000e+000f}, 
		{1.0000000000e+000f,  1.0000000000e+000f},  {1.4142135382e+000f,  1.4142135382e+000f}, 
		{1.0000000000e+000f,  1.4142135382e+000f},  {1.4142135382e+000f,  1.0000000000e+000f}, 
		{7.0710676908e-001f,  1.4142135382e+000f},  {1.4142135382e+000f,  7.0710676908e-001f}, 
		{5.0000000000e-001f,  1.4142135382e+000f},  {1.4142135382e+000f,  5.0000000000e-001f}, 
		{1.0000000000e+000f,  1.0000000000e+000f},  {1.4142135382e+000f,  1.4142135382e+000f}, 
		{1.0000000000e+000f,  1.4142135382e+000f},  {1.4142135382e+000f,  1.0000000000e+000f}, 
		{7.0710676908e-001f,  1.4142135382e+000f},  {1.4142135382e+000f,  7.0710676908e-001f}, 
		{5.0000000000e-001f,  1.4142135382e+000f},  {1.4142135382e+000f,  5.0000000000e-001f}, 
		{3.5355338454e-001f,  1.4142135382e+000f},  {1.4142135382e+000f,  3.5355338454e-001f}, 
		{2.5000000000e-001f,  1.4142135382e+000f},  {1.4142135382e+000f,  2.5000000000e-001f}, 
		{1.7677669227e-001f,  1.4142135382e+000f},  {1.4142135382e+000f,  1.7677669227e-001f}, 
		{1.2500000000e-001f,  1.4142135382e+000f},  {1.4142135382e+000f,  1.2500000000e-001f}, 
		{1.0000000000e+000f,  1.0000000000e+000f},  {1.4142135382e+000f,  1.4142135382e+000f}, 
		{1.0000000000e+000f,  1.4142135382e+000f},  {1.4142135382e+000f,  1.0000000000e+000f}, 
		{7.0710676908e-001f,  1.4142135382e+000f},  {1.4142135382e+000f,  7.0710676908e-001f}, 
		{5.0000000000e-001f,  1.4142135382e+000f},  {1.4142135382e+000f,  5.0000000000e-001f}, 
		{3.5355338454e-001f,  1.4142135382e+000f},  {1.4142135382e+000f,  3.5355338454e-001f}, 
		{2.5000000000e-001f,  1.4142135382e+000f},  {1.4142135382e+000f,  2.5000000000e-001f}, 
		{1.7677669227e-001f,  1.4142135382e+000f},  {1.4142135382e+000f,  1.7677669227e-001f}, 
		{1.2500000000e-001f,  1.4142135382e+000f},  {1.4142135382e+000f,  1.2500000000e-001f}, 
		{8.8388346136e-002f,  1.4142135382e+000f},  {1.4142135382e+000f,  8.8388346136e-002f}, 
		{6.2500000000e-002f,  1.4142135382e+000f},  {1.4142135382e+000f,  6.2500000000e-002f}, 
		{4.4194173068e-002f,  1.4142135382e+000f},  {1.4142135382e+000f,  4.4194173068e-002f}, 
		{3.1250000000e-002f,  1.4142135382e+000f},  {1.4142135382e+000f,  3.1250000000e-002f}, 
		{2.2097086534e-002f,  1.4142135382e+000f},  {1.4142135382e+000f,  2.2097086534e-002f}, 
		{1.5625000000e-002f,  1.4142135382e+000f},  {1.4142135382e+000f,  1.5625000000e-002f}, 
		{1.1048543267e-002f,  1.4142135382e+000f},  {1.4142135382e+000f,  1.1048543267e-002f}, 
		{7.8125000000e-003f,  1.4142135382e+000f},  {1.4142135382e+000f,  7.8125000000e-003f}, 
		{1.0000000000e+000f,  1.0000000000e+000f},  {0.0000000000e+000f,  0.0000000000e+000f}, 
		}
	}
};
