/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: CHXClientSink.h,v 1.11.2.4 2004/07/09 01:49:47 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef _CHXCLIENT_SINK_H_
#define _CHXCLIENT_SINK_H_

#include "CHXClientUnknown.h"

#include "enter_hx_headers.h"
#include "hxclsnk.h"
#include "hxgroup.h"
#include "hxausvc.h" // IHXVolumeAdviseSink
#include "hxerror.h"
#include "hxengin.h" // IHXCallback

#ifdef HELIX_FEATURE_REGISTRY
#include "hxmon.h"   // IHXPropWatch, IHXPropWatchResponse
#include "hxsmartptr.h"
HX_SMART_POINTER_INLINE( SPIHXPropWatch, IHXPropWatch );
#endif

#include "exit_hx_headers.h"

#include "HXClientCallbacks.h"

extern UINT32 const kInvalidSeekPosition;

	typedef int HXBOOL;

_INTERFACE IHXPlayer;
class CHXClientSink
	: public CHXClientUnknown
	, public IHXClientAdviseSink
	, public IHXGroupSink
	, public IHXVolumeAdviseSink
#ifdef HELIX_FEATURE_REGISTRY
	, public IHXPropWatchResponse
#endif
	, public IHXErrorSink
	, public IHXCallback
{
    DECLARE_UNKNOWN_NOCREATE( CHXClientSink )

private:

	void* m_UserInfo;
	const HXClientCallbacks* m_pClientCallbacks;
	IHXPlayer* m_pIHXCorePlayer;
    CallbackHandle m_hScheduler;

#ifdef HELIX_FEATURE_REGISTRY
	SPIHXPropWatch m_spPropWatch;
	UINT32 m_TitlePropID;
	UINT32 m_ClipBandwidthPropID;
#endif

	UINT32 m_TitleSize;
	char* m_pTitle;
	char* m_pMetafileURL;
	char* m_pTrackURL;
	char* m_pContextURL;
	char* m_pRPURL;
	char* m_pRPURLTarget;
	INT32 m_ClipBandwidth;
	int m_ContentState;
	UINT16 m_BufferPercent;
	UINT32 m_Position;
	UINT32 m_Length;
	UINT32 m_OnPlayingPositionThreshold;
	UINT32 m_PendingBeginPosition;
	bool m_IsLive;
	bool m_IsGroupsListDirty;
	bool m_HasContentBegun;
	
	void SetUpPropWatcher( void );
	void DestroyPropWatcher( void );

	void DoGroupsListUpdate( void );
	void UpdateContentState( int newContentState );
	void GetURLsFromTrackProperties( IHXValues* pTrackProperties );
	void UpdateContextURL( void );
	void UpdateRPURLAndTarget( void );
	
public:

    virtual ~CHXClientSink( void );
    CHXClientSink( IHXPlayer* pIHXPlayer, void* userInfo, const HXClientCallbacks* pClientCallbacks );

	// For establishing and removing references from CORE.
	void Init( void );
	void Destroy( void );
	
	void ProcessPendingStateChange( void );
	int GetContentState( void ) const
	{
		return m_ContentState;
	}
	UINT32 GetPosition( void ) const
	{
		return m_Position;
	}
	UINT32 GetLength( void ) const
	{
		return m_Length;
	}
	INT32 GetClipBandwidth( void ) const
	{
		return m_ClipBandwidth;
	}
	const char* GetTitle( void ) const
	{
		return m_pTitle;
	}
	const char* GetContextURL( void ) const
	{
		return m_pContextURL;
	}
	void SetBeginPosition( UINT32 beginPosition );
	bool HasContentBegun( void ) const
	{
		return m_HasContentBegun;
	}
	
	// IHXClientAdviseSink
	STDMETHOD ( OnPosLength ) ( THIS_ UINT32 ulPosition, UINT32 ulLength );
	STDMETHOD ( OnPresentationOpened ) ( THIS );
	STDMETHOD ( OnPresentationClosed ) ( THIS );
	STDMETHOD ( OnStatisticsChanged ) ( THIS );
	STDMETHOD ( OnPreSeek ) ( THIS_ ULONG32 ulOldTime, ULONG32 ulNewTime );
	STDMETHOD ( OnPostSeek ) ( THIS_ ULONG32 ulOldTime, ULONG32 ulNewTime );
	STDMETHOD ( OnStop ) ( THIS );
	STDMETHOD ( OnPause ) ( THIS_ ULONG32 ulTime );
	STDMETHOD ( OnBegin ) ( THIS_ ULONG32 ulTime );
	STDMETHOD ( OnBuffering ) ( THIS_ ULONG32 ulFlags, UINT16 unPercentComplete );
	STDMETHOD ( OnContacting ) ( THIS_ const char* pHostName );

	// IHXGroupSink
	STDMETHOD ( GroupAdded ) ( THIS_ UINT16 uGroupIndex, IHXGroup* pGroup );
	STDMETHOD ( GroupRemoved ) ( THIS_ UINT16 uGroupIndex, IHXGroup* pGroup );
	STDMETHOD ( AllGroupsRemoved ) ( THIS );
	STDMETHOD ( TrackAdded ) ( THIS_ UINT16 uGroupIndex, UINT16 uTrackIndex, IHXValues* pTrack );
	STDMETHOD ( TrackRemoved ) ( THIS_ UINT16 uGroupIndex, UINT16 uTrackIndex, IHXValues* pTrack );
	STDMETHOD ( TrackStarted ) ( THIS_ UINT16 uGroupIndex, UINT16 uTrackIndex, IHXValues* pTrack );
	STDMETHOD ( TrackStopped ) ( THIS_ UINT16 uGroupIndex, UINT16 uTrackIndex, IHXValues* pTrack );
	STDMETHOD ( CurrentGroupSet ) ( THIS_ UINT16 uGroupIndex, IHXGroup* pGroup );
	
	// IHXVolumeAdviseSink
	STDMETHOD ( OnVolumeChange ) ( THIS_ const UINT16 uVolume );
	STDMETHOD ( OnMuteChange ) ( THIS_ const HXBOOL bMute );
	
#ifdef HELIX_FEATURE_REGISTRY
	// IHXPropWatchResponse
	STDMETHOD ( AddedProp ) ( THIS_ const UINT32 ulId, const HXPropType propType, const UINT32 ulParentID );
	STDMETHOD ( ModifiedProp ) ( THIS_ const UINT32 ulId, const HXPropType propType, const UINT32 ulParentID );
	STDMETHOD ( DeletedProp ) ( THIS_ const UINT32 ulId, const UINT32 ulParentID );
#endif

	// IHXErrorSink
	STDMETHOD ( ErrorOccurred ) ( THIS_ const UINT8	unSeverity,  
										const ULONG32	ulHXCode,
										const ULONG32	ulUserCode,
										const char*	pUserString,
										const char*	pMoreInfoURL );

	// IHXCallback
	STDMETHOD ( Func ) ( THIS );
};

#endif
