/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: miniopenwavesite.cpp,v 1.2.12.1 2004/07/09 01:59:07 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#include "minisite.h"
#include "miniopenwavesite.h"
#include "miniopenwavesurf.h"

#include "opwindow.h"

CHXOpenwaveSite::CHXOpenwaveSite( IUnknown* pContext,
                                IUnknown* pUnkOuter,
                                INT32 lZorder)
    :  CMiniBaseSite(pContext, pUnkOuter, lZorder)
{
    m_ScreenSize.cx = 0;
    m_ScreenSize.cy = 0;
    m_LastSize.cx = 0;
    m_LastSize.cy = 0;
}

CHXOpenwaveSite::~CHXOpenwaveSite()
{

	/// Before destroy the site and surface 
	/// reset the image point that is cached by the application 
	/// window. This call should be sectioned within a mutex region
	/// to prevent from risk condition in multithread environment
	if (m_pOpWin)
	{
		m_pOpWin->SetImageSource(NULL);
	}

}

void* CHXOpenwaveSite::_Create(void* pParentWindow, UINT32 style)
{

#ifdef _DEBUG
	if (!pParentWindow)
		fprintf( stderr, "CHxOpenwaveSite::_Create: No valid parent window\n" );
#endif
	return (void*)pParentWindow;
}

void  CHXOpenwaveSite::_Destroy(HXxWindow* pWindow)
{
}

void  CHXOpenwaveSite::_SetSize(HXxSize size)
{
    if (m_ScreenSize.cx == 0 || m_ScreenSize.cy == 0)
    {
	m_ScreenSize = m_LastSize = size;  // set internals
    }
    else if (size.cx > m_ScreenSize.cx || size.cy > m_ScreenSize.cy)
    {
	if (m_LastSize.cx == 0 || m_LastSize.cy == 0)
	    m_LastSize = m_ScreenSize;
	m_size = m_LastSize; // reset to last good size
    }
    else
    {
	m_LastSize = size;  // save last good size
    }

}

void  CHXOpenwaveSite::_SetPosition(HXxPoint position)
{
}


void CHXOpenwaveSite::_AttachWindow()
{
	HXxWindow *pHXWin = this->GetWindow();
	m_pOpWin = NULL;

	if (pHXWin)
	{
		m_pOpWin = (COpWindow *) pHXWin->window;
	}

#ifdef _DEBUG
	if (!pHXWin || !m_pOpWin)
		fprintf(stderr, "CHXOpenwaveSite:: No valid window for site\n");
#endif

}

BOOL  CHXOpenwaveSite::_MoveWindow( void* window ,
                                   INT32 X, INT32 Y,
                                   INT32 nWidth, INT32 nHeight,
                                   BOOL bRepaint)
    
{
    return TRUE;
}

