/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: hvtimer.c,v 1.1.1.1.42.1 2004/07/09 01:56:22 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#include "machine.h"
#include "oldtool.h"

#ifdef _OS2

/*** OS/2 code path ***************************************/

#if 0

#define INCL_DOSMISC
#include "os.h"

DWORD VvGetAbsTimeMillisec (void)
{
     
    // here we need to read the OS/2 system clock and return the number
    // of ticks.  This is a 32-bit free running counter of the number
    // of milliseconds since power up.  Note that we will encounter
    // time wrap if PC is not powered down in 49.71 days
 
    DWORD milliseconds;
 
    if (DosQuerySysInfo(QSV_MS_COUNT, QSV_MS_COUNT, &milliseconds, sizeof(ULONG)) != NO_ERROR )
       milliseconds = 0;

    return milliseconds;
}

#endif

#else // ! _OS/2

/*** Windows code path   **********************************/


static TIMERINFO ti = { sizeof(TIMERINFO), 0, 0,};

DWORD VvGetAbsTimeMillisec (void);

DWORD VvGetDeltaTimeMillisec (DWORD start);


DWORD
VvGetAbsTimeMillisec (void)
{
    TIMERINFO *lpti = &ti;

//    TimerCount (lpti);
    return lpti->dwmsSinceStart;
}


DWORD
VvGetDeltaTimeMillisec (DWORD start)
{
    return VvGetAbsTimeMillisec() - start;
}

#endif // ! _OS2


        
