/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: pximage.h,v 1.1.26.1 2004/07/09 01:54:36 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef _PXIMAGE_H
#define _PXIMAGE_H

// Forward class declarations
class PXImage;
class CHXBaseCountingObject;
class PXRect;
class PXColor;
// Forward interface declarations
typedef _INTERFACE IUnknown         IUnknown;
typedef _INTERFACE IHXBuffer       IHXBuffer;
typedef _INTERFACE IHXVideoSurface IHXVideoSurface;

enum
{
    kIterLRTB,
    kIterLRBT,
    kIterRLTB,
    kIterRLBT,
    kIterTBLR,
    kIterTBRL,
    kIterBTLR,
    kIterBTRL
};

class PXImageIterator
{
public:
    PXImageIterator(PXImage* pImg, INT32 lX, INT32 lY);
    virtual ~PXImageIterator();

    BOOL                     operator == (const PXImageIterator& rItr);
    BOOL                     operator != (const PXImageIterator& rItr);
    virtual PXImageIterator& operator ++ () = 0;
    UINT32&                  operator *  ();
    UINT32&                  GetPixel();
protected:
    PXImage* m_pImage;
    UINT32*  m_pPixel;
    INT32    m_lX;
    INT32    m_lY;
};

class PXImage : public CHXBaseCountingObject,
                public IUnknown
{
public:
    enum
    {
        kWriteFormatBinaryRaw,
        kWriteFormatAscii
    };

    PXImage();
    virtual ~PXImage();

    static HX_RESULT CreateObject(PXImage** ppImg);
    static HX_RESULT CreateInstance(PXImage** ppImg);

    // IUnknown methods
    STDMETHOD(QueryInterface)  (THIS_ REFIID riid, void** ppvObj);
    STDMETHOD_(UINT32,AddRef)  (THIS);
    STDMETHOD_(UINT32,Release) (THIS);

    HX_RESULT Create(INT32 lW, INT32 lH, UINT32 ulBpp, UINT32 ulFormat,
                     BOOL bRowsInverted, BOOL bAlloc = TRUE);
    HX_RESULT CreateFromBuffer(INT32 lW, INT32 lH, UINT32 ulBpp, UINT32 ulFormat,
                               BOOL bRowsInverted, IHXBuffer* pBuffer);
    HX_RESULT CreateSubImageFromBuffer(PXImage* pImg, INT32 lX, INT32 lY,
                                       INT32 lW, INT32 lH, IHXBuffer* pBuffer);
    HX_RESULT CreateSubImageFromBuffer(PXImage* pImg, const PXRect& rSubRect, IHXBuffer* pBuffer);
    HX_RESULT CreateSubImage(PXImage* pImg, INT32 lX = 0, INT32 lY = 0,
                             INT32 lW = 0, INT32 lH = 0, BOOL bCopy = FALSE, BOOL bAlloc = FALSE);
    HX_RESULT CreateSubImage(PXImage* pImg, const PXRect& rSubRect,
                             BOOL bCopy = FALSE, BOOL bAlloc = FALSE);
    HX_RESULT CreateSubImage(PXImage* pImg, const HXxRect& rSubRect,
                             BOOL bCopy = FALSE, BOOL bAlloc = FALSE);
    void      Destroy();

    HX_RESULT Fill(const PXColor& rColor);
    HX_RESULT Fill32(UINT32 ulColor);
    HX_RESULT Blend(PXImage* pImg1, PXImage* pImg2, BYTE* pLUT1, BYTE* pLUT2);
    HX_RESULT RecursiveBlend(PXImage* pImg1, BYTE* pLUT1, BYTE* pSelfLUT);
    HX_RESULT BlendToColor(PXImage* pImg1, const PXColor& rColor, BYTE* pLUT1, BYTE* pLUT2);
    HX_RESULT RecursiveBlendToColor(const PXColor& rColor, BYTE* pLUT1, BYTE* pLUT2);
    HX_RESULT ChangeSizeFromNN(PXImage* pImg);
    HX_RESULT ChangeSizeFromNNTransparent32(PXImage* pImg);
    HX_RESULT ChangeSizeIntoNN(PXImage* pImg);
    HX_RESULT ChangeSizeIntoNNTransparent32(PXImage* pImg);
    HX_RESULT CopyFrom(PXImage* pImg);
    HX_RESULT CopyFromTransparent32(PXImage* pImg);
    HX_RESULT CopyFromAlpha32(PXImage* pImg, BYTE* pLUT);
    HX_RESULT CopyTo(PXImage* pImg);
    HX_RESULT CopyToTransparent32(PXImage* pImg);
    HX_RESULT CopyToAlpha32(PXImage* pImg, BYTE* pLUT);
    HX_RESULT FlipFrom(PXImage* pImg, BOOL bVerticalAxis);
    HX_RESULT FlipTo(PXImage* pImg, BOOL bVerticalAxis);
    HX_RESULT Wipe(PXImage* pStartImg, PXImage* pEndImg, UINT32 ulType, UINT32 ulDirection,
                   UINT32 ulTime, UINT32 ulDuration);
    HX_RESULT RecursiveWipe(PXImage* pEndImage, UINT32 ulType, UINT32 ulDirection, UINT32 ulLastTime,
                            UINT32 ulTime, UINT32 ulDuration, PXRect& rDamageRect);
    HX_RESULT IntraCopy(const PXRect& rSrcRect, const PXRect& rDstRect);
    HX_RESULT DrawToHXSurface(IHXVideoSurface* pSurface, HXxRect& rDstRect);
    HX_RESULT DrawToHXSurface(IHXVideoSurface* pSurface, HXxRect& rSrcRect, HXxRect& rDstRect);
    HX_RESULT GetPixel(INT32 lX, INT32 lY, BYTE** ppPixel);
    BYTE*     GetPixel(INT32 lX, INT32 lY);
    HX_RESULT GetImageStore(IHXBuffer** ppBuffer);
    void      ConvertToRGBOrder(INT32 lScanline, BYTE* pLine);
    void      ConvertFromRGBOrder(INT32 lScanline, BYTE* pLine);

    INT32     GetWidth()           const { return m_lSubImageWidth;            }
    INT32     GetHeight()          const { return m_lSubImageHeight;           }
    UINT32    GetFormat()          const { return m_cBitmapInfo.biCompression; }
    UINT32    GetBitsPerPixel()    const { return m_cBitmapInfo.biBitCount;    }
    UINT32    GetBytesPerPixel()   const { return m_ulBytesPerPixel;           }
    BOOL      GetRowsInverted()    const { return m_bRowsInverted;             }
    BYTE*     GetImageBuffer()     const { return m_pImageBuffer;              }
    UINT32    GetImageBufferSize() const { return m_lSubImageWidth * m_lSubImageHeight * m_ulBytesPerPixel; }
    INT32     GetRowStride()       const { return m_lRowStride;                }
    INT32     GetRowJump()         const { return m_lRowJump;                  }
    INT32     GetRowJump32()       const { return m_lRowJump >> 2;             }
    UINT32    GetImageStoreSize()  const { return (m_pImageStore ? m_pImageStore->GetSize() : 0); }
    BOOL      GetHasAlpha()        const { return m_bHasAlpha;                 }
    void      SetHasAlpha(BOOL bFlag)    { m_bHasAlpha = bFlag;                }
    void      GetSubRect(HXxRect& rRect) const { rRect = m_cSubImageRect; }
    void      GetSubRect(PXRect& rRect) const;
    void      Write(const char* pszFileName, UINT32 ulWriteFormat);
    void      SelfDetermineHasAlpha();
    void      PreMultiplyAlphaChannel(UINT32 ulColor);
    BOOL      CompressionSupported();

    HX_RESULT GetIterator(PXImageIterator** ppIterator, UINT32 ulType = kIterLRTB);

    BOOL      SameSize(PXImage* pImg) const;
    BOOL      Compatible(PXImage* pImg) const;

    static UINT32 GetMaxWidth()  { return kMaxWidth;  }
    static UINT32 GetMaxHeight() { return kMaxHeight; }
protected:
    enum
    {
        kMaxWidth  = 16834,
        kMaxHeight = 16384
    };

    INT32               m_lRefCount;
    HXBitmapInfoHeader m_cBitmapInfo;
    HXxRect             m_cSubImageRect;
    INT32               m_lSubImageWidth;
    INT32               m_lSubImageHeight;
    UINT32              m_ulBytesPerPixel;
    INT32               m_lRowBytes;
    INT32               m_lRowStride;
    INT32               m_lRowJump;
    BOOL                m_bRowsInverted;
    BYTE*               m_pImageBuffer;
    IHXBuffer*         m_pImageStore;
    BOOL                m_bInitialized;
    BOOL                m_bHasAlpha;

    void                ResetMembers();
    void                Copy32(UINT32* pSrc, UINT32* pDst, INT32 lSrcJump, INT32 lDstJump, BOOL bUseAlpha = FALSE);
    void                CopyTransparent32(UINT32* pSrc, UINT32* pDst, INT32 lSrcJump, INT32 lDstJump);
    void                CopyAlpha32(UINT32* pSrc, UINT32* pDst, INT32 lSrcJump, INT32 lDstJump, BYTE* pLUT);
    HX_RESULT           ChangeSize32NN(UINT32* pSrc, INT32 lSrcW, INT32 lSrcH, INT32 lSrcJump,
                                       UINT32* pDst, INT32 lDstW, INT32 lDstH, INT32 lDstJump);
    HX_RESULT           ChangeSize32NNTransparent(UINT32* pSrc, INT32 lSrcW, INT32 lSrcH, INT32 lSrcJump,
                                                  UINT32* pDst, INT32 lDstW, INT32 lDstH, INT32 lDstJump);
    void                HorzAxisFlip32(UINT32* pSrc, INT32 lSrcW, INT32 lSrcH, INT32 lSrcJump,
                                       UINT32* pDst, INT32 lDstW, INT32 lDstH, INT32 lDstJump);
    void                VertAxisFlip32(UINT32* pSrc, INT32 lSrcW, INT32 lSrcH, INT32 lSrcJump,
                                       UINT32* pDst, INT32 lDstW, INT32 lDstH, INT32 lDstJump);
};

class PXImageIteratorLRTB : public PXImageIterator
{
public:
    PXImageIteratorLRTB(PXImage* pImg)
        : PXImageIterator(pImg, 0, 0) {};
    ~PXImageIteratorLRTB() {};

    PXImageIterator& operator ++ ();
};

class PXImageIteratorLRBT : public PXImageIterator
{
public:
    PXImageIteratorLRBT(PXImage* pImg)
        : PXImageIterator(pImg, 0, pImg->GetHeight() - 1) {};
    ~PXImageIteratorLRBT() {};

    PXImageIterator& operator ++ ();
};

class PXImageIteratorRLTB : public PXImageIterator
{
public:
    PXImageIteratorRLTB(PXImage* pImg)
        : PXImageIterator(pImg, pImg->GetWidth() - 1, 0) {};
    ~PXImageIteratorRLTB() {};

    PXImageIterator& operator ++ ();
};

class PXImageIteratorRLBT : public PXImageIterator
{
public:
    PXImageIteratorRLBT(PXImage* pImg)
        : PXImageIterator(pImg, pImg->GetWidth() - 1, pImg->GetHeight() - 1) {};
    ~PXImageIteratorRLBT() {};

    PXImageIterator& operator ++ ();
};

class PXImageIteratorTBLR : public PXImageIterator
{
public:
    PXImageIteratorTBLR(PXImage* pImg)
        : PXImageIterator(pImg, 0, 0) {};
    ~PXImageIteratorTBLR() {};

    PXImageIterator& operator ++ ();
};

class PXImageIteratorTBRL : public PXImageIterator
{
public:
    PXImageIteratorTBRL(PXImage* pImg)
        : PXImageIterator(pImg, pImg->GetWidth() - 1, 0) {};
    ~PXImageIteratorTBRL() {};

    PXImageIterator& operator ++ ();
};

class PXImageIteratorBTLR : public PXImageIterator
{
public:
    PXImageIteratorBTLR(PXImage* pImg)
        : PXImageIterator(pImg, 0, pImg->GetHeight() - 1) {};
    ~PXImageIteratorBTLR() {};

    PXImageIterator& operator ++ ();
};

class PXImageIteratorBTRL : public PXImageIterator
{
public:
    PXImageIteratorBTRL(PXImage* pImg)
        : PXImageIterator(pImg, pImg->GetWidth() - 1, pImg->GetHeight() - 1) {};
    ~PXImageIteratorBTRL() {};

    PXImageIterator& operator ++ ();
};

inline PXImageIterator::PXImageIterator(PXImage* pImg, INT32 lX, INT32 lY)
{
    HX_ASSERT(pImg);
    m_pImage = pImg;
    m_lX     = lX;
    m_lY     = lY;
    if (m_lX >= 0 && m_lX < m_pImage->GetWidth() &&
        m_lY >= 0 && m_lY < m_pImage->GetHeight())
    {
        m_pPixel = (UINT32*) m_pImage->GetPixel(m_lX, m_lY);
    }
    else
    {
        m_pPixel = NULL;
    }
    m_pImage->AddRef();
}

inline PXImageIterator::~PXImageIterator()
{
    HX_RELEASE(m_pImage);
}

inline BOOL PXImageIterator::operator == (const PXImageIterator& itr)
{
    BOOL bRet = FALSE;
    if (m_pImage == itr.m_pImage &&
        m_lX     == itr.m_lX     &&
        m_lY     == itr.m_lY)
    {
        bRet = TRUE;
    }
    return bRet;
}

inline BOOL PXImageIterator::operator != (const PXImageIterator& itr)
{
    return !(*this == itr);
}

inline UINT32& PXImageIterator::operator * ()
{
    HX_ASSERT(m_pPixel);
    return *m_pPixel;
}

inline UINT32& PXImageIterator::GetPixel()
{
    HX_ASSERT(m_pPixel);
    return *m_pPixel;
}

inline PXImageIterator& PXImageIteratorLRTB::operator ++ ()
{
    if (m_lX >= 0 && m_lX < m_pImage->GetWidth() &&
        m_lY >= 0 && m_lY < m_pImage->GetHeight())
    {
        m_lX++;
        if (m_lX < m_pImage->GetWidth())
        {
            m_pPixel++;
        }
        else
        {
            m_lY++;
            if (m_lY < m_pImage->GetHeight())
            {
                m_lX     = 0;
                m_pPixel = (UINT32*) m_pImage->GetPixel(m_lX, m_lY);
            }
        }
    }
    return *this;
}

inline PXImageIterator& PXImageIteratorLRBT::operator ++ ()
{
    if (m_lX >= 0 && m_lX < m_pImage->GetWidth() &&
        m_lY >= 0 && m_lY < m_pImage->GetHeight())
    {
        m_lX++;
        if (m_lX < m_pImage->GetWidth())
        {
            m_pPixel++;
        }
        else
        {
            m_lY--;
            if (m_lY >= 0)
            {
                m_lX     = 0;
                m_pPixel = (UINT32*) m_pImage->GetPixel(m_lX, m_lY);
            }
            else
            {
                m_lX = m_pImage->GetWidth();
                m_lY = m_pImage->GetHeight();
            }
        }
    }
    return *this;
}

inline PXImageIterator& PXImageIteratorRLTB::operator ++ ()
{
    if (m_lX >= 0 && m_lX < m_pImage->GetWidth() &&
        m_lY >= 0 && m_lY < m_pImage->GetHeight())
    {
        m_lX--;
        if (m_lX >= 0)
        {
            m_pPixel--;
        }
        else
        {
            m_lY++;
            if (m_lY < m_pImage->GetHeight())
            {
                m_lX     = m_pImage->GetWidth() - 1;
                m_pPixel = (UINT32*) m_pImage->GetPixel(m_lX, m_lY);
            }
            else
            {
                m_lX = m_pImage->GetWidth();
                m_lY = m_pImage->GetHeight();
            }
        }
    }
    return *this;
}

inline PXImageIterator& PXImageIteratorRLBT::operator ++ ()
{
    if (m_lX >= 0 && m_lX < m_pImage->GetWidth() &&
        m_lY >= 0 && m_lY < m_pImage->GetHeight())
    {
        m_lX--;
        if (m_lX >= 0)
        {
            m_pPixel--;
        }
        else
        {
            m_lY--;
            if (m_lY >= 0)
            {
                m_lX     = m_pImage->GetWidth() - 1;
                m_pPixel = (UINT32*) m_pImage->GetPixel(m_lX, m_lY);
            }
            else
            {
                m_lX = m_pImage->GetWidth();
                m_lY = m_pImage->GetHeight();
            }
        }
    }
    return *this;
}

inline PXImageIterator& PXImageIteratorTBLR::operator ++ ()
{
    if (m_lX >= 0 && m_lX < m_pImage->GetWidth() &&
        m_lY >= 0 && m_lY < m_pImage->GetHeight())
    {
        m_lY++;
        if (m_lY < m_pImage->GetHeight())
        {
            m_pPixel += m_pImage->GetRowJump32();
        }
        else
        {
            m_lX++;
            if (m_lX < m_pImage->GetWidth())
            {
                m_lY     = 0;
                m_pPixel = (UINT32*) m_pImage->GetPixel(m_lX, m_lY);
            }
            else
            {
                m_lX = m_pImage->GetWidth();
                m_lY = m_pImage->GetHeight();
            }
        }
    }
    return *this;
}

inline PXImageIterator& PXImageIteratorTBRL::operator ++ ()
{
    if (m_lX >= 0 && m_lX < m_pImage->GetWidth() &&
        m_lY >= 0 && m_lY < m_pImage->GetHeight())
    {
        m_lY++;
        if (m_lY < m_pImage->GetHeight())
        {
            m_pPixel += m_pImage->GetRowJump32();
        }
        else
        {
            m_lX--;
            if (m_lX >= 0)
            {
                m_lY     = 0;
                m_pPixel = (UINT32*) m_pImage->GetPixel(m_lX, m_lY);
            }
            else
            {
                m_lX = m_pImage->GetWidth();
                m_lY = m_pImage->GetHeight();
            }
        }
    }
    return *this;
}

inline PXImageIterator& PXImageIteratorBTLR::operator ++ ()
{
    if (m_lX >= 0 && m_lX < m_pImage->GetWidth() &&
        m_lY >= 0 && m_lY < m_pImage->GetHeight())
    {
        m_lY--;
        if (m_lY >= 0)
        {
            m_pPixel -= m_pImage->GetRowJump32();
        }
        else
        {
            m_lX++;
            if (m_lX < m_pImage->GetWidth())
            {
                m_lY     = m_pImage->GetHeight() - 1;
                m_pPixel = (UINT32*) m_pImage->GetPixel(m_lX, m_lY);
            }
            else
            {
                m_lX = m_pImage->GetWidth();
                m_lY = m_pImage->GetHeight();
            }
        }
    }
    return *this;
}

inline PXImageIterator& PXImageIteratorBTRL::operator ++ ()
{
    if (m_lX >= 0 && m_lX < m_pImage->GetWidth() &&
        m_lY >= 0 && m_lY < m_pImage->GetHeight())
    {
        m_lY--;
        if (m_lY >= 0)
        {
            m_pPixel -= m_pImage->GetRowJump32();
        }
        else
        {
            m_lX--;
            if (m_lX >= 0)
            {
                m_lY     = m_pImage->GetHeight() - 1;
                m_pPixel = (UINT32*) m_pImage->GetPixel(m_lX, m_lY);
            }
            else
            {
                m_lX = m_pImage->GetWidth();
                m_lY = m_pImage->GetHeight();
            }
        }
    }
    return *this;
}

#define GETALPHA32(p)        ( (p)               >> 24)
#define GETRED32(p)          (((p) & 0x00FF0000) >> 16)
#define GETGREEN32(p)        (((p) & 0x0000FF00) >>  8)
#define GETBLUE32(p)         ( (p) & 0x000000FF       )
#define BLENDMULT(A,B,a)     (((A)*(a) + (B)*(256-(a))) >> 8)
#define ALPHA_EXACT(A,B,a)   ((((A)*(a) + (B)*(255-(a))) + 127) / 255)
#define ALPHABLEND(A,B,a)    (((A)*(a) + (B)*(256-(a)) + 128) >> 8)
#define MAKEPIXEL32(r,g,b)   (((r) << 16) | ((g) << 8) | (b))
#define MAKE_RGB32(r,g,b)    (((r) << 16) | ((g) << 8) | (b))
#define MAKE_RGBA32(r,g,b,a) (((a) << 24) | ((r) << 16) | ((g) << 8) | (b))

#define FILTER_OUT_UNSUPPORTED_FORMATS      \
if (m_cBitmapInfo.biBitCount != 32 ||       \
    m_cBitmapInfo.biCompression != HX_RGB) \
{                                           \
    HX_ASSERT(FALSE);                       \
    return HXR_FAIL;                        \
}

#endif
