/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: smlffpln.h,v 1.2.18.1 2004/07/09 01:57:20 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef _SMLFFPLN_H_
#define _SMLFFPLN_H_

#define STREAM_MAJOR_VER    0
#define STREAM_MINOR_VER    0
#define STREAM_RELEASE	    0
#define STREAM_BUILD	    0

#define CONTENT_MAJOR_VER   0
#define CONTENT_MINOR_VER   0
#define CONTENT_RELEASE	    0
#define CONTENT_BUILD	    0

#include "baseobj.h"

/////////////////////////////////////////////////////////////////////////////
// 
//  Class:
//
//  	CSmilFileFormat
//
//  Purpose:
//
//  	SMIL implementation of a basic file format.
//

class CSmilElement;
class CSmilPresentation;

class CSmilFileFormat :	public CHXBaseCountingObject,
                        public IHXPlugin, 
			public IHXFileFormatObject, 
			public IHXFileResponse,
			public IHXPendingStatus,
			public IHXInterruptSafe,
			public IHXThreadSafeMethods
{
private:
    LONG32			m_lRefCount;
    IUnknown*			m_pContext;
    IHXFileObject*		m_pFileObject;
    IHXFormatResponse*		m_pFFResponse;
    BOOL			m_bHeaderSent;
    BOOL			m_bChannelInit;
    BOOL			m_bSentFirstChannel;
    BOOL			m_bSourceInit;
    
    BOOL			m_bLogErrors;
    
    UINT32			m_ulCurrentTime;
    IHXRequest*		m_pRequest;
    IHXCommonClassFactory*	m_pCommonClassFactory;
    
    struct PacketData
    {
	IHXBuffer* pBuffer;
	// position in buffer to insert total number of packets.
	// there will be a 6 0's space for the number...
	char*	    pNumPos;  
    };

    enum FileState
    {
	InContent, InCDATA, InDTD, InDTDMarkup, InTagName, InTag, 
	InBeginAttributeName, InAttributeName, InEndAttributeName,
	InBeginAttributeValue, InAttributeValue, InComment
    } m_fileState;

    enum SMILFileVersion
    {
	// /These are for when *no* default namespace is declared:
	SMILFileVersionSmilBeta10, SMILFileVersionSmil10,
	// /For when actual SMIL 1.0 default namespace is declared.
	SMILFileVersionSmil10Strict,
	// /For pre-rec  (e.g., CR and PR) namespaces:
	SMILFileVersionSmil20PreRec,
	SMILFileVersionSmil20, SMILFileVersionUnknown
    } m_smilFileVersion;

    char			m_cQuote;

    PacketData*			m_pCurrentPacketData;
    UINT32			m_ulCurrentBufferPos;
    CHXPtrArray*		m_pArrayOfPackets;

    UINT32			m_ulPacketCount;
    UINT32			m_ulCurrentPacket;

    UINT32			m_ulStreamVersion;
    UINT32			m_ulContentVersion;

    IHXBuffer*			m_pStartOfFile;

    typedef enum
    {
	Ready, InitPending, ReadPending, GetStreamHeaderSeekPending,
	GetStreamHeaderReadPending, GetPacketSeekPending, GetPacketReadPending
    }
    SmilState;

    SmilState			m_state;

    static const char* const	zm_pDescription;
    static const char* const	zm_pCopyright;
    static const char* const	zm_pMoreInfoURL;

    static const char* const	zm_pFileMimeTypes[];
    static const char* const	zm_pStreamMimeTypes[];
    static const char* const	zm_pFileExtensions[];
    static const char* const	zm_pFileOpenNames[];

    // /This parses the start of the file and looks for a namespace or
    // namespaces and, from them, determines the "file version":
    HX_RESULT GetSMILFileVersion();

    HX_RESULT BreakUpBuffer(IHXBuffer* pBuffer);
    HX_RESULT UpdateErrorCaching();
    HX_RESULT ReportError(HX_RESULT errID, const char* errStr);

    ~CSmilFileFormat();

    PRIVATE_DESTRUCTORS_ARE_NOT_A_CRIME

public:
    CSmilFileFormat();

    // *** IUnknown methods ***
    STDMETHOD(QueryInterface)	(THIS_
				REFIID riid,
				void** ppvObj);

    STDMETHOD_(ULONG32,AddRef)	(THIS);

    STDMETHOD_(ULONG32,Release)	(THIS);

    // *** IHXPlugin methods ***

    /************************************************************************
     *	Method:
     *	    IHXPlugin::GetPluginInfo
     *	Purpose:
     *	    Returns the basic information about this plugin. Including:
     *
     *	    bLoadMultiple	whether or not this plugin DLL can be loaded
     *				multiple times. All File Formats must set
     *				this value to TRUE.
     *	    pDescription	which is used in about UIs (can be NULL)
     *	    pCopyright		which is used in about UIs (can be NULL)
     *	    pMoreInfoURL	which is used in about UIs (can be NULL)
     */
    STDMETHOD(GetPluginInfo)	(THIS_
				REF(BOOL)	 /*OUT*/ bLoadMultiple,
				REF(const char*) /*OUT*/ pDescription,
				REF(const char*) /*OUT*/ pCopyright,
				REF(const char*) /*OUT*/ pMoreInfoURL,
				REF(ULONG32)	 /*OUT*/ ulVersionNumber
				);

    /************************************************************************
     *	Method:
     *	    IHXPlugin::InitPlugin
     *	Purpose:
     *	    Initializes the plugin for use. This interface must always be
     *	    called before any other method is called. This is primarily needed 
     *	    so that the plugin can have access to the context for creation of
     *	    IHXBuffers and IMalloc.
     */
    STDMETHOD(InitPlugin)   (THIS_
			    IUnknown*   /*IN*/  pContext);

    // *** IHXFileFormatObject methods ***

    /************************************************************************
     *	Method:
     *	    IHXFileFormatObject::GetFileFormatInfo
     *	Purpose:
     *	    Returns information vital to the instantiation of file format 
     *	    plugins.
     */
    STDMETHOD(GetFileFormatInfo)    
				(THIS_
				REF(const char**) /*OUT*/ pFileMimeTypes,
				REF(const char**) /*OUT*/ pFileExtensions,
				REF(const char**) /*OUT*/ pFileOpenNames);

    /************************************************************************
     *	Method:
     *	    IHXFileFormatObject::InitFileFormat
     *	Purpose:
     *	    Initializes the File Format aspects of the plugin.
     *	    plugins.
     */
    STDMETHOD(InitFileFormat)	
			(THIS_
			IHXRequest*		/*IN*/	pRequest, 
			IHXFormatResponse*	/*IN*/	pFormatResponse,
			IHXFileObject*	/*IN*/  pFileObject);

    STDMETHOD(Close)		(THIS);

    /////////////////////////////////////////////////////////////////////////
    //  Method:
    //  	IHXFileFormatObject::GetFileHeader
    //  Purpose:
    //  	Called by controller to ask the file format for the number of
    //  	headers in the file. The file format should call the 
    //  	IHXFileFormatSession::StreamCountReady() for the IHXFileFormat-
    //  	Session object that was passed in during initialization, when the
    //  	header count is available.
    //
    STDMETHOD(GetFileHeader)	(THIS);

    /////////////////////////////////////////////////////////////////////////
    //  Method:
    //  	IHXFileFormatObject::GetStreamHeader
    //  Purpose:
    //  	Called by controller to ask the file format for the header for
    //  	a particular stream in the file. The file format should call 
    //  	IHXFileFormatSession::StreamHeaderReady() for the IHXFileFormatSession
    //  	object that was passed in during initialization, when the header
    //  	is available.
    //
    STDMETHOD(GetStreamHeader)	(THIS_
				UINT16		unStreamNumber);

    /////////////////////////////////////////////////////////////////////////
    //  Method:
    //  	IHXFileFormatObject::GetPacket
    //  Purpose:
    //  	Called by controller to ask the file format for the next packet
    //  	for a particular stream in the file. The file format should call 
    //  	IHXFileFormatSession::PacketReady() for the IHXFileFormatSession
    //  	object that was passed in during initialization, when the packet
    //  	is available.
    //
    STDMETHOD(GetPacket)	(THIS_
				UINT16		unStreamNumber);

    /////////////////////////////////////////////////////////////////////////
    //  Method:
    //  	IHXFileFormatObject::Seek
    //  Purpose:
    //  	Called by controller to tell the file format to seek to the 
    //  	nearest packet to the requested offset. The file format should 
    //  	call IHXFileFormatSession::SeekDone() for the IHXFileFormat-
    //  	Session object that was passed in during initialization, when 
    //  	the seek has completed.
    //
    STDMETHOD(Seek)		(THIS_
				ULONG32		ulOffset);

    // *** IHXFileResponse methods ***

    /////////////////////////////////////////////////////////////////////////
    //  Method:
    //    IHXFileResponse::InitDone
    //  Purpose:
    //    Notification interface provided by users of the IHXFileObject
    //    interface. This method is called by the IHXFileObject when the
    //    initialization of the file is complete, and the Mime type is
    //    available for the request file. If the URL is not valid for the
    //    file system, the status HXR_FAILED should be returned,
    //    with a mime type of NULL. If the URL is valid but the mime type
    //    is unknown, then the status HXR_OK should be returned with
    //    a mime type of NULL.
    //
    STDMETHOD(InitDone)	    (THIS_
			    HX_RESULT	    status);

    /////////////////////////////////////////////////////////////////////////
    //  Method:
    //  	IHXFileResponse::CloseDone
    //  Purpose:
    //  	Notification interface provided by users of the IHXFileObject
    //  	interface. This method is called by the IHXFileObject when the
    //  	close of the file is complete.
    //
    STDMETHOD(CloseDone)	(THIS_
				HX_RESULT	status);

    /////////////////////////////////////////////////////////////////////////
    //  Method:
    //  	IHXFileResponse::ReadDone
    //  Purpose:
    //  	Notification interface provided by users of the IHXFileObject
    //  	interface. This method is called by the IHXFileObject when the
    //  	last read from the file is complete and a buffer is available.
    //
    STDMETHOD(ReadDone)		(THIS_ 
				HX_RESULT	    status,
				IHXBuffer*	    pBuffer);

    /////////////////////////////////////////////////////////////////////////
    //  Method:
    //  	IHXFileResponse::WriteDone
    //  Purpose:
    //  	Notification interface provided by users of the IHXFileObject
    //  	interface. This method is called by the IHXFileObject when the
    //  	last write to the file is complete.
    //
    STDMETHOD(WriteDone)	(THIS_ 
				HX_RESULT	    status);

    /////////////////////////////////////////////////////////////////////////
    //  Method:
    //  	IHXFileResponse::SeekDone
    //  Purpose:
    //  	Notification interface provided by users of the IHXFileObject
    //  	interface. This method is called by the IHXFileObject when the
    //  	last seek in the file is complete.
    //
    STDMETHOD(SeekDone)		(THIS_ 
				HX_RESULT	    status);


    // IHXPendingStatus methods

    /************************************************************************
     *	Method:
     *	    IHXPendingStatus::GetStatus
     *	Purpose:
     *	    Called by the user to get the current pending status from an object
     */
    STDMETHOD(GetStatus)	(THIS_
				REF(UINT16) uStatusCode, 
				REF(IHXBuffer*) pStatusDesc, 
				REF(UINT16) ulPercentDone);

    /*
     *	IHXInterruptSafe methods
     */

    /************************************************************************
     *	Method:
     *	    IHXInterruptSafe::IsInterruptSafe
     *	Purpose:
     *	    This is the function that will be called to determine if
     *	    interrupt time execution is supported.
     */
    STDMETHOD_(BOOL,IsInterruptSafe)	(THIS) 
    					{ return TRUE; };

    /************************************************************************
     *	Method:
     *	    IHXThreadSafeMethods::IsThreadSafe
     */
    STDMETHOD_(UINT32, IsThreadSafe)	(THIS);
};

#endif // _SMLFFPLN_H_
