/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: rt_string.cpp,v 1.1.2.1 2004/07/09 01:50:20 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

/////////////////////////////////////////////////////////////////////////////
//
//  RT_STRING.CPP
//
//  Functions:
//	
//  (1) _CHAR* stringCopy(
//		_CHAR* pDest,
//		const _CHAR* pSrc,
//		ULONG32 srcLen)
//	//does same as strcpy(); handles different versions of _CHAR.
//
//  (2)	_CHAR* stringAppend(
//		_CHAR* pDest,
//		ULONG32 dest_strlen,
//		const _CHAR* pSrc,
//		ULONG32 srcLen)
//	//does same as strcpy(); handles different versions of _CHAR.
//
//  (3) INT16 stringCompare(
//		const _CHAR* pStr1,
//		ULONG32 str1Len, 
//		const _CHAR* pStr2,
//		ULONG32 str2Len);
//	//does same as strcmp(); handles different versions of _CHAR.
//
//
//  Plain text augmentation:
//
//  (1) Implements in-SMIL2.0-(and-higher)-param-settable values for plain
//  text.  These are:
//
//  <> wordWrap  (default is "true")
//  <> expandTabs  (default is "true")
//  <> horizAlign (default is "left")
//  <> vertAlign (default is "top")
//  <> direction (default is "ltr" for all charsets, even Arabic (iso-8859-6)
//     and Hebrew (iso-8859-8) whose characters are drawn r-to-l regardless
//     of the "direction" setting, but embedded non-Arabic/Hebrew words do
//     pay attention to the "direction" setting).
//  <> fontPtSize (default is 16)
//  <> fontFace A.K.A. fontname (default is system default font)
//  <> fontColor (default is black)
//  <> fontBackgroundColor (bounding box of each char; default is transparent)
//  <> backgroundColor (whole window; default is white)
//  <> escapementAngle (default is 0.0) - for rotating text (needed
//     for formal Chinese & Japanese writing where each line is shown top-down)
//  <> charAngle (default is 0.0) - for rotating characters (needed
//     for formal Chinese & Japanese writing where each line is shown top-down
//     but each character is *not* rotated along w/the base line (escapement))
//  <> charset (default is system default character set)
//     allowed values are:
//     - iso-8859-1 (Western European),
//     - iso-8859-2 (Eastern European),
//     - iso-8859-5 (Cyrillic (Russian+),
//     - iso-8859-6 (Arabic),
//     - iso-8859-7 (Greek),
//     - iso-8859-8 (Hebrew),
//     - iso-8859-9 (Turkish),
//     - iso-8859-11 (Thai),
//     - iso-8859-13 (Baltic (Latvian, Estonian, +...)),
//     - us-ascii,
//     - mac-roman (Macinstosh),
//     - x-sjis (Japanese),
//     - hangeul (Korean),
//     - ksc5601 (same as hangeul),
//     - johab (Korean),
//     - big5 (Traditional Chinese),
//     - gb2312 (Simplified Chinese),
//     - windows-1251 (Cyrillic),
//     - koi8-r (Cyrillic)
//     - iso-ir-166 (Thai)
//
//  (2) Allows for user-defined text sizing, where player registry
//  can contain "font-size" key in preferences and value can be one of:
//  "smaller"  ;relative sizing - reduces every font size by 20%
//  "larger"   ;relative sizing - increases every font size by 20%
//  "xx-small" ;absolute sizing - all 7 of these (below) override authored size
//  "x-small"
//  "small"
//  "medium"
//  "large"
//  "x-large"
//  "xx-large"
//
//


#include "hxtypes.h"
#include "rt_types.h" //for _CHAR, RED_GREEN_OR_BLUE, COLORTYPE

#include "rt_string.h"

/*  For strcpy(), strcat(), and strcmp() (if _CHAR is one byte),
 * or memmove() and memcmp() (if _CHAR is multi-byte):  */
#include <string.h>

#include "hxheap.h"
#ifdef _DEBUG
#undef HX_THIS_FILE		
static char HX_THIS_FILE[] = __FILE__;
#endif


_CHAR* stringCopy(_CHAR* pDest, const _CHAR* pSrc, ULONG32 srcLen)
{
    //changed code to handle DBCS chars, and
    // commented out the old code:
    memmove(pDest, pSrc, srcLen);
    pDest[srcLen] = '\0';
    return pDest;
}



_CHAR* stringAppend(_CHAR* pDest, ULONG32 dest_strlen,
	const _CHAR* pSrc, ULONG32 srcLen)
{
    //changed code to handle DBCS chars, and
    // commented out the old code:
    memmove(&pDest[dest_strlen], pSrc, srcLen);
    pDest[dest_strlen+srcLen] = '\0';
    return pDest;
}



INT16 stringCompare(const _CHAR* pStr1, ULONG32 str1Len, 
	const _CHAR* pStr2, ULONG32 str2Len)
{
    //changed code to handle DBCS chars, and
    // commented out the old code:
    ULONG32 minLen = str1Len;
    BOOL bSameLen = (str1Len == str2Len);
    if(str1Len > str2Len)
    {
	minLen = str2Len;
    }
    INT16 retval = memcmp(pStr1, pStr2, minLen);
    if(0 == retval  &&  bSameLen) 
    {
	return 0; //they are identical.
    }
    else if(0 == retval)//are equal up to minLen, so longer is who's greater:
    {
	return (str1Len < str2Len? -1:1);
    }
    else  //are not
    {
	return retval;
    }
}



