#include <memory.h>
#include <stdlib.h>
#include <stdio.h>
#include "HXClientCFuncs.h"
#include "HXClientCallbacks.h"
#include "HXClientConstants.h"



void
OnVisualStateChanged(void* userInfo, bool hasVisualContent)
{
}


void
OnIdealSizeChanged(void* userInfo, SInt32 idealWidth, SInt32 idealHeight)
{
}


void
OnLengthChanged(void* userInfo, UInt32 length)
{
}


void
OnTitleChanged(void* userInfo, const char* pTitle)
{
}


void
OnGroupsChanged(void* userInfo)
{
}


void
OnGroupStarted(void* userInfo, UInt16 groupIndex)
{
}


void
OnContacting(void* userInfo, const char* pHostName)
{
}


void
OnBuffering(void* userInfo, UInt32 bufferingReason, UInt16 bufferPercent)
{
}

void
OnContentConcluded(void* userInfo)
{
}

void
OnContentStateChanged(void* userInfo, int oldContentState, int newContentState)
{
    switch (newContentState)
    {
	case kContentStateNotLoaded:
	{
	}
	break;
	
	case kContentStateLoading:
	{
	}
	break;
	
	case kContentStateStopped:
	{
	}
	break;
	
	case kContentStatePlaying:
	{
	}
	break;
	
	case kContentStatePaused:
	{
	}
	break;

	default:
	{
	    // unsupported!
	}
	break;
    }
}


void
OnStatusChanged(void* userInfo, const char* pStatus)
{
}


void
OnVolumeChanged(void* userInfo, UInt16 volume)
{
}


void
OnMuteChanged(void* userInfo, bool hasMuted)
{
}


void
OnClipBandwidthChanged(void* userInfo, SInt32 clipBandwidth)
{
}


void
OnErrorOccurred(void* userInfo, UInt32 hxCode, UInt32 userCode,
		const char* pErrorString, const char* pUserString,
		const char* pMoreInfoURL)
		
{
}


bool
GoToURL(void* userInfo, const char* pURL, const char* pTarget)
{
    return false;
}


bool
RequestAuthentication(void* userInfo, const char* pServer, const char* pRealm,
		      bool isProxyServer)
{
    return false;
}


bool
RequestUpgrade(void* userInfo, UInt32 numOfComponents,
	       const char* componentNames[], bool isBlocking)
{
    return false;
}


bool
HasComponent(void* userInfo, const char* componentName)
{
    return false;
}


typedef struct
{
    HXClientPlayerToken player;
    SHXClientWindow window;
    int state;
} PlayerInfo;


int
main(int argc, char* argv[])
{
    if (argc < 2)
    {
	printf("USAGE: testkit URL\n");
	return 0;
    }

    static const HXClientCallbacks kCallbacks =
    {
        OnVisualStateChanged,
        OnIdealSizeChanged,
        OnLengthChanged,
        OnTitleChanged,
        OnGroupsChanged,
        OnGroupStarted,
        OnContacting,
        OnBuffering,
        OnContentStateChanged,
        OnContentConcluded,
        OnStatusChanged,
        OnVolumeChanged,
        OnMuteChanged,
        OnClipBandwidthChanged,
        OnErrorOccurred,
        GoToURL,
        RequestAuthentication,
        RequestUpgrade,
        HasComponent
    };

    const char* pURL = argv[1];

    PlayerInfo info;
    memset(&info, 0, sizeof(info));

    if (ClientPlayerCreate(&info.player, &info.window, &info, &kCallbacks))
    {
	ClientPlayerOpenURL(info.player, pURL, NULL);

	do
	{
#ifdef _MAC
	    // todo: pump a message to the mac client engine
#elif _UNIX
	    ClientEngineProcessXEvent(NULL);
#endif
	}
	while (info.state);
	
	ClientPlayerClose(info.player);
    }

    return 0;
}
