/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: windraw2.h,v 1.5.20.1 2004/07/09 01:58:48 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef __WINDRAW2_H__
#define __WINDRAW2_H__   1

// forward declaration
struct CModesDesc;

/*
 * Just a more accurately defined BITMAPINFO structure:
 */
typedef struct tagBMI
{
    BITMAPINFOHEADER bmiHeader;         /* bitmap info header               */
    union {
        DWORD   dwBitMask [3];          /* color masks (for BI_BITFIELDS)   */
        DWORD   dwPalette [256];        /* palette (for 8-bit mode)         */
    };
} BMI, *PBMI, FAR *LPBMI;

#include "hxslist.h"
//#include "baseroot.h"
#include "basesurf.h"
#include "ddraw.h"

_INTERFACE IHXErrorMessages;

/*
 * Same for Windows' LOGPALETTE:
 */
typedef struct tagLOGPAL
{
    WORD         palVersion;            /* palette version                  */
    WORD         palNumEntries;         /* # of colors used                 */
    PALETTEENTRY palPalEntry [256];     /* palette colors                   */

} LOGPAL, *PLOGPAL, FAR *LPLOGPAL;

/*
 * Information we will need to work with each GDI DIB.
 */
typedef struct tagGDISURFACE
{
    DIBSECTION  DibSection;             /* details of DIB section allocated */
    HBITMAP     hBitMap;                /* handle to bitmap for drawing     */
    HANDLE      hMapping;               /* handle to shared memory block    */
    LPBYTE      lpBase;                 /* pointer to base memory address   */
    LPBYTE	lpAlphaSurface;
    HANDLE      hEmpty;                 /* Is the buffer empty              */
} GDISURFACE, *LPGDISURFACE;

/*
 * WinDrawSurface flags:
 */
#define WINDRAWSURFACE_DIRECTDRAW       0x0001  /* GDI/DirectDraw engine?   */
#define WINDRAWSURFACE_OVERLAY          0x0002  /* is an overlay surface    */
#define WINDRAWSURFACE_COMPLEX          0x0004  /* has multiple buffers     */
#define WINDRAWSURFACE_VIDEOMEMORY      0x0008  /* surface is in video mem. */
#define WINDRAWSURFACE_NONLOCALVIDMEM   0x0010  /* surface resides in AGP   */
#define WINDRAWSURFACE_SYSTEMMEMORY     0x0020  /* surface resides in main memory */
#define WINDRAWSURFACE_DEFAULTMEMORY	0x0040	/* allow direct draw to do what it wants */

/* internal flags: */
#define WINDRAWSURFACE_OPENED           0x0100  /* surface has been created */

/*
 * Buffers in a flippable chain:
 */
#define MAX_BACKBUFFERCOUNT     3       /* max # of back buffers            */
#define FRONTBUFFER             0       /* index of the front buffer        */
#define BACKBUFFER              1       /* index of the first back buffer   */

 
 /*
 *  defines for asserts
 */

#define CID_NOTSUPPORTED 0
/*
 * Windraw surface:
 */

typedef struct tagENUMSURFACE
{
    LPDIRECTDRAWSURFACE lpSurface;
    BYTE                *pHwMemBuffer;
    HANDLE              hEmpty;
    double              dTimeAvailable;
} ENUMSURFACE;

typedef struct tagWINDRAWSURFACE
{
    /* buffer state: */
    DWORD       fMode;                  /* surface type/mode                */
    DWORD       dwBackBufferCount;      /* number of back buffers           */
    DWORD       dwFrontBuffer;          /* Offset in lpChain of front buffer*/
    DWORD       dwNextBuffer;           /* Next buffer in the chain         */
    HANDLE      hOverlayIndexMutex,     /* Index the flipping chaing        */
                hOverlayMutex;          /* Prevent flipping locked surfaces */

    /* surface format: */
    BMI         bmiSurfaceFormat;       /* surface geometry & pixel format  */
    int         cidSurfaceColor;        /* bitmap pixel format              */

    /* we should never need both GDI and DD working together: */
    union {
        /* GDI implementation: */
        struct {
            LONG         lPitch;        /* buffer pitch, <0 if bottom-up bmp*/
            //LPGDISURFACE lpGDISurface; /* front buffer                    */
            LPGDISURFACE lpGDIBackBuffer [MAX_BACKBUFFERCOUNT+1];
        } gdi;

        /* DirectDraw implementation: */
        struct {
            LPDIRECTDRAWPALETTE lpDDPal;        /* attached palette         */
            LPDIRECTDRAWSURFACE lpDDSurface;    /* main DD surface object   */
            LPDIRECTDRAWSURFACE lpDDBackBuffer; /* first back-buffer        */
            ENUMSURFACE         *lpChain;       /* flipping chain           */
            LONG                lPitch;         /* surface pitch            */
            HANDLE              hAbort;
            DDCOLORCONTROL      ddcc;
	    void*		lpSurfaceData;
        } dd;
    };

} WINDRAWSURFACE, *PWINDRAWSURFACE, FAR *LPWINDRAWSURFACE;

/*
 * WINDRAW mode:
 */
#define WINDRAW_DIRECTDRAW          0x0001  /* use DirectDraw engine        */
#define WINDRAW_FULLSCREEN          0x0002  /* switch in full screen mode   */
/* internal state flags: */
#define WINDRAW_OPENED              0x0100  /* sets by WinDraw2_Open ()      */
#define WINDRAW_PALETTE             0x0200  /* uses palette                 */
#define WINDRAW_DDCLIPPER           0x0400  /* uses DirectDraw clipper      */
#define WINDRAW_DDDESTCKEY          0x0800  /* uses destination color key   */
#define WINDRAW_RESIZING            0x1000  /* window in process of resizing*/
#define WINDRAW_REALIZING           0x2000  /* set when we realize palette  */
#define WINDRAW_REALIZEBACKGROUND   0x4000  /* realize pal-te in background */

/*
 * Blend modes
 */

#define BLEND_ONE_MINUS_SRC_ALPHA   0
#define BLEND_SRCCPY		    1

/*
 * The main WinDraw structure:
 */
typedef struct tagWINDRAW
{
    /* WinDraw state variables: */
    DWORD       fMode;                  /* WinDraw mode (WINDRAW_XXX flags) */
    HWND        hWnd;                   /* window handle to use             */
    HWND	m_hCurrentClipWindow;	/* the current clipper window	    */

    /* display parameters: */
    LPSTR       lpszDisplayDevice;      /* display device name              */
    BMI         bmiDisplayFormat;       /* display size, palette, etc.      */
    int         cidDisplayColor;        /* display color format ID          */

    /* logical palette to use with 8-bit displays: */
    LOGPAL      lgplDefaultPalette;     /* the entire 256-color palette     */
    int         loColor, hiColor;       /* the range of colors we need most */

    /* window size: */
    DWORD       dwWindowWidth;          /* current client area width        */
    DWORD       dwWindowHeight;         /* current client area height       */

    /* Four CC Codes supported: */
    DWORD	numCodes;
    LPDWORD	lpCodes;
    LPDWORD	lpCID;

    /* Monitor properties */
    DWORD       dwMaxScanLine;          /* number of horizontal lines       */
    DWORD       dwReportedHeight;       /* reported y resolution for filtering
                                        /* max scan line */
    double      dRefreshRate;           /* In hertz                         */
    double      dMsPerVBlank;
    UINT32      ulBadConsecutiveVblankCount;
    
    int         nSchedulerResolution;   /* In ms                            */       

    /* modes supported by video card */
    CHXSimpleList* m_pModesList;

    /* List of surfaces which were created with this windraw Object */
    CHXSimpleList* m_pSurfaceList;

    /* we should never have both GDI and DirectDraw working together:
     * the minimum of what we can expect DirectDraw to do is RGB blits
     * from offscreen surfaces without stretching; if it cannot do even this,
     * we will use GDI for all our needs. */
    union {

        /* GDI implementation: */
        struct {
            HDC         hDC;            /* device context for the window    */
            HDC         hMemoryDC;      /* context for GDI video buffers    */
            HDC         hMemoryDC2;     /* context for GDI video buffers    */
	    HBITMAP	hOldBitmap;	/* context for GDI video buffers    */
            HPALETTE    hPalette;       /* handle to the palette to use     */
        } gdi;

        /* DirectDraw implementation: */
        struct {
            HINSTANCE           hDD;            /* instance of DDRAW.DLL    */
            LPDIRECTDRAW	lpDD;           /* DDraw object             */
            LPDIRECTDRAW2       lpDD2;          /* DDraw2 object            */
            DDCAPS              ddCaps;         /* DDraw HW capabilities    */
            DDCAPS              ddHELCaps;      /* DDraw HEL capabilities   */
            LPDIRECTDRAWSURFACE lpDDSPrimary;   /* DDraw primary surface    */
            DDCOLORKEY          ddDestColorKey; /* destination color key    */
            LPDIRECTDRAWCLIPPER lpDDClipper;    /* clipper for primary surf */
            LPDIRECTDRAWPALETTE lpDDPal;        /* DDraw palette            */
	    DDCAPS		m_caps;		/* DDraw Caps		    */
        } dd;
    };

    CRITICAL_SECTION    csPrimary;      /* Protect the primary surface since
                                           vidsurf2 accesses it on multiple threads */
    IHXErrorMessages*  pErrMsg;        /* Means to pass exception errors   */

} WINDRAW, *PWINDRAW, FAR *LPWINDRAW;

HRESULT WindrawSurface_CreatePrimarySurface(LPWINDRAW lpwd);

/*
 * Initialize WinDraw engine.
 * Use:
 *  HRESULT WinDraw2_Open (LPWINDRAW lpwd, HWND hWnd, DWORD fMode,
 *      LPSTR lpszDisplay, LPBMI lpbiDisplayFormat);
 * Input:
 *  lpwd - pointer to a WINDRAW structure to initialize
 *  hWnd - a window handle to use
 *  fMode - WinDraw mode to set (e.g. WINDRAW_FULLSCREEN)
 *  lpszDisplay - monitor to use (NULL or zero string = use all monitors)
 *  lpbiDisplayFormat - preferred display mode in full screen
 * Returns:
 *  NOERROR if OK, or the last relevant DirectDraw error code, or E_FAIL.
 */
HRESULT WinDraw2_Open (LPWINDRAW lpwd, HWND hWnd, DWORD fMode,
    LPSTR lpszDisplay, LPBMI lpbiDisplayFormat);

/*
 * Get Description of all modes availiable on the system
 * Use:
 *  HRESULT WinDraw2_GetModes(LPWINDRAW lpwd, CModesDesc* pModesDesc, UINT32* nNumModes);
 * Input:
 *  lpwd - pointer to a WINDRAW engine to work with 
 *  pModesDesc - pointer to a block of memory into which the mode description data will 
 *		 be filled.
 *  nNumModes  - the number of elements which the pModesDesc can contain. If this is too small
 *		 then proper value will be placed within it.
 * Returns:
 *  NOERROR if OK, or E_FAIL.
 */

HRESULT WinDraw2_GetModes(LPWINDRAW lpwd, CModesDesc* pModesDesc, UINT32* nNumModes);

/*
 * Sets Windraw to DD exclusive and sets the display mode to what is specified (if availiable)
 * Use:
 *  HRESULT WinDraw2_SetResolution(LPWINDRAW lpwd, UINT32 width, UINT32 height, UINT32 depth);
 * Input:
 *  lpwd    - pointer to a WINDRAW engine to work with 
 *  width   - target width
 *  height  - target height
 *  depth   - target pixel depth
 *
 * Returns:
 *  NOERROR if OK, or E_FAIL.
 */
HRESULT WinDraw2_GetResolution(LPWINDRAW lpwd, UINT32* width, UINT32* height, UINT32* depth);
HRESULT WinDraw2_SetResolution(LPWINDRAW lpwd, UINT32 width, UINT32 height, UINT32 depth, HWND);
HRESULT WinDraw2_RestoreResolution(LPWINDRAW lpwd);
HRESULT WinDraw2_RestorePrimarySurface(LPWINDRAW lpwd);

/*
 * Close WinDraw library.
 * Use:
 *  HRESULT WinDrawClose (LPWINDRAW lpwd);
 * Input:
 *  lpwd - pointer to a WINDRAW engine to deactivate
 * Returns:
 *  NOERROR if OK, or E_FAIL.
 */
HRESULT WinDraw2_Close (LPWINDRAW lpwd);

/*
 * Handles Windows palette change messages.
 * Use:
 *  LRESULT WinDraw2_OnPaletteChange (LPWINDRAW lpwd, HWND hwnd, UINT Message);
 * Input:
 *  lpwd - pointer to a WINDRAW structure we work with
 *  hwnd - with WM_PALETTECHANGED: identifies a window that CAUSED the
 *         palette to change; window that received a message otherwise
 *  Message - either WM_QUERYNEWPALETTE or WM_PALETTECHANGED
 * Returns:
 *  TRUE, if we do realise our palette; FALSE, otherwise.
 */
LRESULT WinDraw2_OnPaletteChange (LPWINDRAW lpwd, HWND hwnd, UINT Message);

/*
 * Get display/primary surface format.
 * Use:
 *  HRESULT WinDraw2_GetDisplayFormat (LPWINDRAW lpwd, LPBMI lpbiDisplayFormat);
 * Input:
 *  lpwd - pointer to a WINDRAW structure to initialize
 *  lpbiDisplayFormat - a structure to contain display format
 * Returns:
 *  NOERROR if OK, or the last relevant DirectDraw error code, or E_FAIL.
 */
HRESULT WinDraw2_GetDisplayFormat (LPWINDRAW lpwd, LPBMI lpbiDisplayFormat);

/*
 * Creates a new surface to be used for image data.
 * Use:
 *   HRESULT WinDraw2_CreateSurface (LPWINDRAW lpwd, LPWINDRAWSURFACE lpwds,
 *      LPBMI lpImageFormat, DWORD fSurfaceType, int nBackBuffers, DWORD dwCKey);
 * Input:
 *  lpwd - pointer to a base WINDRAW structure
 *  lpwds - pointer to a WINDRAWSURFACE structure to initialize
 *  lpImageFormat - pointer to BITMAPINFO structure describing image format
 *  fSurfaceType - combination of desired properties for a surface
 *  nBackBuffers - number of flippable backbuffers to allocate for this surface
 *  dwCKey - a color key to use (if transparent surface)
 * Returns:
 *  NOERROR if OK, or the last relevant DirectDraw error code, or E_FAIL.
 */
HRESULT WinDraw2_CreateSurface (LPWINDRAW lpwd, LPWINDRAWSURFACE lpwds,
    LPBMI lpImageFormat, DWORD fSurfaceType, int nBackBuffers, DWORD dwCKey);

HRESULT WinDraw2_SetColorKey (LPWINDRAW lpwd, DWORD dwLowColor, DWORD dwHighColor);
HRESULT WinDraw2_SetOverlayPosition(LPWINDRAW lpwd, LPWINDRAWSURFACE lpwds, UINT32 x, UINT32 y);
HRESULT WinDraw2_UpdateOverlay(LPWINDRAW lpwd, LPWINDRAWSURFACE lpwds, RECT* pDestRect, RECT* pSrcRect, DWORD flags);
HRESULT Windraw_GetCaps(LPWINDRAW lpwd, UINT32* pfSurfaceCaps, UINT32* xMin, UINT32* yMin);
HRESULT WinDraw2_GetOverlayPosition(LPWINDRAW lpwd, LPWINDRAWSURFACE lpwds, POINT* pLocation);
BOOL	WinDraw2_IsSurfaceVisible(LPWINDRAW lpwd, LPWINDRAWSURFACE lpwds);
BOOL	WinDraw2_IsDDAvailable(LPWINDRAW lpwd);
int     Windraw_ColorMatch(LPWINDRAW lpwd, COLORREF color);
int     Windraw_GetLowestColor(LPWINDRAW lpwd);
HRESULT	WinDraw2_GetColorspacePriorities(int cidIn, int *pCPList, int &nSize);
HRESULT WinDraw2_GetScanLine(LPWINDRAW lpwd, DWORD* pdwScanLine);

/*
 * Blits one secondary surface to another.
 * Use:
 *  HRESULT Windraw_AttachSurface(LPWINDRAW lpwd, LPWINDRAWSURFACE lpwds, 
 *  BITMAPINFOHEADER* lpImageFormat, void* pImageData);
 *
 * Input:
 *  lpwd	    - pointer to a base WINDRAW structure
 *  lpwds	    - pointer to a WINDRAWSURFACE structure to initialize
 *  lpImageFormat   - pointer to BITMAPINFOHEADER structure describing image format
 *  pImageData	    - pointer to the image data
 * Returns:
 *  NOERROR if OK, or the last relevant DirectDraw error code, or E_FAIL.
 */
HRESULT Windraw_AttachSurface(LPWINDRAW lpwd, LPWINDRAWSURFACE lpwds,
    BITMAPINFOHEADER* lpImageFormat, void* pImageData);
    
/*
 * Adds alpha data to a specified surface.
 * Use:
 *   HRESULT WinDraw2_AttachAlphaSurface (LPWINDRAW lpwd, LPWINDRAWSURFACE lpwds,
 *    UCHAR* pAlphaData);
 * Input:
 *  lpwd	- pointer to a base WINDRAW structure
 *  lpwds	- pointer to a WINDRAWSURFACE structure to initialize
 * Returns:
 *  NOERROR if OK, or the last relevant DirectDraw error code, or E_FAIL.
 */
HRESULT WinDraw2_CreateAlphaSurface(LPWINDRAW lpwd, LPWINDRAWSURFACE lpwds);
  
/*
 * Gets the alpha data for the specified surface.
 * Use:
 *   HRESULT WinDraw2_AttachAlphaSurface (LPWINDRAW lpwd, LPWINDRAWSURFACE lpwds,
 *    UCHAR* pAlphaData);
 * Input:
 *  lpwd	- pointer to a base WINDRAW structure
 *  lpwds	- pointer to a WINDRAWSURFACE structure to initialize
 *  pSurface	- pointer to receive the data.
 * Returns:
 *  NOERROR if OK, or the last relevant DirectDraw error code, or E_FAIL.
 */
HRESULT WinDraw2_GetAlphaSurface(LPWINDRAW lpwd, LPWINDRAWSURFACE lpwds, UCHAR** pSurface);
  
/*
 * Releases a surface.
 * Use:
 *  HRESULT WinDraw2_ReleaseSurface (LPWINDRAW lpwd, LPWINDRAWSURFACE lpwds);
 * Input:
 *  lpwd - pointer to a base WINDRAW structure
 *  lpwds - pointer to a WINDRAWSURFACE structure to release
 * Returns:
 *  NOERROR if OK, or the last relevant DirectDraw error code, or E_FAIL.
 */
HRESULT WinDraw2_ReleaseSurface (LPWINDRAW lpwd, LPWINDRAWSURFACE lpwds);

/*
 * Obtains refresh rate, ms per vblank, and max scan line of the monitor
 * Use:
 *  HRESULT WinDraw2_GetMonitorProperties (LPWINDRAW lpwd);
 * Input:
 *  lpwd - pointer to a base WINDRAW structure
 * Returns:
 *  NOERROR if OK, or the last relevant DirectDraw error code, or E_FAIL.
 */

HRESULT WinDraw2_GetMonitorProperties (LPWINDRAW lpwd);

/*
 * Get WinDrawSurface capabilities.
 * Use:
 *  HRESULT WinDrawSurface_GetCaps (LPWINDRAW lpwd, LPWINDRAWSURFACE lpwds,
 *      DWORD *lpdwCaps);
 * Input:
 *  lpwd - pointer to a WINDRAW structure to query
 *  lpwds - pointer to a WINDRAWSURFACE structure to query
 *  lpdwCaps - a variable to contain WinDrawSurface capabilities
 * Returns:
 *  NOERROR if OK, or the last relevant DirectDraw error code, or E_FAIL.
 */
HRESULT WinDrawSurface_GetCaps (LPWINDRAW lpwd, LPWINDRAWSURFACE lpwds,
    DWORD *lpdwCaps);

/*
 * Get WinDrawSurface format.
 * Use:
 *  HRESULT WinDrawSurface_GetFormat (LPWINDRAW lpwd, LPWINDRAWSURFACE lpwds,
 *      LPBMI lpbiSurfaceFormat);
 * Input:
 *  lpwd - pointer to a WINDRAW structure to query
 *  lpwds - pointer to a WINDRAWSURFACE structure to query
 *  lpbiFormat - a structure to contain surface resolution and color format
 * Returns:
 *  NOERROR if OK, or the last relevant DirectDraw error code, or E_FAIL.
 */
HRESULT WinDrawSurface_GetFormat (LPWINDRAW lpwd, LPWINDRAWSURFACE lpwds,
    LPBMI lpbiSurfaceFormat);

/*
 * Locks pointer to a buffer.
 * Use:
 *  HRESULT WinDrawSurface_Lock (LPWINDRAW lpwd, LPWINDRAWSURFACE lpwds,
 *      int nBufferNo, LPVOID *lpSurfPtr, LONG  *lplSurfPitch);
 * Input:
 *  lpwd - pointer to a base WINDRAW structure
 *  lpwds - pointer to a WINDRAWSURFACE structure to lock
 *  nBufferNo - # of the surface buffer to lock
 *  lpSurfPtr - a variable to contain a base pointer to the surface's data
 *  lplSurfPitch - a variable to contain the pitch of the surface
 * Returns:
 *  NOERROR if OK, or the last relevant DirectDraw error code, or E_FAIL.
 * Notes:
 * This functions shall be called before copying data into the surface.
 * Unlock it as soon as you are done with moving data in!!!
 */
HRESULT WinDrawSurface_Lock (LPWINDRAW lpwd, LPWINDRAWSURFACE lpwds,
    int nBufferNo, LPVOID *lpSurfPtr, LONG  *lplSurfPitch);

/*
 * Unlocks the buffer.
 * Use:
 *  HRESULT WinDrawSurface_Lock (LPWINDRAW lpwd, LPWINDRAWSURFACE lpwds,
 *      int nBufferNo, LPVOID *lpSurfPtr, LONG  *lplSurfPitch);
 * Input:
 *  lpwd - pointer to a base WINDRAW structure
 *  lpwds - pointer to a WINDRAWSURFACE structure to unlock
 *  nBufferNo - # of the surface buffer to unlock
 * Returns:
 *  NOERROR if OK, or the last relevant DirectDraw error code, or E_FAIL.
 */
HRESULT WinDrawSurface_Unlock (LPWINDRAW lpwd, LPWINDRAWSURFACE lpwds,
    int nBufferNo);

/*
 * Gives a DC to the surface.
 * Use:
 *  HRESULT WinDrawSurface_GetDC(LPWINDRAW lpwd, LPWINDRAWSURFACE lpwds,
 *      HDC* pDC);
 * Input:
 *  lpwd    - pointer to a base WINDRAW structure
 *  lpwds   - pointer to a WINDRAWSURFACE structure to unlock
 *  HDC*    - pointer to a DC which will be created.
 * Returns:
 *  NOERROR if OK, or the last relevant DirectDraw error code, or E_FAIL.
 */
HRESULT WinDrawSurface_GetDC(LPWINDRAW lpwd, LPWINDRAWSURFACE lpwds,
    HDC* pDC);

/*
 * Releases a DC obtained by WinDrawSurface_GetDC
 * Use:
 *  HRESULT WinDrawSurface_ReleaseDC(LPWINDRAW lpwd, LPWINDRAWSURFACE lpwds,
 *      HDC pDC);
 * Input:
 *  lpwd    - pointer to a base WINDRAW structure
 *  lpwds   - pointer to a WINDRAWSURFACE structure to unlock
 *  HDC     - pointer to a DC which is to be released.
 * Returns:
 *  NOERROR if OK, or the last relevant DirectDraw error code, or E_FAIL.
 */
HRESULT WinDrawSurface_ReleaseDC(LPWINDRAW lpwd, LPWINDRAWSURFACE lpwds,
    HDC pDC);
    
/*
 * Blits the surface data to the screen (primary surface).
 * Use:
 *  HRESULT WinDrawSurface_Blt (LPWINDRAW lpwd, LPWINDRAWSURFACE lpwds,
 *      LPRECT lpDestRect, LPRECT lpSrcRect);
 * Input:
 *  lpwd - pointer to a base WINDRAW structure
 *  lpwds - pointer to a WINDRAWSURFACE structure containing data to blit
 *  lpDestRect - rectangle on the primary surface to be blitted to
 *  lpSrcRect - rectangle on the source surface to be blitted from
 *  nGdiBuffer - the index of the gdi buffer to blt
 * Returns:
 *  NOERROR if OK, or the last relevant DirectDraw error code, or E_FAIL.
 */
HRESULT WinDrawSurface_Blt (LPWINDRAW lpwd, LPWINDRAWSURFACE lpwds,
    LPRECT lpDestRect, LPRECT lpSrcRect, int nGdiBufferNo=FRONTBUFFER);

/*
 * Blits one secondary surface to another.
 * Use:
 *  HRESULT WinDrawSurface_BltIndirect (LPWINDRAW lpwd,
 *      LPWINDRAWSURFACE lpwdsDestSurf, LPWINDRAWSURFACE lpwdsSrcSurf,
 *      LPRECT lpDestRect, LPRECT lpSrcRect);
 * Input:
 *  lpwd - pointer to a base WINDRAW structure
 *  lpwdsDestSurf - pointer to a destination WINDRAW structure
 *  lpwdsSrcSurf - pointer to a source WINDRAW structure
 *  lpDestRect - rectangle on the primary surface to be blitted to
 *  lpSrcRect - rectangle on the source surface to be blitted from
 *  nGdiBuffer - the index of the gdi buffer to blt
 * Returns:
 *  NOERROR if OK, or the last relevant DirectDraw error code, or E_FAIL.
 */
HRESULT WinDrawSurface_BltIndirect (LPWINDRAW lpwd,
    LPWINDRAWSURFACE lpwdsDestSurf, LPWINDRAWSURFACE lpwdsSrcSurf,
    LPRECT lpDestRect, LPRECT lpSrcRect, int nGdiBufferNo=FRONTBUFFER);

/*
 * Flips buffers in a complex surface.
 * Use:
 *  HRESULT WinDrawSurface_Flip (LPWINDRAW lpwd, LPWINDRAWSURFACE lpwds);
 * Input:
 *  lpwd - pointer to a base WINDRAW structure
 *  lpwds - pointer to a surface to be flipped
 * Returns:
 *  NOERROR if OK, or the last relevant DirectDraw error code, or E_FAIL.
 */
HRESULT WinDrawSurface_Flip (LPWINDRAW lpwd, LPWINDRAWSURFACE lpwds);

/*
 * Updates a surface's state/position.
 * Use:
 *  HRESULT WinDrawSurface_Update (LPWINDRAW lpwd, LPWINDRAWSURFACE lpwds,
 *     LPRECT lpDestRect, LPRECT lpSrcRect, BOOL bShow);
 * Input:
 *  lpwd - pointer to a base WINDRAW structure
 *  lpwds - pointer to a WINDRAWSURFACE to update
 *  lpDestRect - rectangle on the primary surface
 *     where secondary surface (overlay) is mapped
 *  lpSrcRect - rectangle on the source surface to be mapped
 *  bShow - 1, to make secondary surface visible; 0, to hide it
 * Returns:
 *  NOERROR if OK, or the last relevant DirectDraw error code, or E_FAIL.
 */
HRESULT WinDrawSurface_Update (LPWINDRAW lpwd, LPWINDRAWSURFACE lpwds,
    LPRECT lpDestRect, LPRECT lpSrcRect, BOOL bShow);

/*
 * Updates the window that the clipper should use
 * Use:
 *  HRESULT WinDrawSurface_Clipper(LPWINDRAW lpwd, HWND hwnd);
 * Input:
 *  lpwd - pointer to a base WINDRAW structure
 *  hwnd - the window that the clipper should be set to
 * Returns:
 *  NOERROR if OK, or the last relevant DirectDraw error code, or E_FAIL.
 */

HRESULT WinDrawSurface_SetClipper(LPWINDRAW lpwd, HWND hwnd);

/*
 * Returns the window to which the clipper is currently set.
 * Use:
 *  HRESULT WinDrawSurface_GetClipperWindow(LPWINDRAW lpwd, HWND* pHwnd);
 * Input:
 *  lpwd - pointer to a base WINDRAW structure
 *  phwnd - is fulled with the current window to which the clipper is set.
 * Returns:
 *  NOERROR if OK, or the last relevant DirectDraw error code, or E_FAIL.
 */

HRESULT WinDrawSurface_GetClipperWindow(LPWINDRAW lpwd, HWND* pHwnd);


/*
 * Sets the color controls for a given surface
 * Use:
 *  HRESULT WinDrawSurface_GetColorControls(LPWINDRAW lpwd, LPWINDRAWSURFACE lpwds, 
 *   float &fBright, float &fContrast, float &fSaturation, 
 *   float &fHue, float &fSharpness);
 * Input:
 *  lpwds - pointer to a WINDRAWSURFACE to update
 *  fBright - brightness value from -1 to 1 (0 disables)
 *  fContrast - contrast value from -1 to 1 (0 disables)
 *  fSaturation - contrast value from -1 to 1 (0 disables)
 *  fHue - contrast value from -1 to 1 (0 disables)
 *  fSharpness - contrast value from -1 to 1 (0 disables)
 * Returns:
 *  NOERROR if OK, or the last relevant DirectDraw error code, or E_FAIL.
 */

HRESULT WinDrawSurface_GetColorControls(LPWINDRAW lpwd, LPWINDRAWSURFACE lpwds, float &fBright,
 float &fContrast, float &fSaturation, float &fHue, float &fSharpness);

 /*
 * Sets the color controls for a given surface
 * Use:
 *  HRESULT WinDrawSurface_SetColorControls(LPWINDRAWSURFACE lpwds, float fBright,
 *   float fContrast, float Saturation, float fHue, float fSharpness);
 * Input:
 *  lpwds - pointer to a WINDRAWSURFACE to update
 *  fBright - brightness value from -1 to 1 (0 disables)
 *  fContrast - contrast value from -1 to 1 (0 disables)
 *  fSaturation - contrast value from -1 to 1 (0 disables)
 *  fHue - contrast value from -1 to 1 (0 disables)
 *  fSharpness - contrast value from -1 to 1 (0 disables)
 * Returns:
 *  NOERROR if OK, or the last relevant DirectDraw error code, or E_FAIL.
 */

HRESULT WinDrawSurface_SetColorControls(LPWINDRAW lpwd, LPWINDRAWSURFACE lpwds,
 float fBright, float fContrast, float fSaturation,
 float fHue, float fSharpness);


HRESULT WinDraw_CanLockSurface (LPWINDRAW lpwd, WINDRAWSURFACE *lpwds, UCHAR* &pBuffer, int& nIndex, BOOL bBlock=TRUE);
HRESULT WinDraw_GetLockedSurface (LPWINDRAW lpwd, WINDRAWSURFACE *lpwds, UCHAR* &pBuffer, int nIndex=-1, BOOL bBlock=TRUE);
HRESULT WinDraw_ReleaseLockedSurface (LPWINDRAW lpwd, WINDRAWSURFACE *lpwds, BYTE *pHwBuf, BOOL bDiscard=FALSE);
HRESULT WinDraw_AdvanceSurface (LPWINDRAW lpwd, WINDRAWSURFACE *lpwds, int &nIndex);
HRESULT WinDraw_DisplaySurface (LPWINDRAW lpwd, WINDRAWSURFACE *lpwds, DWORD dwFlags, int nIndex=-1, BOOL bAbort=FALSE);
HRESULT WinDraw_CacelPendingDisplay (LPWINDRAW lpwd, WINDRAWSURFACE *lpwds);
HRESULT WinDraw_ResetSurfaceIndexes (LPWINDRAW lpwd, WINDRAWSURFACE *lpwds);

char*   CollectDDInfo(LPWINDRAW lpwd, LPDIRECTDRAWSURFACE lpSurface, char *pFunction, char* pSeparator);

#endif /* __WINDRAW2_H__ */

