/*
   Generic format conversion routines for the HERMES library
   Copyright (c) 1998 Christian Nentwich (c.nentwich@cs.ucl.ac.uk)
   This source code is licensed under the GNU LGPL
  
   Please refer to the file COPYING.LIB contained in the distribution for
   licensing conditions
*/

#include "HermConf.h"
#include "HeadC.h"
#include "Debug.h"


void ConvertC_Generic32_C_Generic32_A(HermesConverterInterface *iface)
{ int32 s_pixel,r,g,b;
  unsigned int count;
  char8 *source=iface->s_pixels,*dest=iface->d_pixels;
  int32 sc = iface->s_colorkey;
  int32 amask = iface->mask_a;
  DEBUG_PRINT("Converter called on line c_genrc_ca.c:21","");
  do {
    count=iface->s_width;

    do
    { s_pixel=READ32(source);
      if (s_pixel==sc)
      	WRITE32(dest,amask);
      else
      {
	r=((s_pixel>>iface->info.r_right)<<iface->info.r_left)&
	  iface->mask_r;
	g=((s_pixel>>iface->info.g_right)<<iface->info.g_left)&
	  iface->mask_g;
	b=((s_pixel>>iface->info.b_right)<<iface->info.b_left)&
	  iface->mask_b;
    
	WRITE32(dest,(r|g|b));
      }
      source+=4;
      dest+=4;
    } while(--count);

    source+=iface->s_add;
    dest+=iface->d_add;
  } while (--iface->s_height);
}


void ConvertC_Generic32_C_Generic24_A(HermesConverterInterface *iface)
{ int32 s_pixel,r,g,b;
  char8 *d_ptr=(char8 *)((int)&s_pixel);
  unsigned int count;
  char8 *source=iface->s_pixels,*dest=iface->d_pixels;
  int32 sc = iface->s_colorkey;
  int32 amask = iface->mask_a;
  DEBUG_PRINT("Converter called on line c_genrc_ca.c:57","");
  do {
    count=iface->s_width;

    do
    { s_pixel=READ32(source);
      if (s_pixel==sc)
      	s_pixel=amask;
      else 
      {
	r=((s_pixel>>iface->info.r_right)<<iface->info.r_left)&
	  iface->mask_r;
	g=((s_pixel>>iface->info.g_right)<<iface->info.g_left)&
	  iface->mask_g;
	b=((s_pixel>>iface->info.b_right)<<iface->info.b_left)&
	  iface->mask_b;
      
	s_pixel=(r|g|b);
      }
      *(dest+R_24)=*(d_ptr+R_32);
      *(dest+G_24)=*(d_ptr+G_32);
      *(dest+B_24)=*(d_ptr+B_32);

      source+=4;
      dest+=3;
    } while (--count);

    source+=iface->s_add;
    dest+=iface->d_add;
  } while (--iface->s_height);
}


void ConvertC_Generic32_C_Generic16_A(HermesConverterInterface *iface)
{ int32 s_pixel,r,g,b;
  unsigned int count;
  char8 *source=iface->s_pixels,*dest=iface->d_pixels;
  int32 sc = iface->s_colorkey;
  int32 amask = iface->mask_a;
  DEBUG_PRINT("Converter called on line c_genrc_ca.c:96","");
  do {
    count=iface->s_width>>1;

    if (count)
    do
    { 
      if (READ32(source)==sc)
	s_pixel = DWORD_BYTE0(amask);
      else
      {
	r=((READ32(source)>>iface->info.r_right)<<iface->info.r_left)&
	  iface->mask_r;
	g=((READ32(source)>>iface->info.g_right)<<iface->info.g_left)&
	  iface->mask_g;
	b=((READ32(source)>>iface->info.b_right)<<iface->info.b_left)&
	  iface->mask_b;
	
	s_pixel=DWORD_BYTE0(r|g|b);
      }

      if (READ32(source+1)==sc)
	s_pixel |= DWORD_BYTE2(amask);
      else
      {
	r=((READ32(source+1)>>iface->info.r_right)<<iface->info.r_left)&
	  iface->mask_r;           
	g=((READ32(source+1)>>iface->info.g_right)<<iface->info.g_left)&
	  iface->mask_g;           
	b=((READ32(source+1)>>iface->info.b_right)<<iface->info.b_left)&
	  iface->mask_b; 
    
	s_pixel|=DWORD_BYTE2(r|g|b);
      }

      WRITE32(dest,s_pixel);
      
      source+=8;
      dest+=4;
    } while (--count);


    /* Trailing pixel */
    
    if (iface->s_width&1) {
      if (READ32(source)==sc)
	WRITE16(dest,(short16) amask);
      else
      {
	r=((READ32(source)>>iface->info.r_right)<<iface->info.r_left)&
	  iface->mask_r;
	g=((READ32(source)>>iface->info.g_right)<<iface->info.g_left)&
	  iface->mask_g;
	b=((READ32(source)>>iface->info.b_right)<<iface->info.b_left)&
	  iface->mask_b;
	WRITE16(dest,(short16)(r|g|b));
      }
      dest+=2;
      source+=4;
    }

    source+=iface->s_add;
    dest+=iface->d_add;
  } while (--iface->s_height);
}


void ConvertC_Generic32_C_Generic8_A(HermesConverterInterface *iface)
{ int32 s_pixel,r,g,b;
  unsigned int count;
  char8 *source=iface->s_pixels,*dest=iface->d_pixels;
  int32 sc = iface->s_colorkey;
  int32 amask = iface->mask_a;
  DEBUG_PRINT("Converter called on line c_genrc_ca.c:169","");
  do {
    count=iface->s_width;

    do
    { s_pixel=READ32(source);
    
      if (s_pixel==sc)
	*(dest)=(char8) amask;
      else
      {
	r=((s_pixel>>iface->info.r_right)<<iface->info.r_left)&
	  iface->mask_r;
	g=((s_pixel>>iface->info.g_right)<<iface->info.g_left)&
	  iface->mask_g;
	b=((s_pixel>>iface->info.b_right)<<iface->info.b_left)&
	  iface->mask_b;
    
	*(dest)=(char8)(r|g|b);
      }
      source+=4;
      dest++;
    } while (--count);

    source+=iface->s_add;
    dest+=iface->d_add;
  } while (--iface->s_height);
}





void ConvertC_Generic24_C_Generic32_A(HermesConverterInterface *iface)
{ int32 s_pixel,r,g,b;
  unsigned int count;
  char8 *source=iface->s_pixels,*dest=iface->d_pixels;
  int32 sc = iface->s_colorkey;
  int32 amask = iface->mask_a;
  DEBUG_PRINT("Converter called on line c_genrc_ca.c:208","");
  do {
    count=iface->s_width;

    do
    { 
      s_pixel=(((int32)*(source+R_24))<<16)|
              (((int32)*(source+G_24))<<8)|
              ((int32)*(source+B_24));
    
      if (s_pixel==sc)
	WRITE32(dest,amask);
      else
      {
	r=((s_pixel>>iface->info.r_right)<<iface->info.r_left)&
	  iface->mask_r;
	g=((s_pixel>>iface->info.g_right)<<iface->info.g_left)&
	  iface->mask_g;
	b=((s_pixel>>iface->info.b_right)<<iface->info.b_left)&
	  iface->mask_b;
    
	WRITE32(dest,(r|g|b));
      }
      source+=3;
      dest+=4;
    } while (--count);

    source+=iface->s_add;
    dest+=iface->d_add;
  } while (--iface->s_height);
}


void ConvertC_Generic24_C_Generic24_A(HermesConverterInterface *iface)
{ int32 s_pixel,r,g,b;
  char8 *d_ptr=(char8 *)&s_pixel;
  unsigned int count;
  char8 *source=iface->s_pixels,*dest=iface->d_pixels;
  int32 sc = iface->s_colorkey;
  int32 amask = iface->mask_a;
  DEBUG_PRINT("Converter called on line c_genrc_ca.c:248","");
  do {
    count=iface->s_width;

    do
    { 
      s_pixel=(((int32)*(source+R_24))<<16)|
              (((int32)*(source+G_24))<<8)|
               ((int32)*(source+B_24));
    
      if (s_pixel==sc)
	s_pixel = amask;
      else
      {
	r=((s_pixel<<iface->info.r_left)>>iface->info.r_right)&
	  iface->mask_r;
	g=((s_pixel<<iface->info.g_left)>>iface->info.g_right)&
	  iface->mask_g;
	b=((s_pixel<<iface->info.b_left)>>iface->info.b_right)&
	  iface->mask_b;

	s_pixel=(r|g|b);
      }
      *(dest+R_24)=*(d_ptr+R_32);
      *(dest+G_24)=*(d_ptr+G_32);
      *(dest+B_24)=*(d_ptr+B_32);
    
      source+=3;
      dest+=3;
    } while (--count);

    source+=iface->s_add;
    dest+=iface->d_add;
  } while (iface->s_height--);
}



void ConvertC_Generic24_C_Generic16_A(HermesConverterInterface *iface)
{ int32 s_pixel,r,g,b;
  unsigned int count;
  char8 *source=iface->s_pixels,*dest=iface->d_pixels;
  int32 sc = iface->s_colorkey;
  int32 amask = iface->mask_a;
  DEBUG_PRINT("Converter called on line c_genrc_ca.c:292","");
  do {
    count=iface->s_width;

    do
    { 
      s_pixel=(((int32)*(source+R_24))<<16)|
              (((int32)*(source+G_24))<<8)|
               ((int32)*(source+B_24));

      if (s_pixel==sc)
	WRITE16(dest,(short16) amask);
      else
      {
	r=((s_pixel>>iface->info.r_right)<<iface->info.r_left)&
	  iface->mask_r;
	g=((s_pixel>>iface->info.g_right)<<iface->info.g_left)&
	  iface->mask_g;
	b=((s_pixel>>iface->info.b_right)<<iface->info.b_left)&
	  iface->mask_b;
	
	WRITE16(dest,(short16)(r|g|b));
      }
      source+=3;
      dest+=2;
    } while (--count);

    source+=iface->s_add;
    dest+=iface->d_add;
  } while (--iface->s_height);
}


void ConvertC_Generic24_C_Generic8_A(HermesConverterInterface *iface)
{ int32 s_pixel,r,g,b;
  unsigned int count;
  char8 *source=iface->s_pixels,*dest=iface->d_pixels;
  int32 sc = iface->s_colorkey;
  int32 amask = iface->mask_a;
  DEBUG_PRINT("Converter called on line c_genrc_ca.c:331","");
  do {
    count=iface->s_width;

    do
    { s_pixel=(((int32)*(source+R_24))<<16)|
              (((int32)*(source+G_24))<<8)|
               ((int32)*(source+B_24));

      if (s_pixel==sc)
	*(dest)=(char8) amask;
      else
      {
	r=((s_pixel>>iface->info.r_right)<<iface->info.r_left)&
	  iface->mask_r;
	g=((s_pixel>>iface->info.g_right)<<iface->info.g_left)&
	  iface->mask_g;
	b=((s_pixel>>iface->info.b_right)<<iface->info.b_left)&
	  iface->mask_b;
	
	*(dest)=(char8)(r|g|b);
      }
      source+=3;
      dest++;
    } while (--count);

    source+=iface->s_add;
    dest+=iface->d_add;
  } while (--iface->s_height);
}




void ConvertC_Generic16_C_Generic32_A(HermesConverterInterface *iface)
{ int32 s_pixel,r,g,b;
  unsigned int count;
  char8 *source=iface->s_pixels,*dest=iface->d_pixels;
  int32 sc = iface->s_colorkey;
  int32 amask = iface->mask_a;
  DEBUG_PRINT("Converter called on line c_genrc_ca.c:371","");
  do {
    count=iface->s_width;

    do
    { s_pixel=(int32)READ16(source);
      
      if(s_pixel==sc)
	WRITE32(dest,amask);
      else
      {
	r=((s_pixel>>iface->info.r_right)<<iface->info.r_left)&
	  iface->mask_r;
	g=((s_pixel>>iface->info.g_right)<<iface->info.g_left)&
	  iface->mask_g;
	b=((s_pixel>>iface->info.b_right)<<iface->info.b_left)&
	  iface->mask_b;
	
	WRITE32(dest,(r|g|b));
      }
      source+=2;
      dest+=4;
    } while (--count);

    source+=iface->s_add;
    dest+=iface->d_add;
  } while (--iface->s_height);
}


void ConvertC_Generic16_C_Generic24_A(HermesConverterInterface *iface)
{ int32 s_pixel,r,g,b;
  char8 *d_ptr=(char8 *)((int)&s_pixel);
  unsigned int count;
  char8 *source=iface->s_pixels,*dest=iface->d_pixels;
  int32 sc = iface->s_colorkey;
  int32 amask = iface->mask_a;
  DEBUG_PRINT("Converter called on line c_genrc_ca.c:408","");
  do {
    count=iface->s_width;

    do
    { s_pixel=(int32)READ16(source);

      if (s_pixel==sc)
	s_pixel= amask;
      else
      {
	r=((s_pixel>>iface->info.r_right)<<iface->info.r_left)&
	  iface->mask_r;
	g=((s_pixel>>iface->info.g_right)<<iface->info.g_left)&
	  iface->mask_g;
	b=((s_pixel>>iface->info.b_right)<<iface->info.b_left)&
	  iface->mask_b;
    
	s_pixel=(r|g|b);
      }
      *(dest+R_24)=*(d_ptr+R_32);
      *(dest+G_24)=*(d_ptr+G_32);
      *(dest+B_24)=*(d_ptr+B_32);

      source+=2;
      dest+=3;
    } while (--count);

    source+=iface->s_add;
    dest+=iface->d_add;
  } while (--iface->s_height);
}


void ConvertC_Generic16_C_Generic16_A(HermesConverterInterface *iface)
{ int32 s_pixel,r,g,b;
  unsigned int count;
  char8 *source=iface->s_pixels,*dest=iface->d_pixels;
  int32 sc = iface->s_colorkey;
  int32 amask = iface->mask_a;
  DEBUG_PRINT("Converter called on line c_genrc_ca.c:448","");
  do {
    count=iface->s_width;

    do
    { s_pixel=(int32)READ16(source);

      if (s_pixel==sc)
	WRITE16(dest,(short16) amask);
      else
      {
	r=((s_pixel>>iface->info.r_right)<<iface->info.r_left)&
	  iface->mask_r;
	g=((s_pixel>>iface->info.g_right)<<iface->info.g_left)&
	  iface->mask_g;
	b=((s_pixel>>iface->info.b_right)<<iface->info.b_left)&
	  iface->mask_b;
    
	WRITE16(dest,(short16)(r|g|b));
      }
      source+=2;
      dest+=2;
    } while(--count);

    source+=iface->s_add;
    dest+=iface->d_add;
  } while (--iface->s_height);
}


void ConvertC_Generic16_C_Generic8_A(HermesConverterInterface *iface)
{ int32 s_pixel,r,g,b;
  unsigned int count;
  char8 *source=iface->s_pixels,*dest=iface->d_pixels;
  int32 sc = iface->s_colorkey;
  int32 amask = iface->mask_a;
  DEBUG_PRINT("Converter called on line c_genrc_ca.c:484","");
  do {
    count=iface->s_width;

    do
    { s_pixel=(int32)READ16(source);

      if (s_pixel==sc)
	*dest=(char8) amask;
      else
      {
	r=((s_pixel>>iface->info.r_right)<<iface->info.r_left)&
	  iface->mask_r;
	g=((s_pixel>>iface->info.g_right)<<iface->info.g_left)&
	  iface->mask_g;
	b=((s_pixel>>iface->info.b_right)<<iface->info.b_left)&
	  iface->mask_b;
    
	*dest=(char8)(r|g|b);
      }
      source+=2;
      dest++;
    } while (--count);

    source+=iface->s_add;
    dest+=iface->d_add;
  } while (--iface->s_height);
}


/* -------------------------------------------------------------------------

                              STRETCH CONVERTERS
   
   ------------------------------------------------------------------------- */


void ConvertC_Generic32_C_Generic32_A_S(HermesConverterInterface *iface)
{ int32 s_pixel,r,g,b;
  unsigned int count;
  char8 *source,*dest=iface->d_pixels;
  unsigned int dy=(iface->s_height<<16)/iface->d_height;
  unsigned int dx=(iface->s_width<<16)/iface->d_width;
  unsigned int y=0,x;
  int32 sc = iface->s_colorkey;
  int32 amask = iface->mask_a;
  DEBUG_PRINT("Converter called on line c_genrc_ca.c:530","");
  do {
    count=iface->d_width;
    x=0;
    source=iface->s_pixels;

    do
    { s_pixel=READ32(source+(x>>16));
     
      if (s_pixel==sc)
	WRITE32(dest, amask);
      else
      {
	r=((s_pixel>>iface->info.r_right)<<iface->info.r_left)&
	  iface->mask_r;
	g=((s_pixel>>iface->info.g_right)<<iface->info.g_left)&
	  iface->mask_g;
	b=((s_pixel>>iface->info.b_right)<<iface->info.b_left)&
	  iface->mask_b;
    
	WRITE32(dest,(r|g|b));
      }
      x+=dx;
      dest+=4;
    } while(--count);
    
    dest+=iface->d_add;
    
    y+=dy;
    source+=(y>>16)*iface->s_pitch;
    y &= (1<<16)-1;

  } while (--iface->d_height);
}


void ConvertC_Generic32_C_Generic16_A_S(HermesConverterInterface *iface)
{ int32 s_pixel,r,g,b;
  unsigned int count;
  int32 *source=(int32*)iface->s_pixels;
  char8 *dest=iface->d_pixels;
  unsigned int dy=(iface->s_height<<16)/iface->d_height;
  unsigned int dx=(iface->s_width<<16)/iface->d_width;
  unsigned int y=0,x;
  int32 sc = iface->s_colorkey;
  int32 amask = iface->mask_a;
  DEBUG_PRINT("Converter called on line c_genrc_ca.c:576","");
  DEBUG_FNAME("ConvertC_Generic32_Generic16_S")

  do {

    count=iface->d_width;
    x=0;

    do
    { s_pixel=*(source+(x>>16));
      if (s_pixel==sc)
	WRITE16(dest,(short16) amask);
      else
      {
	r=((s_pixel>>iface->info.r_right)<<iface->info.r_left)&
	  iface->mask_r;
	g=((s_pixel>>iface->info.g_right)<<iface->info.g_left)&
	  iface->mask_g;
	b=((s_pixel>>iface->info.b_right)<<iface->info.b_left)&
	  iface->mask_b;
    
	WRITE16(dest,(short16)(r|g|b));
      }
      x+=dx;
      dest+=2;
    } while (--count);
    
    dest+=iface->d_add;

    y+=dy;
      
    source=(int32*)((char8*)source+(y>>16)*iface->s_pitch);
    y &= 0xffff;
  } while (--iface->d_height);
}
