/* 
 * ### Copyright (C) 2001-2007 Michael Fuchs ###
 * ### All Rights Reserved.             ###
 *
 * Author: Michael Fuchs
 * E-Mail: michael.fuchs@unico-group.com
 * URL:    http://www.michael-a-fuchs.de
 */
package org.dbdoclet.trafo.html.docbook.editor.javadoc;

import org.dbdoclet.trafo.html.docbook.editor.Editor;
import org.dbdoclet.trafo.html.docbook.editor.EditorInstruction;
import org.dbdoclet.trafo.tag.docbook.DocBookTagFactory;

public class CodeEditor extends Editor {

    @Override
    public EditorInstruction edit(EditorInstruction values) {

	setValues(values);
	DocBookTagFactory dbfactory = values.getTagFactory();

	org.dbdoclet.trafo.tag.javadoc.Code code = (org.dbdoclet.trafo.tag.javadoc.Code) getHtmlElement();
	getCurrent().appendChild(dbfactory.createComputerOutput(code.getTextContent()));

	traverse(false);

	return finalizeValues();
    }
}
